/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientFactory;
import com.terracotta.connection.TerracottaInternalClientFactoryImpl;
import com.terracotta.connection.api.DetailedConnectionException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;
import org.terracotta.entity.EndpointConnector;

abstract class AbstractConnectionService
implements ConnectionService {
    private final List<String> scheme;
    private final EndpointConnector endpointConnector;
    private final TerracottaInternalClientFactory clientFactory;

    AbstractConnectionService(List<String> scheme) {
        this(scheme, new EndpointConnectorImpl(), new TerracottaInternalClientFactoryImpl());
    }

    AbstractConnectionService(List<String> scheme, EndpointConnector endpointConnector, TerracottaInternalClientFactory clientFactory) {
        this.scheme = scheme;
        this.endpointConnector = endpointConnector;
        this.clientFactory = clientFactory;
    }

    @Override
    public boolean handlesURI(URI uri) {
        return this.handlesConnectionType(uri.getScheme());
    }

    @Override
    public boolean handlesConnectionType(String connectionType) {
        return this.scheme.stream().filter(c -> c.equalsIgnoreCase(connectionType)).findAny().isPresent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Connection connect(URI uri, Properties properties) throws ConnectionException {
        String[] hosts;
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
        for (String string : hosts = uri.getSchemeSpecificPart().split(",")) {
            URI oneHost;
            if (0 != string.indexOf("//")) {
                String string2 = "//" + string;
            }
            try {
                void var8_8;
                oneHost = new URI((String)var8_8).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse uri " + uri, e);
            }
            int port = Math.max(oneHost.getPort(), 0);
            serverAddresses.add(InetSocketAddress.createUnresolved(oneHost.getHost(), port));
        }
        return this.createConnection(uri.getScheme(), serverAddresses, properties);
    }

    @Override
    public final Connection connect(Iterable<InetSocketAddress> serverAddresses, Properties properties) throws ConnectionException {
        String connectionType = properties.getProperty("connection.type", this.scheme.get(0));
        if (!this.handlesConnectionType(connectionType)) {
            throw new IllegalArgumentException("Unknown connectionType " + connectionType);
        }
        return this.createConnection(connectionType, serverAddresses, properties);
    }

    private Connection createConnection(String type, Iterable<InetSocketAddress> serverAddresses, Properties properties) throws DetailedConnectionException {
        TerracottaInternalClient client = this.clientFactory.createL1Client(type, serverAddresses, properties);
        properties.put("connection", serverAddresses);
        client.init();
        return new TerracottaConnection(properties, client::getClientEntityManager, this.endpointConnector, client::shutdown);
    }
}

