/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TCServiceLoader {
    private static Provider IMPL;

    static void setImplementation(Provider impl) {
        IMPL = impl;
    }

    public static <T> Collection<? extends T> loadServices(Class<T> serviceClass, ClassLoader loader) {
        return TCServiceLoader.getImpl().getImplementations(serviceClass, loader);
    }

    public static <T> Collection<? extends T> loadServices(Class<T> serviceClass) {
        return TCServiceLoader.getImpl().getImplementations(serviceClass, serviceClass.getClassLoader());
    }

    private static Provider getImpl() {
        return IMPL == null ? TCServiceLoader.loadServiceProvider() : IMPL;
    }

    private static Provider createDefault() {
        return new Provider(){

            @Override
            public <T> Collection<? extends T> getImplementations(Class<T> serviceClass, ClassLoader loader) {
                return StreamSupport.stream(ServiceLoader.load(serviceClass, loader).spliterator(), false).collect(Collectors.toList());
            }
        };
    }

    private static Provider loadServiceProvider() {
        ServiceLoader<Provider> p = ServiceLoader.load(Provider.class);
        Iterator<Provider> ip = p.iterator();
        if (ip.hasNext()) {
            IMPL = ip.next();
            return IMPL;
        }
        IMPL = TCServiceLoader.createDefault();
        return IMPL;
    }

    static interface Provider {
        public <T> Collection<? extends T> getImplementations(Class<T> var1, ClassLoader var2);
    }
}

