/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.ClearTextSocketEndpointFactory;
import com.tc.net.core.DefaultSocketEndpointFactory;
import com.tc.net.core.ProductID;
import com.tc.net.core.SocketEndpointFactory;
import com.tc.net.core.SocketEndpointFactorySupplier;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.StandardClientBuilder;
import com.terracotta.diagnostic.DiagnosticClientBuilder;
import java.util.Properties;

public class StandardClientBuilderFactory
implements ClientBuilderFactory {
    private final String scheme;
    private final SocketEndpointFactorySupplier supplier;

    public StandardClientBuilderFactory(String scheme) {
        DefaultSocketEndpointFactory.setSocketEndpointFactory(new ClearTextSocketEndpointFactory());
        SocketEndpointFactorySupplier base = ClientBuilderFactory.get(SocketEndpointFactorySupplier.class);
        this.scheme = scheme;
        this.supplier = base == null ? p -> new ClearTextSocketEndpointFactory() : p -> {
            SocketEndpointFactory factory = base.createSocketEndpointFactory(p);
            if (factory == null) {
                return new ClearTextSocketEndpointFactory();
            }
            return factory;
        };
    }

    @Override
    public ClientBuilder create(Properties connectionProperties) {
        String type = connectionProperties.getProperty("connection.type", this.scheme);
        if (type.equalsIgnoreCase("diagnostic")) {
            return new DiagnosticClientBuilder(connectionProperties, this.supplier.createSocketEndpointFactory(connectionProperties));
        }
        if (type.equalsIgnoreCase("terracotta")) {
            return new StandardClientBuilder(connectionProperties, this.supplier.createSocketEndpointFactory(connectionProperties));
        }
        for (ProductID pid : ProductID.values()) {
            if (!pid.name().equalsIgnoreCase(type)) continue;
            return new StandardClientBuilder(connectionProperties, this.supplier.createSocketEndpointFactory(connectionProperties));
        }
        throw new IllegalArgumentException(type + " is not a valid connection type");
    }
}

