/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.basic;

import com.tc.net.basic.BasicConnection;
import com.tc.net.core.SocketEndpointFactory;
import com.tc.net.core.TCComm;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCListener;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.TCProtocolAdaptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BasicConnectionManager
implements TCConnectionManager {
    private final Set<TCConnection> connections = new HashSet<TCConnection>();
    private final SocketEndpointFactory buffers;
    private final String id;

    public BasicConnectionManager(String id, SocketEndpointFactory buffers) {
        this.buffers = buffers;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCConnection createConnection(TCProtocolAdaptor adaptor) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            BasicConnection basic = new BasicConnection(this.id, adaptor, this.buffers, conn -> {
                Set<TCConnection> set = this.connections;
                synchronized (set) {
                    this.connections.remove(conn);
                }
            });
            this.connections.add(basic);
            return basic;
        }
    }

    @Override
    public TCListener createListener(InetSocketAddress addr, ProtocolAdaptorFactory factory) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TCListener createListener(InetSocketAddress addr, ProtocolAdaptorFactory factory, int backlog, boolean reuseAddr) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeAllConnections() {
        Arrays.asList(this.getAllConnections()).forEach(c -> c.close());
    }

    @Override
    public void asynchCloseAllConnections() {
        Arrays.asList(this.getAllConnections()).forEach(c -> c.asynchClose());
    }

    @Override
    public void closeAllListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void shutdown() {
        this.asynchCloseAllConnections();
    }

    @Override
    public synchronized TCConnection[] getAllConnections() {
        TCConnection[] all = new TCConnection[this.connections.size()];
        return this.connections.toArray(all);
    }

    @Override
    public TCListener[] getAllListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TCComm getTcComm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, ?> getStateMap() {
        return new LinkedHashMap();
    }

    @Override
    public int getBufferCount() {
        return 0;
    }
}

