/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.model.Permission;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.RawPath;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.SettingValidator;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.Version;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Setting {
    NODE_UID("node-uid", EnumSet.of(Version.V2), false, UID::newUID, Scope.NODE, Setting.fromNode(Node::getUID), Setting.intoNode((o, value) -> o.setUID(UID.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE, Requirement.HIDDEN)),
    STRIPE_UID("stripe-uid", EnumSet.of(Version.V2), false, UID::newUID, Scope.STRIPE, Setting.fromStripe(Stripe::getUID), Setting.intoStripe((o, value) -> o.setUID(UID.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atLevels(Scope.CLUSTER, Scope.STRIPE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.STRIPE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE, Requirement.HIDDEN)),
    CLUSTER_UID("cluster-uid", EnumSet.of(Version.V2), false, UID::newUID, Scope.CLUSTER, Setting.fromCluster(Cluster::getUID), Setting.intoCluster((o, value) -> o.setUID(UID.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE, Requirement.HIDDEN)),
    NODE_NAME("name", EnumSet.of(Version.V1, Version.V2), false, () -> "node-" + UID.newUID(), Scope.NODE, Setting.fromNode(Node::getName), Setting.intoNode(Node::setName), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.NAME_VALIDATOR.accept("name", Tuple2.tuple2(key, value))),
    STRIPE_NAME("stripe-name", EnumSet.of(Version.V2), false, () -> "stripe-" + UID.newUID(), Scope.STRIPE, Setting.fromStripe(Stripe::getName), Setting.intoStripe(Stripe::setName), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atLevels(Scope.CLUSTER, Scope.STRIPE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.IMPORT).atLevel(Scope.STRIPE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.NAME_VALIDATOR.accept("stripe-name", Tuple2.tuple2(key, value))),
    NODE_HOSTNAME("hostname", EnumSet.of(Version.V1, Version.V2), false, Setting.always("%h"), Scope.NODE, Setting.fromNode(Node::getHostname), Setting.intoNode(Node::setHostname), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("hostname", Tuple2.tuple2(key, value))),
    NODE_PORT("port", EnumSet.of(Version.V1, Version.V2), false, Setting.always(9410), Scope.NODE, Setting.fromNode(Node::getPort), Setting.intoNode((node, value) -> node.setPort(Integer.parseInt(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("port", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_HOSTNAME("public-hostname", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getPublicHostname), Setting.intoNode(Node::setPublicHostname), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("public-hostname", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_PORT("public-port", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getPublicPort), Setting.intoNode((node, value) -> node.setPublicPort(value == null ? null : Integer.valueOf(Integer.parseInt(value)))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("public-port", Tuple2.tuple2(key, value))),
    NODE_GROUP_PORT("group-port", EnumSet.of(Version.V1, Version.V2), false, Setting.always(9430), Scope.NODE, Setting.fromNode(Node::getGroupPort), Setting.intoNode((node, value) -> node.setGroupPort(value == null ? null : Integer.valueOf(Integer.parseInt(value)))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("group-port", Tuple2.tuple2(key, value))),
    NODE_BIND_ADDRESS("bind-address", EnumSet.of(Version.V1, Version.V2), false, Setting.always("0.0.0.0"), Scope.NODE, Setting.fromNode(Node::getBindAddress), Setting.intoNode(Node::setBindAddress), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("bind-address", Tuple2.tuple2(key, value))),
    NODE_GROUP_BIND_ADDRESS("group-bind-address", EnumSet.of(Version.V1, Version.V2), false, Setting.always("0.0.0.0"), Scope.NODE, Setting.fromNode(Node::getGroupBindAddress), Setting.intoNode(Node::setGroupBindAddress), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("group-bind-address", Tuple2.tuple2(key, value))),
    CLUSTER_NAME("cluster-name", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getName), Setting.intoCluster(Cluster::setName), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allowAnyOperations().atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.NAME_VALIDATOR.accept("cluster-name", Tuple2.tuple2(key, value))),
    LOCK_CONTEXT("lock-context", EnumSet.of(Version.V2), false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getConfigurationLockContext), Setting.intoCluster((cluster, context) -> cluster.setConfigurationLockContext(context != null ? LockContext.from(context) : null)), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.HIDDEN)),
    NODE_CONFIG_DIR("config-dir", EnumSet.of(Version.V1, Version.V2), false, Setting.always(RawPath.valueOf(Paths.get("%H", "terracotta", "config").toString())), Scope.NODE, o -> Optional.empty(), Setting.noop(), Collections.emptyList(), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("config-dir", Tuple2.tuple2(key, value))),
    NODE_HOME_DIR("server-home", EnumSet.of(Version.V2), false, Setting.always(System.getProperty("user.dir")), Scope.NODE, o -> Optional.empty(), Setting.noop(), Collections.emptyList(), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("server-home", Tuple2.tuple2(key, value))),
    NODE_METADATA_DIR("metadata-dir", EnumSet.of(Version.V1, Version.V2), false, Setting.always(RawPath.valueOf(Paths.get("%H", "terracotta", "metadata").toString())), Scope.NODE, Setting.fromNode(Node::getMetadataDir), Setting.intoNode((node, value) -> node.setMetadataDir(value == null ? null : RawPath.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atAnyLevels()), EnumSet.of(Requirement.NODE_RESTART, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("metadata-dir", Tuple2.tuple2(key, value))),
    NODE_LOG_DIR("log-dir", EnumSet.of(Version.V1, Version.V2), false, () -> Boolean.getBoolean("terracotta.config.logDir.noDefault") ? null : RawPath.valueOf(Paths.get("%H", "terracotta", "logs").toString()), Scope.NODE, Setting.fromNode(Node::getLogDir), Setting.intoNode((node, value) -> node.setLogDir(value == null ? null : RawPath.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.NODE_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("log-dir", Tuple2.tuple2(key, value))),
    NODE_BACKUP_DIR("backup-dir", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.NODE, (Function)Setting.fromNode(Node::getBackupDir), (BiConsumer)Setting.intoNode((node, value) -> node.setBackupDir(value == null ? null : RawPath.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), (EnumSet)EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("backup-dir", Tuple2.tuple2(key, value))){

        @Override
        public boolean vetoRuntimeChange(NodeContext currentNode, Configuration configuration) {
            boolean vetoed;
            if (this == configuration.getSetting()) {
                String current = currentNode.getNode().getBackupDir().map(RawPath::getValue).orElse(null);
                vetoed = !configuration.getValue().isPresent() || current != null && !Objects.equals(configuration.getValue().get(), current);
            } else {
                vetoed = super.vetoRuntimeChange(currentNode, configuration);
            }
            LoggerFactory.getLogger(Setting.class).trace("vetoRuntimeChange({}, {}): {}", new Object[]{configuration, currentNode.getNode(), vetoed});
            return vetoed;
        }
    }
    ,
    TC_PROPERTIES("tc-properties", EnumSet.of(Version.V1, Version.V2), true, Setting.always(Collections.emptyMap()), Scope.NODE, Setting.fromNode(Node::getTcProperties), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetTcProperties();
            } else {
                node.setTcProperties(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeTcProperty((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setTcProperties(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.putTcProperty(kv[0], kv[1]));
        } else {
            node.putTcProperty((String)tuple.t1, (String)tuple.t2);
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.NODE_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PROPS_VALIDATOR.accept("tc-properties", Tuple2.tuple2(key, value))),
    NODE_LOGGER_OVERRIDES("logger-overrides", EnumSet.of(Version.V1, Version.V2), true, Setting.always(Collections.emptyMap()), Scope.NODE, Setting.fromNode(Node::getLoggerOverrides), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetLoggerOverrides();
            } else {
                node.setLoggerOverrides(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeLoggerOverride((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setLoggerOverrides(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.putLoggerOverride(kv[0], kv[1].toUpperCase(Locale.ROOT)));
        } else {
            node.putLoggerOverride((String)tuple.t1, ((String)tuple.t2).toUpperCase(Locale.ROOT));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.LOGGER_LEVEL_VALIDATOR.accept("logger-overrides", Tuple2.tuple2(key, value))),
    CLIENT_RECONNECT_WINDOW("client-reconnect-window", EnumSet.of(Version.V1, Version.V2), false, Setting.always(Measure.of(120L, TimeUnit.SECONDS)), Scope.CLUSTER, Setting.fromCluster(Cluster::getClientReconnectWindow), Setting.intoCluster((cluster, value) -> cluster.setClientReconnectWindow(value == null ? null : Measure.parse(value, TimeUnit.class))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-reconnect-window", Tuple2.tuple2(key, value))),
    FAILOVER_PRIORITY("failover-priority", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getFailoverPriority), Setting.intoCluster((cluster, value) -> cluster.setFailoverPriority(value == null ? null : FailoverPriority.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allowAnyOperations().atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.CLUSTER_ONLINE, Requirement.CLUSTER_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DEFAULT_VALIDATOR.andThen((k, v) -> FailoverPriority.valueOf((String)v.t2)).accept("failover-priority", Tuple2.tuple2(key, value))),
    CLIENT_LEASE_DURATION("client-lease-duration", EnumSet.of(Version.V1, Version.V2), false, Setting.always(Measure.of(150L, TimeUnit.SECONDS)), Scope.CLUSTER, Setting.fromCluster(Cluster::getClientLeaseDuration), Setting.intoCluster((cluster, value) -> cluster.setClientLeaseDuration(value == null ? null : Measure.parse(value, TimeUnit.class))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Arrays.asList(TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-lease-duration", Tuple2.tuple2(key, value))),
    LICENSE_FILE("license-file", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.CLUSTER, o -> Optional.empty(), Setting.noop(), Collections.singletonList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("license-file", Tuple2.tuple2(key, value))),
    SECURITY_DIR("security-dir", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getSecurityDir), Setting.intoNode((node, value) -> node.setSecurityDir(value == null ? null : RawPath.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.NODE_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("security-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUDIT_LOG_DIR("audit-log-dir", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getSecurityAuditLogDir), Setting.intoNode((node, value) -> node.setSecurityAuditLogDir(value == null ? null : RawPath.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.NODE_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("audit-log-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUTHC("authc", EnumSet.of(Version.V1, Version.V2), false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecurityAuthc), Setting.intoCluster(Cluster::setSecurityAuthc), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.CLUSTER_ONLINE, Requirement.CLUSTER_RESTART), Arrays.asList("file", "ldap", "certificate")),
    SECURITY_SSL_TLS("ssl-tls", EnumSet.of(Version.V1, Version.V2), false, Setting.always(false), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecuritySslTls), Setting.intoCluster((cluster, value) -> cluster.setSecuritySslTls(value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.CLUSTER_ONLINE, Requirement.CLUSTER_RESTART, Requirement.PRESENCE), Arrays.asList("true", "false")),
    SECURITY_WHITELIST("whitelist", EnumSet.of(Version.V1, Version.V2), false, Setting.always(false), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecurityWhitelist), Setting.intoCluster((cluster, value) -> cluster.setSecurityWhitelist(value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.CLUSTER_ONLINE, Requirement.CLUSTER_RESTART, Requirement.PRESENCE), Arrays.asList("true", "false")),
    OFFHEAP_RESOURCES("offheap-resources", EnumSet.of(Version.V1, Version.V2), true, Setting.always(Collections.singletonMap("main", Measure.of(512L, MemoryUnit.MB))), Scope.CLUSTER, Setting.fromCluster(Cluster::getOffheapResources), Setting.intoClusterMap((cluster, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                cluster.unsetOffheapResources();
            } else {
                cluster.setOffheapResources(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            cluster.removeOffheapResource((String)tuple.t1);
        } else if (tuple.t1 == null) {
            cluster.setOffheapResources(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> cluster.putOffheapResource(kv[0], Measure.parse(kv[1], MemoryUnit.class)));
        } else {
            cluster.putOffheapResource((String)tuple.t1, Measure.parse((String)tuple.t2, MemoryUnit.class));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allowAnyOperations().atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Arrays.asList(MemoryUnit.values()), (key, value) -> SettingValidator.OFFHEAP_VALIDATOR.accept("offheap-resources", Tuple2.tuple2(key, value))),
    DATA_DIRS("data-dirs", EnumSet.of(Version.V1, Version.V2), true, Setting.always(Collections.singletonMap("main", RawPath.valueOf(Paths.get("%H", "terracotta", "user-data", "main").toString()))), Scope.NODE, (Function)Setting.fromNode(Node::getDataDirs), (BiConsumer)Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetDataDirs();
            } else {
                node.setDataDirs(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeDataDir((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setDataDirs(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).forEach(kv -> {
                int firstColon = kv.indexOf(":");
                node.putDataDir(kv.substring(0, firstColon), RawPath.valueOf(kv.substring(firstColon + 1)));
            });
        } else {
            node.putDataDir((String)tuple.t1, RawPath.valueOf((String)tuple.t2));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED, ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET).atAnyLevels()), (EnumSet)EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DATA_DIRS_VALIDATOR.accept("data-dirs", Tuple2.tuple2(key, value))){

        @Override
        public boolean vetoRuntimeChange(NodeContext currentNode, Configuration configuration) {
            boolean vetoed = false;
            if (this == configuration.getSetting() && currentNode.getNode().getDataDirs().orDefault().containsKey(configuration.getKey())) {
                String current = currentNode.getNode().getDataDirs().orDefault().get(configuration.getKey()).getValue();
                vetoed = current != null && !Objects.equals(configuration.getValue().get(), current);
            }
            LoggerFactory.getLogger(Setting.class).trace("vetoRuntimeChange({}, {}): {}", new Object[]{configuration, currentNode.getNode(), vetoed});
            return vetoed;
        }
    };

    private final String name;
    private final Collection<Version> versions;
    private final boolean map;
    private final Supplier<Object> defaultValue;
    private final Scope scope;
    private final Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor;
    private final Collection<Permission> permissions;
    private final Collection<Requirement> requirements;
    private final Collection<String> allowedValues;
    private final Collection<? extends Enum<?>> allowedUnits;
    private final BiConsumer<String, String> validator;
    private final BiConsumer<PropertyHolder, Tuple2<String, String>> setter;

    private Setting(String name, Collection<Version> versions, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements) {
        this(name, versions, map, defaultValue, scope, extractor, setter, permissions, requirements, Collections.emptyList(), Collections.emptyList());
    }

    private Setting(String name, Collection<Version> versions, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues) {
        this(name, versions, map, defaultValue, scope, extractor, setter, permissions, requirements, allowedValues, Collections.emptyList());
    }

    private Setting(String name, Collection<Version> versions, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits) {
        this(name, versions, map, defaultValue, scope, extractor, setter, permissions, requirements, allowedValues, allowedUnits, (key, value) -> SettingValidator.DEFAULT_VALIDATOR.accept(name, Tuple2.tuple2(key, value)));
    }

    private Setting(String name, Collection<Version> versions, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits, BiConsumer<String, String> validator) {
        this.name = Objects.requireNonNull(name);
        this.versions = versions;
        this.map = map;
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.scope = Objects.requireNonNull(scope);
        this.extractor = Objects.requireNonNull(extractor);
        this.setter = Objects.requireNonNull(setter);
        this.permissions = new LinkedHashSet<Permission>(Objects.requireNonNull(permissions));
        this.requirements = Objects.requireNonNull(requirements);
        this.allowedValues = Collections.unmodifiableSet(new LinkedHashSet<String>(Objects.requireNonNull(allowedValues)));
        this.allowedUnits = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(allowedUnits)));
        this.validator = Objects.requireNonNull(validator);
        if (scope == Scope.CLUSTER && permissions.stream().anyMatch(permission -> permission.allows(Scope.NODE) || permission.allows(Scope.STRIPE))) {
            throw new AssertionError((Object)("Scope error for setting " + name + ": " + permissions));
        }
        if (scope == Scope.STRIPE && permissions.stream().anyMatch(permission -> permission.allows(Scope.NODE))) {
            throw new AssertionError((Object)("Scope error for setting " + name + ": " + permissions));
        }
    }

    public String toString() {
        return this.name;
    }

    public Collection<Version> getVersions() {
        return this.versions;
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isMap() {
        return this.map;
    }

    public <T> T getDefaultValue() {
        return (T)this.defaultValue.get();
    }

    public Optional<String> getDefaultProperty() {
        return Setting.toProperty(this.defaultValue.get());
    }

    public Collection<String> getAllowedValues() {
        return this.allowedValues;
    }

    public <U extends Enum<U>> Collection<U> getAllowedUnits() {
        return this.allowedUnits;
    }

    public boolean requires(Requirement requirement) {
        return this.requirements.contains((Object)requirement);
    }

    public boolean allows(Scope scope) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(scope));
    }

    public boolean allows(Operation operation) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(operation));
    }

    public boolean allows(ClusterState clusterState) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(clusterState));
    }

    public boolean allows(Operation operation, Scope scope) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(operation) && permissions.allows(scope));
    }

    public boolean allows(ClusterState clusterState, Operation operation) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(operation) && permissions.allows(clusterState));
    }

    public boolean allows(ClusterState clusterState, Operation operation, Scope scope) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(clusterState) && permissions.allows(operation) && permissions.allows(scope));
    }

    private boolean isUserExportable() {
        return !this.requires(Requirement.HIDDEN) && this.permissions.stream().anyMatch(Permission::isUserExportable);
    }

    public boolean mustBePresent() {
        return this.requires(Requirement.PRESENCE);
    }

    public boolean mustBeProvided() {
        return this.requires(Requirement.CONFIG);
    }

    public boolean isWritable() {
        return this.isWritableWhen(ClusterState.CONFIGURING) || this.isWritableWhen(ClusterState.ACTIVATED);
    }

    public boolean isWritableWhen(ClusterState clusterState) {
        return this.permissions.stream().anyMatch(permission -> permission.isWritableWhen(clusterState));
    }

    public boolean isScope(Scope scope) {
        return this.scope == scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void validate(String key, String value, Scope level) {
        String string = value = value == null ? null : value.trim();
        if (value == null) {
            if (!this.allows(Operation.GET) && !this.allows(Operation.UNSET)) {
                throw new IllegalArgumentException("Setting '" + this + "' cannot be read or cleared");
            }
        } else if (value.isEmpty()) {
            if (this.mustBePresent() || this.mustBeProvided() || !this.allows(Operation.UNSET)) {
                throw new IllegalArgumentException("Setting '" + this + "' requires a value");
            }
        } else {
            if (!this.allows(Operation.SET) && !this.allows(Operation.IMPORT)) {
                throw new IllegalArgumentException("Setting '" + this + "' cannot be set");
            }
            if (level != null && !this.allows(Operation.SET, level) && !this.allows(Operation.IMPORT, level)) {
                throw new IllegalArgumentException("Setting '" + this + "' cannot be set at " + level + " level");
            }
            this.validator.accept(key, value);
        }
    }

    public void validate(String key, String value, Scope level, ClusterState clusterState, Operation operation) {
        this.validate(key, value, level);
        String string = value = value == null ? null : value.trim();
        if (!clusterState.supports(operation)) {
            throw new AssertionError((Object)("Programmatic mistake: tried to validate operation " + operation + " when " + clusterState));
        }
        if (!this.allows(operation)) {
            throw new IllegalArgumentException("Setting '" + this + "' cannot be " + operation);
        }
        if (!this.allows(clusterState, operation)) {
            throw new IllegalArgumentException("Setting '" + this + "' cannot be " + operation + " when " + clusterState);
        }
        if (!this.allows(clusterState, operation, level)) {
            throw new IllegalArgumentException("Setting '" + this + "' cannot be " + operation + " at " + level + " level when " + clusterState);
        }
        switch (operation) {
            case GET: 
            case UNSET: {
                if (value == null) break;
                throw new IllegalArgumentException("Operation " + operation + " must not have a value");
            }
            case SET: {
                if (value != null && !value.isEmpty()) break;
                throw new IllegalArgumentException("Operation " + operation + " requires a value");
            }
            case IMPORT: {
                if ((value == null || value.isEmpty()) && this.mustBePresent()) {
                    throw new IllegalArgumentException("Operation " + operation + " requires a value");
                }
                if (!this.requires(Requirement.RESOLVE_EAGERLY) || !Substitutor.containsSubstitutionParams(value)) break;
                throw new IllegalArgumentException("Placeholders are not allowed");
            }
            default: {
                throw new AssertionError((Object)operation);
            }
        }
    }

    public boolean vetoRuntimeChange(NodeContext currentNode, Configuration configuration) {
        return false;
    }

    public Optional<String> getProperty(PropertyHolder o) {
        return this.extractor.apply(o).map(Setting::reduceToPropertyString);
    }

    public void setProperty(PropertyHolder o, String value) {
        this.setProperty(o, null, value);
    }

    public void setProperty(NodeContext nodeContext, String key, String value) {
        this.setProperty((PropertyHolder)((Object)(this.scope == Scope.CLUSTER ? nodeContext.getCluster() : nodeContext.getNode())), key, value);
    }

    public void setProperty(PropertyHolder o, String key, String value) {
        if (!this.isWritable()) {
            throw new IllegalArgumentException("Setting: " + this + " is not writable");
        }
        this.validate(key, value, null);
        this.setter.accept(o, Tuple2.tuple2(key, this.sanitize(value)));
    }

    public Properties toProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues) {
        Properties properties = new Properties();
        Optional<String> currentValue = this.getProperty(o);
        Optional<String> defaultValue = this.getDefaultProperty();
        Runnable normalWrite = () -> {
            if (currentValue.isPresent()) {
                properties.setProperty(this.name, (String)currentValue.get());
            } else if (defaultValue.isPresent() && !((String)defaultValue.get()).isEmpty()) {
                properties.setProperty(this.name, (String)defaultValue.get());
            }
        };
        if (currentValue.isPresent() || defaultValue.isPresent() && includeDefaultValues) {
            if (expanded && this.isMap()) {
                List<Tuple2> pairs = this.extractor.apply(o).orElseGet(() -> Setting.stream(this.getDefaultValue()).get()).collect(Collectors.toList());
                if (pairs.isEmpty()) {
                    normalWrite.run();
                } else {
                    pairs.forEach(tuple -> properties.setProperty(this.name + "." + (String)tuple.t1, (String)tuple.t2));
                }
            } else {
                normalWrite.run();
            }
        }
        return properties;
    }

    public boolean allowsValue(String value) {
        return this.allowedValues.isEmpty() || this.allowedValues.contains(value);
    }

    void validate(String value) {
        this.validate(null, value, null);
    }

    void validate(String key, String value) {
        this.validate(key, value, null);
    }

    private String sanitize(String value) {
        String string = value = value == null ? null : value.trim();
        if (value != null && value.isEmpty() && !this.isMap() && !this.mustBePresent() && !this.mustBeProvided()) {
            value = null;
        }
        return value;
    }

    public static Setting fromName(String name) {
        return Setting.findSetting(name).orElseThrow(() -> new IllegalArgumentException("Illegal setting name: " + name));
    }

    public static Optional<Setting> findSetting(String name) {
        return Stream.of(Setting.values()).filter(setting -> setting.name.equals(name)).findAny();
    }

    public static Properties modelToProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues, boolean includeHiddenSettings, Version version) {
        Properties properties = new Properties();
        Stream.of(Setting.values()).filter(setting -> version.amongst(setting.getVersions())).filter(setting -> setting.isUserExportable() || includeHiddenSettings && setting.requires(Requirement.HIDDEN)).filter(setting -> setting.isScope(o.getScope())).forEach(setting -> properties.putAll((Map<?, ?>)setting.toProperties(o, expanded, includeDefaultValues)));
        return properties;
    }

    private static Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> fromNode(Function<Node, Object> extractor) {
        return node -> Setting.stream(extractor.apply((Node)node));
    }

    private static Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> fromStripe(Function<Stripe, Object> extractor) {
        return stripe -> Setting.stream(extractor.apply((Stripe)stripe));
    }

    private static Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> fromCluster(Function<Cluster, Object> extractor) {
        return cluster -> Setting.stream(extractor.apply((Cluster)cluster));
    }

    private static Optional<Stream<Tuple2<String, String>>> stream(Object o) {
        if (o instanceof OptionalConfig) {
            o = ((OptionalConfig)o).orElse(null);
        }
        if (o == null) {
            return Optional.empty();
        }
        if (o instanceof Map) {
            return Optional.of(((Map)o).entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> Tuple2.tuple2((String)e.getKey(), e.getValue().toString())));
        }
        return Optional.of(Stream.of(Tuple2.tuple2(null, String.valueOf(o))));
    }

    public static Optional<String> toProperty(Object o) {
        return o == null ? Optional.empty() : Setting.stream(o).map(Setting::reduceToPropertyString);
    }

    private static String reduceToPropertyString(Stream<Tuple2<String, String>> s) {
        return s.filter(tuple -> !tuple.allNulls()).map(tuple -> tuple.t1 == null ? (String)tuple.t2 : (String)tuple.t1 + ":" + (String)tuple.t2).reduce((result, element) -> result + "," + element).orElse("");
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNode(BiConsumer<Node, String> setter) {
        return (node, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Node)node, (String)tuple.t2);
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoStripe(BiConsumer<Stripe, String> setter) {
        return (stripe, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Stripe)stripe, (String)tuple.t2);
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoCluster(BiConsumer<Cluster, String> setter) {
        return (cluster, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Cluster)cluster, (String)tuple.t2);
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNodeMap(BiConsumer<Node, Tuple2<String, String>> setter) {
        return (node, tuple) -> setter.accept((Node)node, Tuple2.tuple2((String)tuple.t1, (String)tuple.t2));
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoClusterMap(BiConsumer<Cluster, Tuple2<String, String>> setter) {
        return (cluster, tuple) -> setter.accept((Cluster)cluster, Tuple2.tuple2((String)tuple.t1, (String)tuple.t2));
    }

    private static <U, V> BiConsumer<U, V> noop() {
        return (u, v) -> {};
    }

    private static <V> Supplier<V> always(V value) {
        return () -> value;
    }

    private static boolean empty(String s) {
        return s == null || s.isEmpty();
    }
}

