/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.properties.TCProperties;
import java.util.concurrent.TimeUnit;

public class HealthCheckerConfigImpl
implements HealthCheckerConfig {
    private final boolean enable;
    private final long pingIdleTime;
    private final long pingInterval;
    private final int pingProbes;
    private final boolean doSocketConnect;
    private final int socketConnectTimeout;
    private final int socketConnectMaxCount;
    private final String name;
    private final boolean checkTimeEnabled;
    private final long checkTimeInterval;
    private final long timeDiffThreshold;
    private static final int DEFAULT_PING_IDLETIME = 45000;
    private static final int DEFAULT_PING_INTERVAL = 15000;
    private static final int DEFAULT_PING_PROBECNT = 3;
    private static final int DEFAULT_SCOKETCONNECT_MAXCOUNT = 3;
    private static final int DEFAULT_SOCKETCONNECT_TIMEOUT = 2;
    private static final long DEFAULT_CHECK_TIME_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    private static final long DEFAULT_TIME_DIFF_THRESHOLD = TimeUnit.MINUTES.toMillis(5L);

    public HealthCheckerConfigImpl(TCProperties healthCheckerProperties, String hcName) {
        this.pingIdleTime = healthCheckerProperties.getLong("ping.idletime");
        this.pingInterval = healthCheckerProperties.getLong("ping.interval");
        this.pingProbes = healthCheckerProperties.getInt("ping.probes");
        this.name = hcName;
        this.doSocketConnect = healthCheckerProperties.getBoolean("socketConnect");
        this.enable = healthCheckerProperties.getBoolean("ping.enabled");
        this.socketConnectMaxCount = healthCheckerProperties.getInt("socketConnectCount");
        this.socketConnectTimeout = healthCheckerProperties.getInt("socketConnectTimeout");
        this.checkTimeEnabled = healthCheckerProperties.getBoolean("checkTime.enabled");
        this.checkTimeInterval = healthCheckerProperties.getLong("checkTime.interval");
        this.timeDiffThreshold = healthCheckerProperties.getLong("checkTime.threshold");
    }

    public HealthCheckerConfigImpl(String name) {
        this(45000L, 15000L, 3, name, false);
    }

    public HealthCheckerConfigImpl(long idle, long interval, int probes, String name, boolean socketConnect) {
        this(idle, interval, probes, name, socketConnect, 3, 2);
    }

    public HealthCheckerConfigImpl(long idle, long interval, int probes, String name, boolean extraCheck, int socketConnectMaxCount, int socketConnectTimeout) {
        this(idle, interval, probes, name, extraCheck, socketConnectMaxCount, socketConnectTimeout, DEFAULT_CHECK_TIME_INTERVAL, DEFAULT_TIME_DIFF_THRESHOLD);
    }

    public HealthCheckerConfigImpl(long idle, long interval, int probes, String name, boolean extraCheck, int socketConnectMaxCount, int socketConnectTimeout, long checkTimeInterval, long timeDiffThreshold) {
        this.pingIdleTime = idle;
        this.pingInterval = interval;
        this.pingProbes = probes;
        this.name = name;
        this.doSocketConnect = extraCheck;
        this.enable = true;
        this.socketConnectMaxCount = socketConnectMaxCount;
        this.socketConnectTimeout = socketConnectTimeout;
        this.checkTimeEnabled = true;
        this.checkTimeInterval = checkTimeInterval;
        this.timeDiffThreshold = timeDiffThreshold;
    }

    @Override
    public boolean isSocketConnectOnPingFail() {
        return this.doSocketConnect;
    }

    @Override
    public boolean isHealthCheckerEnabled() {
        return this.enable;
    }

    @Override
    public long getPingIdleTimeMillis() {
        return this.pingIdleTime;
    }

    @Override
    public long getPingIntervalMillis() {
        return this.pingInterval;
    }

    @Override
    public int getPingProbes() {
        return this.pingProbes;
    }

    @Override
    public String getHealthCheckerName() {
        return this.name;
    }

    @Override
    public int getSocketConnectMaxCount() {
        return this.socketConnectMaxCount;
    }

    @Override
    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    @Override
    public boolean isCheckTimeEnabled() {
        return this.checkTimeEnabled;
    }

    @Override
    public long getCheckTimeInterval() {
        return this.checkTimeInterval;
    }

    @Override
    public long getTimeDiffThreshold() {
        return this.timeDiffThreshold;
    }
}

