/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Shell {
    private static final Logger LOGGER = LoggerFactory.getLogger(Shell.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).startsWith("win");

    private Shell() {
    }

    public static Result execute(Charset consoleEncoding, String ... command) throws IOException {
        int rc;
        Process process = new ProcessBuilder(new String[0]).command(command).redirectErrorStream(true).start();
        process.getOutputStream().close();
        ArrayList<String> commandLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), consoleEncoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                commandLines.add(line);
            }
        }
        try {
            rc = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Command: {}; rc={}", (Object)Arrays.toString(command), (Object)rc);
            commandLines.forEach(l -> LOGGER.debug("    {}", l));
        }
        return new Result(rc, commandLines);
    }

    public static final class Encoding {
        public static final Charset CHARSET = Encoding.getShellEncoding();

        private static Charset getShellEncoding() {
            Charset javaBasedSystemEncoding = Encoding.getJavaBasedSystemEncoding();
            if (IS_WINDOWS) {
                try {
                    for (String line : Shell.execute(javaBasedSystemEncoding, "cmd", "/C", "chcp")) {
                        String[] parts = line.split(":\\s*");
                        if (parts.length != 2 || !parts[1].matches("\\d+") || !Charset.isSupported(parts[1])) continue;
                        return Charset.forName(parts[1]);
                    }
                    LOGGER.info("Unable to determine the shell encoding from 'chcp'; using {}", (Object)javaBasedSystemEncoding);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to determine the shell encoding from 'chcp'; using {}", (Object)javaBasedSystemEncoding, (Object)e);
                }
            }
            return javaBasedSystemEncoding;
        }

        private static Charset getJavaBasedSystemEncoding() {
            for (String property : Arrays.asList("sun.stdout.encoding", "sun.jnu.encoding")) {
                String encoding = System.getProperty(property);
                if (encoding == null || !Charset.isSupported(encoding)) continue;
                return Charset.forName(encoding);
            }
            return Charset.defaultCharset();
        }
    }

    public static final class Result
    implements Iterable<String>,
    Serializable {
        private static final long serialVersionUID = -5555911693879268481L;
        private final transient List<String> commandLines;
        private final int exitCode;

        private Result(int exitCode, List<String> commandLines) {
            this.exitCode = exitCode;
            this.commandLines = Collections.unmodifiableList(new ArrayList<String>(commandLines));
        }

        public int exitCode() {
            return this.exitCode;
        }

        public List<String> lines() {
            return this.commandLines;
        }

        @Override
        public Iterator<String> iterator() {
            return this.commandLines.iterator();
        }

        private void readObject(ObjectInputStream s) throws InvalidObjectException {
            throw new InvalidObjectException("SerializationProxy expected");
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private static final class SerializationProxy
        implements Serializable {
            private static final long serialVersionUID = -8686283741098525116L;
            private final int exitCode;
            private final ArrayList<String> commandLines;

            SerializationProxy(Result result) {
                this.exitCode = result.exitCode;
                this.commandLines = new ArrayList(result.commandLines);
            }

            private Object readResolve() {
                return new Result(this.exitCode, this.commandLines);
            }
        }
    }
}

