/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import jdk.jfr.FlightRecorder;
import org.terracotta.tripwire.MemoryEvent;
import org.terracotta.tripwire.MemoryMonitor;

class MemoryMonitorImpl
implements MemoryMonitor {
    private final String description;
    private volatile long free = Long.MAX_VALUE;
    private volatile long used = Long.MIN_VALUE;
    private final Runnable runnable = () -> this.newEvent().commit();

    MemoryMonitorImpl(String name) {
        this.description = name;
    }

    private MemoryEvent newEvent() {
        return new MemoryEvent(this.description, this.free, this.used);
    }

    @Override
    public void sample(long free, long used) {
        this.free = Math.min(this.free, free);
        this.used = Math.max(this.used, used);
    }

    @Override
    public void register() {
        FlightRecorder.addPeriodicEvent(MemoryEvent.class, this.runnable);
    }

    @Override
    public void unregister() {
        FlightRecorder.removePeriodicEvent(this.runnable);
    }
}

