/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.EndpointType;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.inet.HostPort;

public final class Endpoints
extends AbstractCollection<Node.Endpoint> {
    private final EndpointType endpointType;
    private volatile Cluster cluster;

    public Endpoints(Cluster cluster, EndpointType endpointType) {
        this.cluster = Objects.requireNonNull(cluster);
        this.endpointType = Objects.requireNonNull(endpointType);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @Override
    public Iterator<Node.Endpoint> iterator() {
        return this.endpoints().iterator();
    }

    public Iterator<Node.Endpoint> iterator(UID stripeUID) {
        Cluster c = this.cluster;
        return c.getStripe(stripeUID).map(stripe -> this.endpoints().filter(endpoint -> stripe.containsNode(endpoint.getNodeUID()))).orElse(Stream.empty()).iterator();
    }

    public Stream<Node.Endpoint> endpoints() {
        return this.cluster.getNodes().stream().map(node -> node.determineEndpoint(this.endpointType));
    }

    public Stream<Node.Endpoint> endpoints(UID stripeUID) {
        return this.cluster.getStripe(stripeUID).map(s -> s.getNodes().stream().map(node -> node.determineEndpoint(this.endpointType))).orElse(Stream.empty());
    }

    @Override
    public int size() {
        return this.cluster.getNodeCount();
    }

    public int size(UID stripeUID) {
        return this.cluster.getStripe(stripeUID).map(Stripe::getNodeCount).orElse(0);
    }

    public void refresh(Cluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
    }

    public Iterable<InetSocketAddress> asInetSocketAddresses() {
        return () -> this.endpoints().map(Node.Endpoint::getHostPort).map(HostPort::createInetSocketAddress).iterator();
    }

    public Iterable<InetSocketAddress> asInetSocketAddresses(UID stripeUID) {
        return () -> this.endpoints(stripeUID).map(Node.Endpoint::getHostPort).map(HostPort::createInetSocketAddress).iterator();
    }

    public Iterable<HostPort> asHostPorts() {
        return () -> this.endpoints().map(Node.Endpoint::getHostPort).iterator();
    }

    public Iterable<HostPort> asHostPorts(UID stripeUID) {
        return () -> this.endpoints(stripeUID).map(Node.Endpoint::getHostPort).iterator();
    }
}

