/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter.sampled;

import com.tc.stats.counter.CounterImpl;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.TimeStampedCounterValue;
import java.util.TimerTask;

public class SampledCounterImpl
extends CounterImpl
implements SampledCounter {
    protected final boolean resetOnSample;
    private final TimerTask samplerTask;
    private final long intervalMillis;
    private volatile TimeStampedCounterValue mostRecentSample;

    public SampledCounterImpl(SampledCounterConfig config) {
        super(config.getInitialValue());
        this.intervalMillis = config.getIntervalSecs() * 1000;
        this.resetOnSample = config.isResetOnSample();
        this.samplerTask = new TimerTask(){

            @Override
            public void run() {
                SampledCounterImpl.this.recordSample();
            }
        };
        this.recordSample();
    }

    @Override
    public TimeStampedCounterValue getMostRecentSample() {
        return this.mostRecentSample;
    }

    @Override
    public void shutdown() {
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
        }
    }

    public TimerTask getTimerTask() {
        return this.samplerTask;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    void recordSample() {
        long sample = this.resetOnSample ? this.getAndReset() : this.getValue();
        long now = System.currentTimeMillis();
        this.mostRecentSample = new TimeStampedCounterValue(now, sample);
    }

    @Override
    public long getAndReset() {
        return this.getAndSet(0L);
    }
}

