/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializerBase;
import java.net.InetSocketAddress;
import org.terracotta.inet.HostPort;
import org.terracotta.inet.InetSocketAddressConverter;
import org.terracotta.json.Json;

public class InetJsonModule
extends SimpleModule
implements Json.Module {
    private static final long serialVersionUID = 1L;

    public InetJsonModule() {
        super(InetJsonModule.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.addSerializer(InetSocketAddress.class, (JsonSerializer)new ToStringSerializerBase(InetSocketAddress.class){
            private static final long serialVersionUID = 1L;

            public String valueToString(Object value) {
                return HostPort.create((InetSocketAddress)value).toString();
            }
        });
        this.addDeserializer(InetSocketAddress.class, (JsonDeserializer)new FromStringDeserializer<InetSocketAddress>(InetSocketAddress.class){
            private static final long serialVersionUID = 1L;

            protected InetSocketAddress _deserialize(String value, DeserializationContext ctxt) {
                return InetSocketAddressConverter.parseInetSocketAddress(value);
            }
        });
        this.addSerializer(HostPort.class, (JsonSerializer)ToStringSerializer.instance);
        this.addDeserializer(HostPort.class, (JsonDeserializer)new FromStringDeserializer<HostPort>(HostPort.class){
            private static final long serialVersionUID = 1L;

            protected HostPort _deserialize(String value, DeserializationContext ctxt) {
                return HostPort.parse(value);
            }
        });
    }
}

