/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.ReferenceTypeSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.terracotta.common.struct.json.StructJsonModule;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.model.RawPath;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.inet.HostPort;
import org.terracotta.inet.json.InetJsonModule;
import org.terracotta.json.Json;

public class DynamicConfigModelJsonModule
extends SimpleModule
implements Json.Module {
    private static final long serialVersionUID = 1L;

    public DynamicConfigModelJsonModule() {
        super(DynamicConfigModelJsonModule.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.setMixInAnnotation(NodeContext.class, NodeContextMixin.class);
        this.setMixInAnnotation(Cluster.class, ClusterMixin.class);
        this.setMixInAnnotation(Stripe.class, StripeMixin.class);
        this.setMixInAnnotation(Node.class, NodeMixin.class);
        this.setMixInAnnotation(FailoverPriority.class, FailoverPriorityMixin.class);
        this.setMixInAnnotation(License.class, LicenseMixin.class);
        this.setMixInAnnotation(OptionalConfig.class, OptionalConfigMixin.class);
        this.setMixInAnnotation(LockContext.class, LockContextMixin.class);
        this.setMixInAnnotation(org.terracotta.dynamic_config.api.model.Version.class, VersionMixin.class);
        this.addSerializer(RawPath.class, (JsonSerializer)ToStringSerializer.instance);
        this.addDeserializer(RawPath.class, (JsonDeserializer)new FromStringDeserializer<RawPath>(RawPath.class){
            private static final long serialVersionUID = 1L;

            protected RawPath _deserialize(String value, DeserializationContext ctxt) {
                return RawPath.valueOf(value);
            }

            protected RawPath _deserializeFromEmptyString(DeserializationContext ctxt) {
                return RawPath.valueOf("");
            }
        });
        this.addSerializer(UID.class, (JsonSerializer)ToStringSerializer.instance);
        this.addDeserializer(UID.class, (JsonDeserializer)new FromStringDeserializer<UID>(UID.class){
            private static final long serialVersionUID = 1L;

            protected UID _deserialize(String value, DeserializationContext ctxt) {
                return UID.valueOf(value);
            }
        });
    }

    public Iterable<? extends Module> getDependencies() {
        return Arrays.asList(new SimpleModule[]{new StructJsonModule(), new InetJsonModule()});
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addTypeModifier(new TypeModifier(){

            public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
                return type.isReferenceType() || type.isContainerType() || type.getRawClass() != OptionalConfig.class ? type : ReferenceType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
            }
        });
        context.addSerializers((Serializers)new Serializers.Base(){

            public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
                if (OptionalConfig.class.isAssignableFrom(refType.getRawClass())) {
                    boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
                    return new OptionalConfigSerializer(refType, staticTyping, contentTypeSerializer, contentValueSerializer);
                }
                return null;
            }
        });
    }

    public static abstract class VersionMixin {
        @JsonCreator
        public static org.terracotta.dynamic_config.api.model.Version fromValue(String s) {
            return s == null ? null : org.terracotta.dynamic_config.api.model.Version.fromValue(s);
        }

        @JsonValue
        public abstract String getValue();
    }

    public static abstract class LockContextMixin
    extends LockContext {
        @JsonCreator
        public LockContextMixin(@JsonProperty(value="token", required=true) String token, @JsonProperty(value="ownerName", required=true) String ownerName, @JsonProperty(value="ownerTags", required=true) String ownerTags) {
            super(token, ownerName, ownerTags);
        }
    }

    private static class OptionalConfigSerializer
    extends ReferenceTypeSerializer<OptionalConfig<?>> {
        private static final long serialVersionUID = 1L;

        protected OptionalConfigSerializer(ReferenceType fullType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> ser) {
            super(fullType, staticTyping, vts, ser);
        }

        protected OptionalConfigSerializer(OptionalConfigSerializer base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, Object suppressableValue, boolean suppressNulls) {
            super((ReferenceTypeSerializer)base, property, vts, valueSer, unwrapper, suppressableValue, suppressNulls);
        }

        protected ReferenceTypeSerializer<OptionalConfig<?>> withResolved(BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper) {
            return new OptionalConfigSerializer(this, prop, vts, valueSer, unwrapper, this._suppressableValue, this._suppressNulls);
        }

        public ReferenceTypeSerializer<OptionalConfig<?>> withContentInclusion(Object suppressableValue, boolean suppressNulls) {
            return new OptionalConfigSerializer(this, this._property, this._valueTypeSerializer, this._valueSerializer, this._unwrapper, suppressableValue, suppressNulls);
        }

        protected boolean _isValuePresent(OptionalConfig<?> value) {
            return value.isConfigured();
        }

        protected Object _getReferenced(OptionalConfig<?> value) {
            return value.get();
        }

        protected Object _getReferencedIfPresent(OptionalConfig<?> value) {
            return value.isConfigured() ? value.get() : null;
        }
    }

    public static class LicenseMixin
    extends License {
        @JsonCreator
        public LicenseMixin(@JsonProperty(value="capabilities", required=true) Map<String, Long> capabilityLimitMap, @JsonProperty(value="flags", required=true) Map<String, Boolean> flagsMap, @JsonProperty(value="expiryDate", required=true) LocalDate expiryDate) {
            super(capabilityLimitMap, flagsMap, expiryDate);
        }
    }

    public static class OptionalConfigMixin<T> {
        @JsonValue
        private T value;
    }

    public static class FailoverPriorityMixin
    extends FailoverPriority {
        public FailoverPriorityMixin(FailoverPriority.Type type, Integer voters) {
            super(type, voters);
        }

        @JsonCreator
        public static FailoverPriority valueOf(String str) {
            return FailoverPriority.valueOf(str);
        }

        @Override
        @JsonValue
        public String toString() {
            return super.toString();
        }
    }

    public static class NodeMixin
    extends Node {
        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public HostPort getBindHostPort() {
            return super.getBindHostPort();
        }

        @Override
        @JsonIgnore
        public HostPort getInternalHostPort() {
            return super.getInternalHostPort();
        }

        @Override
        @JsonIgnore
        public Optional<HostPort> getPublicHostPort() {
            return super.getPublicHostPort();
        }

        @Override
        @JsonIgnore
        public Node.Endpoint getBindEndpoint() {
            return super.getBindEndpoint();
        }

        @Override
        @JsonIgnore
        public Collection<Node.Endpoint> getEndpoints() {
            return super.getEndpoints();
        }

        @Override
        @JsonIgnore
        public Node.Endpoint getInternalEndpoint() {
            return super.getInternalEndpoint();
        }

        @Override
        @JsonIgnore
        public Optional<Node.Endpoint> getPublicEndpoint() {
            return super.getPublicEndpoint();
        }
    }

    public static class StripeMixin
    extends Stripe {
        @Override
        @JsonIgnore
        public Optional<Node> getSingleNode() throws IllegalStateException {
            return super.getSingleNode();
        }

        @Override
        @JsonIgnore
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public int getNodeCount() {
            return super.getNodeCount();
        }
    }

    public static class ClusterMixin
    extends Cluster {
        @JsonCreator
        protected ClusterMixin(@JsonProperty(value="stripes", required=true) List<Stripe> stripes) {
            super(stripes);
        }

        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public Optional<Node> getSingleNode() throws IllegalStateException {
            return super.getSingleNode();
        }

        @Override
        @JsonIgnore
        public Optional<Stripe> getSingleStripe() {
            return super.getSingleStripe();
        }

        @Override
        @JsonIgnore
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        @JsonIgnore
        public Collection<Node.Endpoint> getInternalEndpoints() {
            return super.getInternalEndpoints();
        }

        @Override
        @JsonIgnore
        public int getNodeCount() {
            return super.getNodeCount();
        }

        @Override
        @JsonIgnore
        public int getStripeCount() {
            return super.getStripeCount();
        }

        @Override
        @JsonIgnore
        public Collection<Node> getNodes() {
            return super.getNodes();
        }

        @Override
        @JsonIgnore
        public Collection<String> getDataDirNames() {
            return super.getDataDirNames();
        }
    }

    public static class NodeContextMixin
    extends NodeContext {
        @JsonCreator
        public NodeContextMixin(@JsonProperty(value="cluster", required=true) Cluster cluster, @JsonProperty(value="nodeUID", required=true) UID nodeUID) {
            super(cluster, nodeUID);
        }

        @Override
        @JsonIgnore
        public Node getNode() {
            return super.getNode();
        }

        @Override
        @JsonIgnore
        public Stripe getStripe() {
            return super.getStripe();
        }

        @Override
        @JsonIgnore
        public UID getStripeUID() {
            return super.getStripeUID();
        }
    }
}

