/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.client.ClientFactory;
import com.tc.lang.L1ThrowableHandler;
import com.tc.lang.TCThreadGroup;
import com.tc.net.core.ProductID;
import com.tc.object.ClientBuilder;
import com.tc.object.DistributedObjectClient;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.UUID;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedObjectClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedObjectClientFactory.class);
    private final Iterable<InetSocketAddress> serverAddresses;
    private final ClientBuilder builder;
    private final Properties properties;

    public DistributedObjectClientFactory(Iterable<InetSocketAddress> serverAddresses, ClientBuilder builder, Properties properties) {
        this.serverAddresses = serverAddresses;
        this.builder = builder;
        this.properties = properties;
        HashMap<String, String> props = new HashMap<String, String>();
        for (String n : properties.stringPropertyNames()) {
            if (!n.startsWith("com.tc")) continue;
            props.put(n.substring(7), properties.getProperty(n));
        }
        TCPropertiesImpl.getProperties().overwriteTcPropertiesFromConfig(props);
    }

    public DistributedObjectClient create(Runnable shutdown) throws InterruptedException, TimeoutException {
        L1ThrowableHandler throwableHandler = new L1ThrowableHandler(LoggerFactory.getLogger(DistributedObjectClient.class), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
        String uuid = this.properties.getProperty("connection.uuid", UUID.getUUID().toString());
        String name = this.properties.getProperty("connection.name", "");
        TCThreadGroup group = new TCThreadGroup(throwableHandler, name + "/" + uuid, true);
        boolean async = Boolean.parseBoolean(this.properties.getProperty("connection.async", "false"));
        DistributedObjectClient client = ClientFactory.createClient(this.serverAddresses, this.builder, group, uuid, name, async);
        client.addShutdownHook(shutdown);
        ProductID type = this.builder.getTypeOfClient();
        boolean reconnect = !type.isReconnectEnabled();
        String timeout = this.properties.getProperty("connection.timeout", "0");
        if (reconnect && Integer.parseInt(timeout) < 0) {
            if (!client.connectOnce(5000)) {
                return null;
            }
        } else if (!client.connectFor(Long.parseLong(timeout), TimeUnit.MILLISECONDS)) {
            LOGGER.warn("connection timeout {}", (Object)this);
            throw new TimeoutException("connection timeout in " + timeout);
        }
        return client;
    }
}

