/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public final class ChainCodec {
    private static final Struct ELEMENT_STRUCT = StructBuilder.newStructBuilder().int64("sequence", 10).byteBuffer("payload", 20).build();
    public static final Struct CHAIN_STRUCT = StructBuilder.newStructBuilder().structs("elements", 10, ELEMENT_STRUCT).build();
    public static final Struct CHAIN_ENTRY_STRUCT = StructBuilder.newStructBuilder().int64("key", 5).structs("elements", 10, ELEMENT_STRUCT).build();

    private ChainCodec() {
    }

    public static byte[] encodeChain(Chain chain) {
        StructEncoder<Void> encoder = CHAIN_STRUCT.encoder();
        ChainCodec.encodeChain(encoder, chain);
        ByteBuffer byteBuffer = encoder.encode();
        return byteBuffer.array();
    }

    public static void encodeChain(StructEncoder<?> encoder, Chain chain) {
        StructArrayEncoder<StructEncoder<?>> elementsEncoder = encoder.structs("elements");
        for (Element element : chain) {
            StructEncoder<StructArrayEncoder<StructEncoder<?>>> elementEncoder = elementsEncoder.add();
            if (element instanceof SequencedElement) {
                elementEncoder.int64("sequence", ((SequencedElement)element).getSequenceNumber());
            }
            elementEncoder.byteBuffer("payload", element.getPayload());
            elementEncoder.end();
        }
        elementsEncoder.end();
    }

    public static void encodeChainEntry(StructEncoder<?> encoder, Map.Entry<Long, Chain> chain) {
        encoder.int64("key", chain.getKey());
        ChainCodec.encodeChain(encoder, chain.getValue());
    }

    public static Chain decodeChain(byte[] payload) {
        StructDecoder<Void> decoder = CHAIN_STRUCT.decoder(ByteBuffer.wrap(payload));
        return ChainCodec.decodeChain(decoder);
    }

    public static Chain decodeChain(StructDecoder<?> decoder) {
        StructArrayDecoder<StructDecoder<?>> elementsDecoder = decoder.structs("elements");
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < elementsDecoder.length(); ++i) {
            Object elementDecoder = elementsDecoder.next();
            final Long sequence = ((StructDecoder)elementDecoder).int64("sequence");
            final ByteBuffer byteBuffer = ((StructDecoder)elementDecoder).byteBuffer("payload");
            ((StructDecoder)elementDecoder).end();
            if (sequence == null) {
                elements.add(byteBuffer::asReadOnlyBuffer);
                continue;
            }
            elements.add(new SequencedElement(){

                @Override
                public long getSequenceNumber() {
                    return sequence;
                }

                @Override
                public ByteBuffer getPayload() {
                    return byteBuffer.asReadOnlyBuffer();
                }

                public String toString() {
                    return "SequencedElement{sequence=" + sequence + " size=" + byteBuffer.capacity() + "}";
                }
            });
        }
        elementsDecoder.end();
        return ChainBuilder.chainFromList(elements);
    }

    public static Map.Entry<Long, Chain> decodeChainEntry(StructDecoder<?> decoder) {
        Long key = decoder.int64("key");
        Chain elements = ChainCodec.decodeChain(decoder);
        return new AbstractMap.SimpleImmutableEntry<Long, Chain>(key, elements);
    }
}

