/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ReadOnlyBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCByteBufferFactory {
    public static int FIXED_BUFFER_SIZE = 4096;
    private static final int WARN_THRESHOLD = 0xA00000;
    private static final TCByteBuffer[] EMPTY_BB_ARRAY = new TCByteBuffer[0];
    private static final TCByteBuffer ZERO_BYTE_BUFFER = TCByteBufferImpl.wrap(new byte[0]);
    private static final Logger logger = LoggerFactory.getLogger(TCByteBufferFactory.class);
    private static final ReferenceQueue<TCByteBuffer> DIRECT_POOL = new ReferenceQueue();

    public static TCByteBuffer getInstance(int size) {
        if (size > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + size + " bytes");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (size == 0) {
            return ZERO_BYTE_BUFFER;
        }
        return new TCByteBufferImpl(size, false);
    }

    public static void setFixedBufferSize(int size) {
        FIXED_BUFFER_SIZE = size;
    }

    public static TCByteBuffer[] getDirectBuffersForLength(int length) {
        if (length > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + length + " bytes");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (length == 0) {
            return EMPTY_BB_ARRAY;
        }
        int numBuffers = TCByteBufferFactory.getBufferCountNeededForMessageSize(length);
        TCByteBuffer[] rv = new TCByteBuffer[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            rv[i] = TCByteBufferFactory.pullFromQueueOrCreate(i, numBuffers);
        }
        TCByteBuffer lastBuffer = rv[rv.length - 1];
        lastBuffer.limit(lastBuffer.capacity() - (numBuffers * FIXED_BUFFER_SIZE - length));
        return rv;
    }

    public static TCByteBuffer getDirectByteBuffer() {
        return TCByteBufferFactory.pullFromQueueOrCreate(0, 1);
    }

    private static TCByteBuffer pullFromQueueOrCreate(int index, int totalCount) {
        TCByteBuffer usable = null;
        while (usable == null) {
            Reference<TCByteBuffer> ref = DIRECT_POOL.poll();
            if (ref != null) {
                usable = ref.get();
                if (usable == null) continue;
                if (usable.capacity() == FIXED_BUFFER_SIZE) {
                    usable = usable.reInit();
                    continue;
                }
                usable = null;
                continue;
            }
            try {
                usable = new TCByteBufferImpl(FIXED_BUFFER_SIZE, true);
            }
            catch (OutOfMemoryError oome) {
                logger.error("OOME trying to allocate direct buffer of size " + FIXED_BUFFER_SIZE + " (index " + index + " of count " + totalCount + ")");
                throw oome;
            }
        }
        SoftReference<TCByteBuffer> root = new SoftReference<TCByteBuffer>(usable, DIRECT_POOL);
        return usable;
    }

    private static int getBufferCountNeededForMessageSize(int length) {
        int numBuffers = length / FIXED_BUFFER_SIZE;
        if (length % FIXED_BUFFER_SIZE != 0) {
            ++numBuffers;
        }
        return numBuffers;
    }

    public static int getTotalBufferSizeNeededForMessageSize(int length) {
        return TCByteBufferFactory.getBufferCountNeededForMessageSize(length) * FIXED_BUFFER_SIZE;
    }

    public static TCByteBuffer wrap(byte[] buf) {
        if (buf == null) {
            return null;
        }
        return TCByteBufferImpl.wrap(buf);
    }

    public static byte[] unwrap(TCByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] array = null;
        try {
            array = buffer.array();
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            // empty catch block
        }
        if (array == null || buffer.position() != 0 || buffer.remaining() != array.length || buffer.arrayOffset() != 0) {
            array = new byte[buffer.remaining()];
            buffer.duplicate().get(array);
        }
        return array;
    }

    public static TCByteBuffer copyAndWrap(byte[] buf) {
        TCByteBuffer rv = null;
        if (buf != null) {
            rv = TCByteBufferFactory.getInstance(buf.length);
            rv.put(buf).rewind();
        } else {
            rv = TCByteBufferFactory.getInstance(0);
        }
        return rv;
    }
}

