/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.TimeType;
import org.ehcache.xml.model.TimeUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusteringServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<ClusteringService>,
CacheServiceConfigurationParser<ClusteredStore.Provider> {
    public static final String CLUSTERED_STORE_ELEMENT_NAME = "clustered-store";
    public static final String CONSISTENCY_ATTRIBUTE_NAME = "consistency";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ServiceConfiguration<ClusteredStore.Provider> parseServiceConfiguration(Element fragment) {
        if (CLUSTERED_STORE_ELEMENT_NAME.equals(fragment.getLocalName())) {
            if (fragment.hasAttribute(CONSISTENCY_ATTRIBUTE_NAME)) {
                return new ClusteredStoreConfiguration(Consistency.valueOf(fragment.getAttribute(CONSISTENCY_ATTRIBUTE_NAME).toUpperCase()));
            }
            return new ClusteredStoreConfiguration();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public ServiceCreationConfiguration<ClusteringService> parseServiceCreationConfiguration(Element fragment) {
        if ("cluster".equals(fragment.getLocalName())) {
            ServerSideConfig serverConfig = null;
            URI connectionUri = null;
            TimeoutDuration getTimeout = null;
            NodeList childNodes = fragment.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (1 != item.getNodeType()) continue;
                if ("connection".equals(item.getLocalName())) {
                    Attr urlAttribute = ((Element)item).getAttributeNode("url");
                    String urlValue = urlAttribute.getValue();
                    try {
                        connectionUri = new URI(urlValue);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new XmlConfigurationException(String.format("Value of %s attribute on XML configuration element <%s> in <%s> is not a valid URI - '%s'", urlAttribute.getName(), item.getNodeName(), fragment.getTagName(), connectionUri), (Throwable)e);
                    }
                }
                if ("read-timeout".equals(item.getLocalName())) {
                    getTimeout = this.processGetTimeout(fragment, item);
                    continue;
                }
                if (!"server-side-config".equals(item.getLocalName())) continue;
                serverConfig = this.processServerSideConfig(item);
            }
            try {
                if (serverConfig == null) {
                    if (getTimeout == null) {
                        return new ClusteringServiceConfiguration(connectionUri);
                    }
                    return new ClusteringServiceConfiguration(connectionUri, getTimeout);
                }
                ServerSideConfiguration serverSideConfiguration = serverConfig.defaultServerResource == null ? new ServerSideConfiguration(serverConfig.pools) : new ServerSideConfiguration(serverConfig.defaultServerResource, serverConfig.pools);
                if (getTimeout == null) {
                    return new ClusteringServiceConfiguration(connectionUri, serverConfig.autoCreate, serverSideConfiguration);
                }
                return new ClusteringServiceConfiguration(connectionUri, getTimeout, serverConfig.autoCreate, serverSideConfiguration);
            }
            catch (IllegalArgumentException e) {
                throw new XmlConfigurationException((Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    private TimeoutDuration processGetTimeout(Element parentElement, Node timeoutNode) {
        TimeoutDuration getTimeout;
        try {
            JAXBContext context = JAXBContext.newInstance((String)TimeType.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement jaxbElement = unmarshaller.unmarshal(timeoutNode, TimeType.class);
            TimeType timeType = (TimeType)jaxbElement.getValue();
            BigInteger amount = timeType.getValue();
            if (amount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new XmlConfigurationException(String.format("Value of XML configuration element <%s> in <%s> exceeds allowed value - %s", timeoutNode.getNodeName(), parentElement.getTagName(), amount));
            }
            getTimeout = TimeoutDuration.of(amount.longValue(), XmlModel.convertToJavaTimeUnit((TimeUnit)timeType.getUnit()));
        }
        catch (JAXBException e) {
            throw new XmlConfigurationException((Throwable)e);
        }
        return getTimeout;
    }

    private ServerSideConfig processServerSideConfig(Node serverSideConfigElement) {
        ServerSideConfig serverSideConfig = new ServerSideConfig();
        serverSideConfig.autoCreate = Boolean.parseBoolean(((Element)serverSideConfigElement).getAttribute("auto-create"));
        NodeList serverSideNodes = serverSideConfigElement.getChildNodes();
        for (int i = 0; i < serverSideNodes.getLength(); ++i) {
            long quantity;
            Node item = serverSideNodes.item(i);
            if (1 != item.getNodeType()) continue;
            String nodeLocalName = item.getLocalName();
            if ("default-resource".equals(nodeLocalName)) {
                serverSideConfig.defaultServerResource = ((Element)item).getAttribute("from");
                continue;
            }
            if (!"shared-pool".equals(nodeLocalName)) continue;
            Element sharedPoolElement = (Element)item;
            String poolName = sharedPoolElement.getAttribute("name");
            Attr fromAttr = sharedPoolElement.getAttributeNode("from");
            String fromResource = fromAttr == null ? null : fromAttr.getValue();
            Attr unitAttr = sharedPoolElement.getAttributeNode("unit");
            String unit = unitAttr == null ? "B" : unitAttr.getValue();
            MemoryUnit memoryUnit = MemoryUnit.valueOf((String)unit.toUpperCase(Locale.ENGLISH));
            String quantityValue = sharedPoolElement.getFirstChild().getNodeValue();
            try {
                quantity = Long.parseLong(quantityValue);
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException("Magnitude of value specified for <shared-pool name=\"" + poolName + "\"> is too large");
            }
            ServerSideConfiguration.Pool poolDefinition = fromResource == null ? new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity)) : new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity), fromResource);
            if (serverSideConfig.pools.put(poolName, poolDefinition) == null) continue;
            throw new XmlConfigurationException("Duplicate definition for <shared-pool name=\"" + poolName + "\">");
        }
        return serverSideConfig;
    }

    private static final class ServerSideConfig {
        private boolean autoCreate = false;
        private String defaultServerResource = null;
        private final Map<String, ServerSideConfiguration.Pool> pools = new HashMap<String, ServerSideConfiguration.Pool>();

        private ServerSideConfig() {
        }
    }
}

