/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.CodecUtil;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;

class ServerStoreOpCodec {
    private static final byte STORE_OP_CODE_SIZE = 1;
    private static final byte CACHE_ID_LEN_SIZE = 4;
    private static final byte KEY_SIZE = 8;
    private static final byte CHAIN_LEN_SIZE = 4;
    private static final byte INVALIDATION_ID_LEN_SIZE = 4;
    private final ChainCodec chainCodec = new ChainCodec();

    ServerStoreOpCodec() {
    }

    public byte[] encode(ServerStoreOpMessage message) {
        int cacheIdLen = message.getCacheId().length();
        switch (message.operation()) {
            case GET: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(9 + 2 * cacheIdLen);
                encodedMsg.put(getMessage.getOpCode());
                encodedMsg.putLong(getMessage.getKey());
                CodecUtil.putStringAsCharArray(encodedMsg, getMessage.getCacheId());
                return encodedMsg.array();
            }
            case APPEND: {
                ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(13 + 2 * cacheIdLen + appendMessage.getPayload().remaining());
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, appendMessage.getCacheId(), appendMessage.getKey(), appendMessage.getOpCode());
                encodedMsg.put(appendMessage.getPayload());
                return encodedMsg.array();
            }
            case GET_AND_APPEND: {
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(13 + 2 * cacheIdLen + getAndAppendMessage.getPayload().remaining());
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, getAndAppendMessage.getCacheId(), getAndAppendMessage.getKey(), getAndAppendMessage.getOpCode());
                encodedMsg.put(getAndAppendMessage.getPayload());
                return encodedMsg.array();
            }
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                byte[] encodedExpectedChain = this.chainCodec.encode(replaceAtHeadMessage.getExpect());
                byte[] encodedUpdatedChain = this.chainCodec.encode(replaceAtHeadMessage.getUpdate());
                ByteBuffer encodedMsg = ByteBuffer.allocate(13 + 2 * cacheIdLen + 4 + encodedExpectedChain.length + encodedUpdatedChain.length);
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, replaceAtHeadMessage.getCacheId(), replaceAtHeadMessage.getKey(), replaceAtHeadMessage.getOpCode());
                encodedMsg.putInt(encodedExpectedChain.length);
                encodedMsg.put(encodedExpectedChain);
                encodedMsg.put(encodedUpdatedChain);
                return encodedMsg.array();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAck = (ServerStoreOpMessage.ClientInvalidationAck)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(5 + 2 * cacheIdLen);
                encodedMsg.put(clientInvalidationAck.getOpCode());
                encodedMsg.putInt(clientInvalidationAck.getInvalidationId());
                CodecUtil.putStringAsCharArray(encodedMsg, clientInvalidationAck.getCacheId());
                return encodedMsg.array();
            }
            case CLEAR: {
                ServerStoreOpMessage.ClearMessage clearMessage = (ServerStoreOpMessage.ClearMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(1 + 2 * cacheIdLen);
                encodedMsg.put(clearMessage.getOpCode());
                CodecUtil.putStringAsCharArray(encodedMsg, clearMessage.getCacheId());
                return encodedMsg.array();
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + (Object)((Object)message.operation()));
    }

    private static void putCacheIdKeyAndOpCode(ByteBuffer byteBuffer, String cacheId, long key, byte opcode) {
        byteBuffer.put(opcode);
        byteBuffer.putInt(cacheId.length());
        CodecUtil.putStringAsCharArray(byteBuffer, cacheId);
        byteBuffer.putLong(key);
    }

    public EhcacheEntityMessage decode(byte[] payload) {
        ByteBuffer msg = ByteBuffer.wrap(payload);
        byte opCode = msg.get();
        ServerStoreOpMessage.ServerStoreOp storeOp = ServerStoreOpMessage.ServerStoreOp.getServerStoreOp(opCode);
        switch (storeOp) {
            case GET: {
                long key = msg.getLong();
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                return new ServerStoreOpMessage.GetMessage(cacheId, key);
            }
            case GET_AND_APPEND: {
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                return new ServerStoreOpMessage.GetAndAppendMessage(cacheId, key, msg.slice().asReadOnlyBuffer());
            }
            case APPEND: {
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                return new ServerStoreOpMessage.AppendMessage(cacheId, key, msg.slice().asReadOnlyBuffer());
            }
            case REPLACE: {
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                int expectChainLen = msg.getInt();
                byte[] encodedExpectChain = new byte[expectChainLen];
                msg.get(encodedExpectChain);
                int updateChainLen = msg.remaining();
                byte[] encodedUpdateChain = new byte[updateChainLen];
                msg.get(encodedUpdateChain);
                return new ServerStoreOpMessage.ReplaceAtHeadMessage(cacheId, key, this.chainCodec.decode(encodedExpectChain), this.chainCodec.decode(encodedUpdateChain));
            }
            case CLIENT_INVALIDATION_ACK: {
                int invalidationId = msg.getInt();
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                return new ServerStoreOpMessage.ClientInvalidationAck(cacheId, invalidationId);
            }
            case CLEAR: {
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                return new ServerStoreOpMessage.ClearMessage(cacheId);
            }
        }
        throw new UnsupportedOperationException("This operation code is not supported : " + opCode);
    }

    private static String readStringFromBufferWithSize(ByteBuffer buffer) {
        int length = buffer.getInt();
        return CodecUtil.getStringFromBuffer(buffer, length);
    }
}

