/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageCodec;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EhcacheCodec
implements MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> SERVER_INSTANCE = new EhcacheCodec(new ServerStoreOpCodec(), new LifeCycleMessageCodec(), new StateRepositoryOpCodec(), new ResponseCodec());
    private final ServerStoreOpCodec serverStoreOpCodec;
    private final LifeCycleMessageCodec lifeCycleMessageCodec;
    private final StateRepositoryOpCodec stateRepositoryOpCodec;
    private final ResponseCodec responseCodec;

    public static MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> messageCodec() {
        return SERVER_INSTANCE;
    }

    EhcacheCodec(ServerStoreOpCodec serverStoreOpCodec, LifeCycleMessageCodec lifeCycleMessageCodec, StateRepositoryOpCodec stateRepositoryOpCodec, ResponseCodec responseCodec) {
        this.serverStoreOpCodec = serverStoreOpCodec;
        this.lifeCycleMessageCodec = lifeCycleMessageCodec;
        this.stateRepositoryOpCodec = stateRepositoryOpCodec;
        this.responseCodec = responseCodec;
    }

    @Override
    public byte[] encodeMessage(EhcacheEntityMessage message) {
        switch (message.getType()) {
            case LIFECYCLE_OP: {
                return this.lifeCycleMessageCodec.encode((LifecycleMessage)message);
            }
            case SERVER_STORE_OP: {
                return this.serverStoreOpCodec.encode((ServerStoreOpMessage)message);
            }
            case STATE_REPO_OP: {
                return this.stateRepositoryOpCodec.encode((StateRepositoryOpMessage)message);
            }
        }
        throw new IllegalArgumentException("Undefined message type: " + (Object)((Object)message.getType()));
    }

    @Override
    public EhcacheEntityMessage decodeMessage(byte[] payload) throws MessageCodecException {
        byte opCode = payload[0];
        if (opCode <= EhcacheEntityMessage.Type.LIFECYCLE_OP.getCode()) {
            return this.lifeCycleMessageCodec.decode(payload);
        }
        if (opCode <= EhcacheEntityMessage.Type.SERVER_STORE_OP.getCode()) {
            return this.serverStoreOpCodec.decode(payload);
        }
        if (opCode <= EhcacheEntityMessage.Type.STATE_REPO_OP.getCode()) {
            return this.stateRepositoryOpCodec.decode(payload);
        }
        throw new UnsupportedOperationException("Undefined message code: " + opCode);
    }

    @Override
    public byte[] encodeResponse(EhcacheEntityResponse response) throws MessageCodecException {
        return this.responseCodec.encode(response);
    }

    @Override
    public EhcacheEntityResponse decodeResponse(byte[] payload) throws MessageCodecException {
        return this.responseCodec.decode(payload);
    }
}

