/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;

public abstract class StateRepositoryOpMessage
extends EhcacheEntityMessage
implements Serializable {
    private final String cacheId;
    private final String mapId;

    private StateRepositoryOpMessage(String cacheId, String mapId) {
        this.cacheId = cacheId;
        this.mapId = mapId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public String getMapId() {
        return this.mapId;
    }

    @Override
    public EhcacheEntityMessage.Type getType() {
        return EhcacheEntityMessage.Type.STATE_REPO_OP;
    }

    public abstract StateRepositoryOp operation();

    @Override
    public byte getOpCode() {
        return this.getType().getCode();
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getType()) + "#" + (Object)((Object)this.operation());
    }

    public static class EntrySetMessage
    extends StateRepositoryOpMessage {
        public EntrySetMessage(String cacheId, String mapId) {
            super(cacheId, mapId);
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.ENTRY_SET;
        }
    }

    public static class PutIfAbsentMessage
    extends KeyBasedMessage {
        private final Object value;

        public PutIfAbsentMessage(String cacheId, String mapId, Object key, Object value) {
            super(cacheId, mapId, key);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.PUT_IF_ABSENT;
        }
    }

    public static class GetMessage
    extends KeyBasedMessage {
        public GetMessage(String cacheId, String mapId, Object key) {
            super(cacheId, mapId, key);
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.GET;
        }
    }

    private static abstract class KeyBasedMessage
    extends StateRepositoryOpMessage {
        private final Object key;

        private KeyBasedMessage(String cacheId, String mapId, Object key) {
            super(cacheId, mapId);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static enum StateRepositoryOp {
        GET,
        PUT_IF_ABSENT,
        ENTRY_SET;

    }
}

