/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.clustered.client.internal.service.DefaultClusteringService;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.spi.persistence.StateRepository;

class ClusteredStateRepository
implements StateRepository {
    private final ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier;
    private final String composedId;
    private final DefaultClusteringService defaultClusteringService;

    ClusteredStateRepository(ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier, String id, DefaultClusteringService defaultClusteringService) {
        this.clusterCacheIdentifier = clusterCacheIdentifier;
        this.composedId = clusterCacheIdentifier.getId() + "-" + id;
        this.defaultClusteringService = defaultClusteringService;
    }

    public <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> getPersistentConcurrentMap(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.defaultClusteringService.getConcurrentMap(this.clusterCacheIdentifier, this.composedId + "-" + name, keyClass, valueClass);
    }
}

