/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.util.Assert;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientStaticFactory;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

public class TerracottaConnectionService
implements ConnectionService {
    private static final String SCHEME = "terracotta";

    @Override
    public boolean handlesURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    @Override
    public Connection connect(URI uri, Properties properties) throws ConnectionException {
        String[] hosts;
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        for (String host : hosts = uri.getSchemeSpecificPart().split(",")) {
            if (0 != host.indexOf("//")) {
                host = "//" + host;
            }
            URI oneHost = null;
            try {
                oneHost = new URI(host);
            }
            catch (URISyntaxException e) {
                Assert.fail(e.getLocalizedMessage());
            }
            String userInfo = oneHost.getUserInfo();
            String stripeUri = (null != userInfo ? userInfo + "@" : "") + oneHost.getHost() + ":" + oneHost.getPort();
            clientConfig.addStripeMemberUri(stripeUri);
        }
        clientConfig.addGenericProperties(properties);
        final TerracottaInternalClient client = TerracottaInternalClientStaticFactory.getOrCreateTerracottaInternalClient(clientConfig);
        try {
            client.init();
        }
        catch (TimeoutException exp) {
            throw new ConnectionException(exp);
        }
        catch (ConfigurationSetupException config) {
            throw new ConnectionException(config);
        }
        catch (InterruptedException ie) {
            throw new ConnectionException(ie);
        }
        return new TerracottaConnection(client.getClientEntityManager(), client.getClientLockManager(), new Runnable(){

            @Override
            public void run() {
                client.shutdown();
            }
        });
    }
}

