/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.runtime;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.locks.ThreadID;
import com.tc.util.Conversion;
import com.tc.util.runtime.LockInfoByThreadID;
import com.tc.util.runtime.NullLockInfoByThreadIDImpl;
import com.tc.util.runtime.NullThreadIDMapImpl;
import com.tc.util.runtime.ThreadIDMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThreadDumpUtil {
    public static final String ZIP_BUFFER_NAME = "threadDumps.zip";
    private static final short ZIP_BUFFER_INITIAL_SIZE = 10240;
    protected static final TCLogger logger = TCLogging.getLogger(ThreadDumpUtil.class);
    protected static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    protected static volatile ThreadGroup rootThreadGroup;

    public static byte[] getCompressedThreadDump() {
        return ThreadDumpUtil.getCompressedThreadDump(new NullLockInfoByThreadIDImpl(), new NullThreadIDMapImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCompressedThreadDump(LockInfoByThreadID lockInfo, ThreadIDMap threadIDMap) {
        ByteArrayOutputStream bOutStream = new ByteArrayOutputStream(10240);
        ZipOutputStream zout = new ZipOutputStream(bOutStream);
        ZipEntry zEntry = new ZipEntry(ZIP_BUFFER_NAME);
        try {
            zout.putNextEntry(zEntry);
        }
        catch (IOException e) {
            logger.error(e);
            return null;
        }
        String threadDump = ThreadDumpUtil.getThreadDump(lockInfo, threadIDMap);
        logger.info(threadDump);
        try {
            zout.write(Conversion.string2Bytes(threadDump));
            zout.flush();
        }
        catch (IOException e) {
            logger.error(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                zout.closeEntry();
                zout.close();
            }
            catch (IOException e) {
                logger.error(e);
                return null;
            }
        }
        return bOutStream.toByteArray();
    }

    public static String getLockList(LockInfoByThreadID lockInfo, ThreadID tcThreadID) {
        String lockList = "";
        List<String> heldLocks = lockInfo.getHeldLocks(tcThreadID);
        List<String> waitOnLocks = lockInfo.getWaitOnLocks(tcThreadID);
        List<String> pendingLocks = lockInfo.getPendingLocks(tcThreadID);
        if (heldLocks.size() != 0) {
            lockList = lockList + "LOCKED : " + heldLocks.toString() + "\n";
        }
        if (waitOnLocks.size() != 0) {
            lockList = lockList + "WAITING ON LOCK: " + waitOnLocks.toString() + "\n";
        }
        if (pendingLocks.size() != 0) {
            lockList = lockList + "WAITING TO LOCK: " + pendingLocks.toString() + "\n";
        }
        return lockList;
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = ThreadDumpUtil.getRootThreadGroup();
        int alloc = threadMXBean.getThreadCount();
        int size = 0;
        while ((size = root.enumerate(threads = new Thread[alloc *= 2], true)) >= alloc) {
        }
        Thread[] trimmed = new Thread[size];
        System.arraycopy(threads, 0, trimmed, 0, size);
        return trimmed;
    }

    public static ThreadGroup getRootThreadGroup() {
        if (rootThreadGroup == null) {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            ThreadGroup parent = tg.getParent();
            while (parent != null) {
                tg = parent;
                parent = tg.getParent();
            }
            rootThreadGroup = tg;
        }
        return rootThreadGroup;
    }

    public static String getThreadDump() {
        return ThreadDumpUtil.getThreadDump(new NullLockInfoByThreadIDImpl(), new NullThreadIDMapImpl());
    }

    public static String getThreadDump(LockInfoByThreadID lockInfo, ThreadIDMap threadIDMap) {
        StringBuilder sb = new StringBuilder(102400);
        sb.append(new Date().toString());
        sb.append('\n');
        sb.append("Full thread dump ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" (");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(' ');
        sb.append(System.getProperty("java.vm.info"));
        sb.append("):\n\n");
        try {
            ThreadInfo[] threadsInfo;
            for (ThreadInfo threadInfo : threadsInfo = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported())) {
                ThreadDumpUtil.threadHeader(sb, threadInfo);
                StackTraceElement[] stea = threadInfo.getStackTrace();
                MonitorInfo[] monitorInfos = threadInfo.getLockedMonitors();
                for (StackTraceElement element : stea) {
                    sb.append("\tat ");
                    sb.append(element.toString());
                    sb.append('\n');
                    for (MonitorInfo monitorInfo : monitorInfos) {
                        StackTraceElement lockedFrame = monitorInfo.getLockedStackFrame();
                        if (lockedFrame == null || !lockedFrame.equals(element)) continue;
                        sb.append("\t- locked <0x");
                        sb.append(Integer.toHexString(monitorInfo.getIdentityHashCode()));
                        sb.append("> (a ");
                        sb.append(monitorInfo.getClassName());
                        sb.append(")");
                        sb.append('\n');
                    }
                }
                sb.append(ThreadDumpUtil.getLockList(lockInfo, threadIDMap.getTCThreadID(threadInfo.getThreadId())));
                if (!threadMXBean.isObjectMonitorUsageSupported() && threadMXBean.isSynchronizerUsageSupported()) {
                    sb.append(ThreadDumpUtil.threadLockedSynchronizers(threadInfo));
                }
                sb.append('\n');
            }
        }
        catch (Exception e) {
            logger.error("Cannot take thread dumps - " + e.getMessage(), e);
            sb.append(e.toString());
        }
        return sb.toString();
    }

    private static void threadHeader(StringBuilder sb, ThreadInfo threadInfo) {
        String threadName = threadInfo.getThreadName();
        sb.append("\"");
        sb.append(threadName);
        sb.append("\" ");
        sb.append("Id=");
        sb.append(threadInfo.getThreadId());
        try {
            Thread.State threadState = threadInfo.getThreadState();
            String lockName = threadInfo.getLockName();
            String lockOwnerName = threadInfo.getLockOwnerName();
            Long lockOwnerId = threadInfo.getLockOwnerId();
            Boolean isSuspended = threadInfo.isSuspended();
            Boolean isInNative = threadInfo.isInNative();
            sb.append(" ");
            sb.append((Object)threadState);
            if (lockName != null) {
                sb.append(" on ");
                sb.append(lockName);
            }
            if (lockOwnerName != null) {
                sb.append(" owned by \"");
                sb.append(lockOwnerName);
                sb.append("\" Id=");
                sb.append(lockOwnerId);
            }
            if (isSuspended.booleanValue()) {
                sb.append(" (suspended)");
            }
            if (isInNative.booleanValue()) {
                sb.append(" (in native)");
            }
        }
        catch (Exception e) {
            sb.append(" ( Got exception : ").append(e.getMessage()).append(" :");
        }
        sb.append('\n');
    }

    private static String threadLockedSynchronizers(ThreadInfo threadInfo) {
        String NO_SYNCH_INFO = "no locked synchronizers information available\n";
        if (null == threadInfo) {
            return "no locked synchronizers information available\n";
        }
        try {
            LockInfo[] lockInfos = threadInfo.getLockedSynchronizers();
            if (lockInfos.length > 0) {
                StringBuffer lockedSynchBuff = new StringBuffer();
                lockedSynchBuff.append("\nLocked Synchronizers: \n");
                for (LockInfo lockInfo : lockInfos) {
                    lockedSynchBuff.append(lockInfo.getClassName()).append(" <").append(lockInfo.getIdentityHashCode()).append("> \n");
                }
                return lockedSynchBuff.append("\n").toString();
            }
            return "";
        }
        catch (Exception e) {
            return "no locked synchronizers information available\n";
        }
    }

    public static void main(String[] args) {
        System.out.println(ThreadDumpUtil.getThreadDump());
    }
}

