/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCRuntimeException;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.delivery.GuaranteedDeliveryProtocol;
import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessageDelivery;
import com.tc.net.protocol.delivery.OOOProtocolMessageFactory;
import com.tc.net.protocol.delivery.OOOProtocolMessageParser;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayer;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.transport.AbstractMessageTransport;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.properties.ReconnectConfig;
import com.tc.util.Assert;
import com.tc.util.CallStackTrace;
import com.tc.util.DebugUtil;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;

public class OnceAndOnlyOnceProtocolNetworkLayerImpl
extends AbstractMessageTransport
implements OnceAndOnlyOnceProtocolNetworkLayer,
OOOProtocolMessageDelivery {
    private final OOOProtocolMessageFactory messageFactory;
    private final OOOProtocolMessageParser messageParser;
    private MessageChannelInternal receiveLayer;
    private MessageTransport sendLayer;
    private final GuaranteedDeliveryProtocol delivery;
    private final AtomicBoolean reconnectMode = new AtomicBoolean(false);
    private final AtomicBoolean handshakeMode = new AtomicBoolean(false);
    private final AtomicBoolean channelConnected = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private final boolean isClient;
    private final String debugId;
    private UUID sessionId = UUID.NULL_ID;
    private final Timer restoreConnectTimer;
    private static final boolean debug = Boolean.getBoolean("ooo.logging.enabled");

    public OnceAndOnlyOnceProtocolNetworkLayerImpl(OOOProtocolMessageFactory messageFactory, OOOProtocolMessageParser messageParser, ReconnectConfig reconnectConfig, boolean isClient) {
        this(messageFactory, messageParser, reconnectConfig, isClient, null);
    }

    public OnceAndOnlyOnceProtocolNetworkLayerImpl(OOOProtocolMessageFactory messageFactory, OOOProtocolMessageParser messageParser, ReconnectConfig reconnectConfig, boolean isClient, Timer restoreConnectTimer) {
        super(TCLogging.getLogger(OnceAndOnlyOnceProtocolNetworkLayerImpl.class));
        this.messageFactory = messageFactory;
        this.messageParser = messageParser;
        this.isClient = isClient;
        this.delivery = new GuaranteedDeliveryProtocol(this, reconnectConfig, isClient);
        this.delivery.start();
        this.delivery.pause();
        this.restoreConnectTimer = restoreConnectTimer;
        this.sessionId = this.isClient ? UUID.NULL_ID : UUID.getUUID();
        this.debugId = this.isClient ? "CLIENT" : "SERVER";
    }

    public void setNewSessionID() {
        this.sessionId = UUID.getUUID();
    }

    @Override
    public void setSendLayer(NetworkLayer layer) {
        if (!(layer instanceof MessageTransport)) {
            throw new IllegalArgumentException("Error: send layer must be MessageTransport!");
        }
        this.setSendLayer((MessageTransport)layer);
    }

    public void setSendLayer(MessageTransport transport) {
        this.sendLayer = transport;
    }

    @Override
    public void setReceiveLayer(NetworkLayer layer) {
        if (!(layer instanceof MessageChannelInternal)) {
            throw new IllegalArgumentException("Error: receive layer must be MessageChannelInternal, was " + layer.getClass().getName());
        }
        this.receiveLayer = (MessageChannelInternal)layer;
    }

    @Override
    public NetworkLayer getReceiveLayer() {
        return this.receiveLayer;
    }

    @Override
    public void send(TCNetworkMessage message) {
        this.delivery.send(message);
    }

    @Override
    public void receive(TCByteBuffer[] msgData) {
        OOOProtocolMessage msg = this.createProtocolMessage(msgData);
        if (msg.isSend() || msg.isAck()) {
            if (!this.sessionId.equals(msg.getSessionId())) {
                this.logger.warn("Dropping old session message " + msg);
                return;
            }
            if (this.handshakeMode.get()) {
                Assert.fail("Unexpected message while in handshaking mode: " + msg);
            }
            if (!this.channelConnected.get()) {
                this.logger.warn("Drop stale message " + msg.getHeader().toString() + " from " + this.sendLayer.getConnectionId());
                return;
            }
            this.delivery.receive(msg);
        } else if (msg.isHandshake()) {
            Assert.assertTrue(!this.isClient);
            if (debug) {
                this.debugLog("Got Handshake message...");
            }
            if (msg.getSessionId().equals(UUID.NULL_ID)) {
                if (debug) {
                    this.debugLog("A brand new client is trying to connect - reply OK");
                }
                OOOProtocolMessage reply = this.createHandshakeReplyOkMessage(this.delivery.getReceiver().getReceived());
                this.sendMessage(reply);
                this.delivery.resume();
                this.delivery.receive(this.createHandshakeReplyOkMessage(-1L));
                this.resetModesAndfireTransportConnectedEvent();
            } else if (msg.getSessionId().equals(this.getSessionId())) {
                if (debug) {
                    this.debugLog("A same-session client is trying to connect - reply OK");
                }
                OOOProtocolMessage reply = this.createHandshakeReplyOkMessage(this.delivery.getReceiver().getReceived());
                this.sendMessage(reply);
                this.delivery.resume();
                this.delivery.receive(this.createHandshakeReplyOkMessage(msg.getAckSequence()));
                this.resetModesAndfireTransportConnectedEvent();
            } else {
                if (debug) {
                    this.debugLog("A DIFF-session client is trying to connect - request OOO Reset");
                }
                this.logger.info("Requesting OOO reset for different session client " + this.getConnectionId());
                long localAck = this.delivery.getReceiver().getReceived();
                this.sendMessage(this.createHandshakeReplyFailMessage(localAck));
                if (this.channelConnected.get()) {
                    this.receiveLayer.notifyTransportDisconnected(this, false);
                    this.channelConnected.set(false);
                }
                this.resetStack();
                this.delivery.resume();
                this.delivery.receive(this.createHandshakeReplyOkMessage(-1L));
                this.resetModesAndfireTransportConnectedEvent();
            }
        } else if (msg.isHandshakeReplyOk()) {
            Assert.assertTrue(this.isClient);
            Assert.assertTrue(this.handshakeMode.get());
            this.debugLog("Got reply OK");
            this.sessionId = msg.getSessionId();
            this.delivery.resume();
            this.delivery.receive(msg);
            this.resetModesAndfireTransportConnectedEvent();
        } else if (msg.isHandshakeReplyFail()) {
            if (debug) {
                this.debugLog("Received handshake fail reply - request for OOO reset channelConnected " + this.channelConnected);
            }
            Assert.assertTrue(this.isClient);
            Assert.assertTrue(this.handshakeMode.get());
            this.resetStack();
            this.sessionId = msg.getSessionId();
            this.delivery.resume();
            this.delivery.receive(this.createHandshakeReplyOkMessage(-1L));
            if (this.channelConnected.get()) {
                this.receiveLayer.notifyTransportDisconnected(this, false);
                this.channelConnected.set(false);
            }
            this.resetModesAndfireTransportConnectedEvent();
        } else if (msg.isGoodbye()) {
            if (debug) {
                this.debugLog("Got GoodBye message - shutting down");
            }
            if (this.isConnected()) {
                this.close();
            } else {
                this.logger.warn("Channel not yet connected. Ignoring OOO Goodbye Message: ChannelConnected: " + this.channelConnected.get() + "; DeliveryEngine: " + this.delivery);
            }
        } else {
            throw new AssertionError();
        }
    }

    private void resetModesAndfireTransportConnectedEvent() {
        this.debugLog("resetModesAndfireTransportConnectedEvent handshakeMode " + this.handshakeMode.get() + " channelConnected " + this.channelConnected.get() + " reconnectMode " + this.reconnectMode.get() + CallStackTrace.getCallStack());
        this.handshakeMode.set(false);
        if (!this.channelConnected.get()) {
            this.channelConnected.set(true);
            this.receiveLayer.notifyTransportConnected(this);
        } else {
            this.debugLog("OOOLayer-" + this.debugId + "-" + this.sendLayer.getConnectionId() + " -> not firing Tx connected event to channel");
        }
        this.reconnectMode.set(false);
    }

    private void debugLog(String msg) {
        if (debug) {
            DebugUtil.trace("OOOLayer-" + this.debugId + "-" + this.sendLayer.getConnectionId() + " -> " + msg);
        }
    }

    @Override
    public boolean isConnected() {
        return this.channelConnected.get() && !this.delivery.isPaused();
    }

    @Override
    public NetworkStackID open() throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.assertNotNull(this.sendLayer);
        return this.sendLayer.open();
    }

    @Override
    public void reset() {
        Assert.assertNotNull(this.sendLayer);
        this.sendLayer.reset();
    }

    @Override
    public void close() {
        this.isClosed = true;
        Assert.assertNotNull(this.sendLayer);
        if (this.isClient) {
            OOOProtocolMessage opm = this.messageFactory.createNewGoodbyeMessage(this.getSessionId());
            this.debugLog("Sending GoodBye message...");
            this.sendMessage(opm);
        } else {
            this.sendLayer.close();
            this.receiveLayer.close();
        }
        this.delivery.reset();
    }

    @Override
    public void initConnectionID(ConnectionID cid) {
        Assert.assertNotNull(this.sendLayer);
        this.sendLayer.initConnectionID(cid);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.handshakeMode.set(true);
        if (this.isClient) {
            OOOProtocolMessage handshake = this.createHandshakeMessage(this.delivery.getReceiver().getReceived());
            this.debugLog("Sending Handshake message...");
            this.sendMessage(handshake);
        } else if (!this.delivery.isPaused()) {
            this.notifyTransportDisconnected(null, false);
        }
        this.reconnectMode.set(false);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (this.isClosed()) {
            this.sendLayer.close();
            this.receiveLayer.close();
            this.delivery.pause();
        } else {
            boolean restoreConnectionMode = this.reconnectMode.get();
            this.debugLog("Transport Disconnected - pausing delivery, reconnectMode = " + restoreConnectionMode + " channelConnected " + this.channelConnected.get() + " forcedDisconnect " + forcedDisconnect + CallStackTrace.getCallStack());
            this.delivery.pause();
            if (!restoreConnectionMode) {
                if (this.channelConnected.get()) {
                    this.receiveLayer.notifyTransportDisconnected(this, forcedDisconnect);
                }
                this.channelConnected.set(false);
            }
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        if (!this.reconnectMode.get()) {
            this.receiveLayer.notifyTransportConnectAttempt(this);
        }
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.debugLog("Transport Closed - notifying higher layer");
        this.receiveLayer.notifyTransportClosed(this);
        this.channelConnected.set(false);
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.receiveLayer.notifyTransportReconnectionRejected(this);
    }

    @Override
    public OOOProtocolMessage createHandshakeMessage(long ack) {
        OOOProtocolMessage rv = this.messageFactory.createNewHandshakeMessage(this.getSessionId(), ack);
        return rv;
    }

    @Override
    public OOOProtocolMessage createHandshakeReplyOkMessage(long ack) {
        OOOProtocolMessage rv = this.messageFactory.createNewHandshakeReplyOkMessage(this.getSessionId(), ack);
        return rv;
    }

    @Override
    public OOOProtocolMessage createHandshakeReplyFailMessage(long ack) {
        OOOProtocolMessage rv = this.messageFactory.createNewHandshakeReplyFailMessage(this.getSessionId(), ack);
        return rv;
    }

    private UUID getSessionId() {
        return this.sessionId;
    }

    @Override
    public OOOProtocolMessage createAckMessage(long ack) {
        return this.messageFactory.createNewAckMessage(this.getSessionId(), ack);
    }

    @Override
    public boolean sendMessage(OOOProtocolMessage msg) {
        if (this.sendLayer.isConnected()) {
            this.sendLayer.send(msg);
            return true;
        }
        return false;
    }

    @Override
    public void receiveMessage(OOOProtocolMessage msg) {
        Assert.assertNotNull("Receive layer is null.", this.receiveLayer);
        Assert.assertNotNull("Attempt to null msg", msg);
        Assert.eval(msg.isSend());
        this.receiveLayer.receive(msg.getPayload());
    }

    @Override
    public OOOProtocolMessage createProtocolMessage(long sequence, TCNetworkMessage msg) {
        OOOProtocolMessage rv = this.messageFactory.createNewSendMessage(this.getSessionId(), sequence, this.delivery.getReceiver().ackSequence(), msg);
        final Runnable callback = msg.getSentCallback();
        if (callback != null) {
            rv.setSentCallback(new Runnable(){

                @Override
                public void run() {
                    callback.run();
                }
            });
        }
        return rv;
    }

    private OOOProtocolMessage createProtocolMessage(TCByteBuffer[] msgData) {
        try {
            return this.messageParser.parseMessage(msgData);
        }
        catch (TCProtocolException e) {
            throw new TCRuntimeException(e);
        }
    }

    @Override
    public void attachNewConnection(TCConnection connection) {
        throw new AssertionError((Object)"Must not call!");
    }

    @Override
    public void setAllowConnectionReplace(boolean allow) {
        throw new AssertionError((Object)"Must not call!");
    }

    @Override
    public ConnectionID getConnectionId() {
        return this.sendLayer != null ? this.sendLayer.getConnectionId() : null;
    }

    @Override
    public TCSocketAddress getLocalAddress() {
        return this.sendLayer.getLocalAddress();
    }

    @Override
    public TCSocketAddress getRemoteAddress() {
        return this.sendLayer.getRemoteAddress();
    }

    @Override
    public void receiveTransportMessage(WireProtocolMessage message) {
        throw new AssertionError((Object)"Must not call!");
    }

    @Override
    public void sendToConnection(TCNetworkMessage message) {
        throw new AssertionError((Object)"Must not call!");
    }

    @Override
    public void startRestoringConnection() {
        this.debugLog("Switched to restoreConnection mode");
        this.reconnectMode.set(true);
    }

    @Override
    public Timer getRestoreConnectTimer() {
        Assert.assertNotNull(this.restoreConnectTimer);
        return this.restoreConnectTimer;
    }

    @Override
    public void connectionRestoreFailed() {
        this.debugLog("RestoreConnectionFailed - resetting stack channelConnected " + this.channelConnected + CallStackTrace.getCallStack());
        if (this.channelConnected.get()) {
            this.receiveLayer.notifyTransportDisconnected(this, false);
            this.channelConnected.set(false);
        }
        this.reconnectMode.set(false);
        this.delivery.pause();
        this.delivery.reset();
        this.sessionId = UUID.getUUID();
    }

    private void resetStack() {
        this.reconnectMode.set(false);
        this.delivery.pause();
        this.delivery.reset();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public short getStackLayerFlag() {
        return 2;
    }

    @Override
    public String getStackLayerName() {
        return "Once and Only Once Protocol Layer";
    }

    @Override
    public void setRemoteCallbackPort(int callbackPort) {
        throw new AssertionError();
    }

    @Override
    public int getRemoteCallbackPort() {
        throw new AssertionError();
    }

    public NetworkLayer getSendLayer() {
        return this.sendLayer;
    }
}

