/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyValuePropagation;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class MethodHandleValuePropagation
extends PropertyValuePropagation {
    private MethodHandle getHandle;
    private MethodHandle setHandle;

    MethodHandleValuePropagation(Property property, PropertyVisibilityStrategy propertyVisibilityStrategy) {
        super(property, propertyVisibilityStrategy);
    }

    @Override
    protected void acceptMethod(Method method, PropertyValuePropagation.OperationMode mode) {
        try {
            switch (mode) {
                case GET: {
                    this.getHandle = MethodHandles.lookup().unreflect(method);
                    break;
                }
                case SET: {
                    this.setHandle = MethodHandles.lookup().unreflect(method);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mode");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.CREATING_HANDLES, new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected void acceptField(Field field, PropertyValuePropagation.OperationMode mode) {
        try {
            switch (mode) {
                case GET: {
                    this.getHandle = MethodHandles.lookup().unreflectGetter(field);
                    break;
                }
                case SET: {
                    this.setHandle = MethodHandles.lookup().unreflectSetter(field);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mode");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.CREATING_HANDLES, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void setValue(Object object, Object value) {
        try {
            this.setHandle.invoke(object, value);
        }
        catch (Throwable throwable) {
            throw new JsonbException(Messages.getMessage(MessageKeys.SETTING_VALUE_WITH, this.setHandle), throwable);
        }
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this.getHandle.invoke(object);
        }
        catch (Throwable throwable) {
            throw new JsonbException(Messages.getMessage(MessageKeys.GETTING_VALUE_WITH, this.getHandle), throwable);
        }
    }
}

