/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.Mapping;
import org.eclipse.emf.mwe.utils.ProjectMapping;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneSetup {
    private static String platformRootPath = null;
    private Map<String, String> bundleNameMapping = new HashMap<String, String>();
    private Log log = LogFactory.getLog(this.getClass());
    private boolean ignoreBrokenProjectFiles = false;
    protected ResourceSet resourceSet = new ResourceSetImpl();
    protected EPackage.Registry registry = EPackage.Registry.INSTANCE;

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
    }

    public static String getPlatformRootPath() {
        return platformRootPath;
    }

    public void setIgnoreBrokenProjectFiles(boolean ignoreBrokenProjectFiles) {
        this.ignoreBrokenProjectFiles = ignoreBrokenProjectFiles;
    }

    public boolean isIgnoreBrokenProjectFiles() {
        return this.ignoreBrokenProjectFiles;
    }

    public void setLogResourceUriMap(boolean doLog) {
        if (!doLog) {
            return;
        }
        ArrayList entrySet = new ArrayList(EcorePlugin.getPlatformResourceMap().entrySet());
        Collections.sort(entrySet, new Comparator<Map.Entry<String, URI>>(){

            @Override
            public int compare(Map.Entry<String, URI> o1, Map.Entry<String, URI> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : entrySet) {
            this.log.info((Object)(String.valueOf((String)entry.getKey()) + " - " + entry.getValue()));
        }
    }

    public void setScanClassPath(boolean doScan) {
        ClassLoader classLoader;
        if (!doScan) {
            return;
        }
        String property = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        HashSet<File> scanned = new HashSet<File>();
        if (property != null) {
            String[] entries;
            String[] stringArray = entries = property.split(separator);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                File file = new File(entry);
                scanned.add(file);
                this.doRegisterResourceMapping(file);
                ++n2;
            }
        }
        if ((classLoader = this.getClass().getClassLoader()) instanceof URLClassLoader) {
            URL[] urLs;
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] uRLArray = urLs = urlClassLoader.getURLs();
            int n = urLs.length;
            int n3 = 0;
            while (n3 < n) {
                URL url = uRLArray[n3];
                try {
                    File file = new File(url.toURI());
                    if (scanned.add(file)) {
                        this.doRegisterResourceMapping(file);
                    }
                }
                catch (URISyntaxException e) {
                    this.log.debug((Object)("Couldn't convert url '" + url + "' to a file : " + e.getMessage()));
                }
                ++n3;
            }
        }
    }

    protected void doRegisterResourceMapping(File file) {
        try {
            File dotProject;
            File f = file.getCanonicalFile();
            if (f.getPath().endsWith(".jar")) {
                this.registerBundle(f);
            } else if (!this.scanFolder(f) && (dotProject = new File(f.getParentFile(), ".project")).exists()) {
                this.registerProject(dotProject);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPlatformUri(String pathToPlatform) {
        File f = new File(pathToPlatform);
        if (!f.exists()) {
            throw new ConfigurationException("The platformUri location '" + pathToPlatform + "' does not exist");
        }
        if (!f.isDirectory()) {
            throw new ConfigurationException("The platformUri location must point to a directory");
        }
        String path = f.getAbsolutePath();
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            this.log.error((Object)"Error when registering platform location", (Throwable)e);
        }
        if (platformRootPath == null || !platformRootPath.equals(path)) {
            platformRootPath = path;
            this.log.info((Object)("Registering platform uri '" + path + "'"));
            if (f.exists() && !this.scanFolder(f)) {
                this.log.warn((Object)("No projects found in platform location '" + pathToPlatform + "'\n" + "because there are no '.project' files.\n" + "Please use explicit project mappings:\n" + "    projectMapping = { projectName = 'com.acme' path = '../path/com.acme' }."));
            }
        }
    }

    public void addProjectMapping(ProjectMapping projectMapping) {
        String projectName = projectMapping.getProjectName();
        if (this.isEmptyOrNullString(projectName)) {
            throw new ConfigurationException("ProjectName must not be empty");
        }
        String path = projectMapping.getPath();
        if (this.isEmptyOrNullString(path)) {
            throw new ConfigurationException("Path must not be empty");
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new ConfigurationException("The project's path '" + path + "' does not exist");
        }
        try {
            URI uri = URI.createFileURI((String)(String.valueOf(f.getCanonicalPath()) + File.separator));
            EcorePlugin.getPlatformResourceMap().put(projectName, uri);
            if (this.bundleNameMapping.get(projectName) != null) {
                EcorePlugin.getPlatformResourceMap().put(this.bundleNameMapping.get(projectName), uri);
            }
            this.log.info((Object)("Registering project " + projectName + " at '" + uri + "'"));
        }
        catch (IOException e) {
            this.handleException(f, e);
        }
    }

    private boolean isEmptyOrNullString(String string) {
        return string == null || string.length() == 0;
    }

    protected boolean scanFolder(File f) {
        return this.scanFolder(f, new HashSet<String>());
    }

    protected boolean scanFolder(File f, Set<String> visitedPathes) {
        try {
            if (!visitedPathes.add(f.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isDirectory() && !file.getName().startsWith(".")) {
                    containsProject |= this.scanFolder(file, visitedPathes);
                } else if (".project".equals(file.getName())) {
                    dotProject = file;
                } else if (file.getName().endsWith(".jar")) {
                    this.registerBundle(file);
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    protected void registerBundle(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return;
            }
            try {
                String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name != null) {
                    int indexOf = name.indexOf(59);
                    if (indexOf > 0) {
                        name = name.substring(0, indexOf);
                    }
                    String path = "archive:" + file.getCanonicalFile().toURI() + "!/";
                    URI uri = URI.createURI((String)path);
                    this.registerMapping(name, uri);
                }
            }
            catch (ZipException e) {
                this.log.warn((Object)("Could not open Jar file " + file.getAbsolutePath() + "."));
            }
            catch (Exception e) {
                this.handleException(file, e);
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleException(File file, Exception exception) {
        if (this.isIgnoreBrokenProjectFiles()) {
            try {
                this.log.warn((Object)("Couldn't read " + file.getCanonicalPath()));
            }
            catch (IOException e) {
                this.log.warn((Object)("Couldn't read " + file.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(exception);
        }
    }

    protected void registerMapping(String name, URI uri) {
        URI existing;
        Map map = EcorePlugin.getPlatformResourceMap();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering project " + name + " at '" + uri + "'"));
        }
        if ((existing = map.put(name, uri)) != null) {
            if (!existing.equals((Object)uri)) {
                if (existing.isArchive() == uri.isArchive()) {
                    this.log.warn((Object)("Skipping conflicting project " + name + " at '" + existing + "' and using '" + uri + "' instead."));
                } else if (!existing.isArchive() && uri.isArchive()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping duplicate project " + name + " at '" + uri + "' and using '" + existing + "' instead (folders win over JARs)."));
                    }
                    map.put(name, existing);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping duplicate project " + name + " at '" + existing + "' and using '" + uri + "' instead (folders win over JARs)."));
                }
            }
        } else {
            String mappedName = this.bundleNameMapping.get(name);
            if (mappedName != null) {
                this.registerMapping(mappedName, uri);
            }
        }
    }

    protected void registerProject(File file) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(file));
            String name = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
            URI uri = URI.createFileURI((String)(String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator));
            this.registerMapping(name, uri);
        }
        catch (Exception e) {
            this.handleException(file, e);
        }
    }

    public void addUriMap(Mapping uriMap) {
        this.log.info((Object)("Adding URI mapping from '" + uriMap.getFrom() + "' to '" + uriMap.getTo() + "'"));
        URI baseUri = URI.createURI((String)uriMap.getFrom());
        URI mappedUri = URI.createURI((String)uriMap.getTo());
        if (mappedUri == null) {
            throw new ConfigurationException("cannot make URI out of " + uriMap.getTo());
        }
        URIConverter.URI_MAP.put(baseUri, mappedUri);
    }

    public void addExtensionMap(Mapping m) throws ConfigurationException {
        this.log.info((Object)("Adding Extension mapping from '" + m.getFrom() + "' to '" + m.getTo() + "'"));
        try {
            Class<?> factoryClass = ResourceLoaderFactory.createResourceLoader().loadClass(m.getTo());
            if (factoryClass == null) {
                throw new ConfigurationException("cannot find class " + m.getTo() + " for extension " + m.getFrom());
            }
            Object factoryInstance = null;
            if (factoryClass.isInterface()) {
                Class<?>[] innerClasses = factoryClass.getDeclaredClasses();
                factoryClass = null;
                int j = 0;
                while (j < innerClasses.length) {
                    if (Resource.Factory.class.isAssignableFrom(innerClasses[j])) {
                        factoryClass = innerClasses[j];
                    }
                    ++j;
                }
                if (factoryClass == null) {
                    throw new ConfigurationException("cannot find inner factory class " + m.getTo() + " for extension " + m.getFrom());
                }
                Field instanceField = factoryClass.getField("INSTANCE");
                factoryInstance = instanceField.get(null);
            } else {
                factoryInstance = factoryClass.newInstance();
            }
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(m.getFrom(), factoryInstance);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void addRegisterGeneratedEPackage(String interfacename) {
        Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(interfacename);
        if (clazz == null) {
            throw new ConfigurationException("Couldn't find an interface " + interfacename);
        }
        try {
            EPackage pack = (EPackage)clazz.getDeclaredField("eINSTANCE").get(null);
            this.registry.put((Object)pack.getNsURI(), (Object)pack);
            this.log.info((Object)("Adding generated EPackage '" + interfacename + "'"));
        }
        catch (Exception e) {
            throw new ConfigurationException("Couldn't register " + interfacename + ". Is it the generated EPackage interface? : " + e.getMessage());
        }
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.log.info((Object)"Using resourceSet registry. The registered Packages will not be registered in the global EPackage.Registry.INSTANCE!");
        this.resourceSet = resourceSet;
        this.registry = resourceSet.getPackageRegistry();
    }

    public void setResourceSetImpl(ResourceSetImpl resourceSet) {
        this.setResourceSet((ResourceSet)resourceSet);
    }

    protected GenModelHelper createGenModelHelper() {
        return new GenModelHelper();
    }

    public void addRegisterGenModelFile(String fileName) {
        this.createGenModelHelper().registerGenModel(this.resourceSet, this.createURI(fileName));
    }

    public void addRegisterEcoreFile(String fileName) throws IllegalArgumentException, SecurityException {
        Resource res = this.resourceSet.getResource(this.createURI(fileName), true);
        if (res == null) {
            throw new ConfigurationException("Couldn't find resource under  " + fileName);
        }
        if (!res.isLoaded()) {
            try {
                res.load(null);
            }
            catch (IOException e) {
                throw new ConfigurationException("Couldn't load resource under  " + fileName + " : " + e.getMessage());
            }
        }
        EList result = res.getContents();
        for (EObject object : result) {
            if (object instanceof EPackage) {
                this.registerPackage(fileName, object);
            }
            TreeIterator it = object.eAllContents();
            while (it.hasNext()) {
                EObject child = (EObject)it.next();
                if (!(child instanceof EPackage)) continue;
                this.registerPackage(fileName, child);
            }
        }
    }

    public EPackage getPackage(String nsUri) {
        return (EPackage)this.registry.get((Object)nsUri);
    }

    public void addBundleNameMap(Mapping mapping) {
        this.bundleNameMapping.put(mapping.getFrom(), mapping.getTo());
    }

    private URI createURI(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        URI uri = URI.createURI((String)path);
        if (uri.isRelative()) {
            URI resolvedURI = URI.createFileURI((String)new File(path).getAbsolutePath());
            return resolvedURI;
        }
        return uri;
    }

    private void registerPackage(String fileName, EObject object) {
        String nsUri = ((EPackage)object).getNsURI();
        if (this.registry.get((Object)nsUri) == null) {
            this.registry.put((Object)nsUri, (Object)object);
            this.log.info((Object)("Adding dynamic EPackage '" + nsUri + "' from '" + fileName + "'"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dynamic EPackage '" + nsUri + "' from '" + fileName + "' already in the registry!"));
        }
    }
}

