/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.DefaultGeneratorFragment;
import org.eclipse.xtext.generator.IGeneratorFragment;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NamingAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingGeneratorFragment
extends DefaultGeneratorFragment
implements NamingAware {
    private IGeneratorFragment delegate;
    private String message;
    private IGeneratorFragment fallback = new DefaultGeneratorFragment();
    private Naming naming;

    public void setFallback(IGeneratorFragment fragment) {
        this.fallback = fragment;
    }

    public void setDelegate(String className) {
        try {
            Class<?> delegateClass = ResourceLoaderFactory.createResourceLoader().loadClass(className);
            this.delegate = (IGeneratorFragment)delegateClass.newInstance();
            return;
        }
        catch (Exception exception) {
            this.delegate = null;
            return;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void checkConfiguration(Issues issues) {
        if (this.delegate == null && this.message != null) {
            issues.addWarning("---- ATTENTION----\n\t\n\n\t" + this.message);
        }
        if (this.fallback instanceof NamingAware) {
            ((NamingAware)((Object)this.fallback)).registerNaming(this.getNaming());
        }
        if (this.delegate instanceof NamingAware) {
            ((NamingAware)((Object)this.delegate)).registerNaming(this.getNaming());
        }
        if (this.delegate != null) {
            this.delegate.checkConfiguration(issues);
        } else {
            this.fallback.checkConfiguration(issues);
        }
    }

    @Override
    public void addToPluginXmlRt(Grammar grammar, XpandExecutionContext ctx) {
        if (this.delegate != null) {
            this.delegate.addToPluginXmlRt(grammar, ctx);
        } else {
            this.fallback.addToPluginXmlRt(grammar, ctx);
        }
    }

    @Override
    public void addToPluginXmlUi(Grammar grammar, XpandExecutionContext ctx) {
        if (this.delegate != null) {
            this.delegate.addToPluginXmlUi(grammar, ctx);
        } else {
            this.fallback.addToPluginXmlUi(grammar, ctx);
        }
    }

    @Override
    public void addToStandaloneSetup(Grammar grammar, XpandExecutionContext ctx) {
        if (this.delegate != null) {
            this.delegate.addToStandaloneSetup(grammar, ctx);
        } else {
            this.fallback.addToStandaloneSetup(grammar, ctx);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        if (this.delegate != null) {
            this.delegate.generate(grammar, ctx);
        } else {
            this.fallback.generate(grammar, ctx);
        }
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getExportedPackagesRt(grammar);
        }
        return this.fallback.getExportedPackagesRt(grammar);
    }

    @Override
    public String[] getExportedPackagesUi(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getExportedPackagesUi(grammar);
        }
        return this.fallback.getExportedPackagesUi(grammar);
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getGuiceBindingsRt(grammar);
        }
        return this.fallback.getGuiceBindingsRt(grammar);
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getGuiceBindingsUi(grammar);
        }
        return this.fallback.getGuiceBindingsUi(grammar);
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getRequiredBundlesRt(grammar);
        }
        return this.fallback.getRequiredBundlesRt(grammar);
    }

    @Override
    public String[] getRequiredBundlesUi(Grammar grammar) {
        if (this.delegate != null) {
            return this.delegate.getRequiredBundlesUi(grammar);
        }
        return this.fallback.getRequiredBundlesUi(grammar);
    }

    @Override
    public void registerNaming(Naming n) {
        this.naming = n;
    }

    public Naming getNaming() {
        return this.naming;
    }
}

