/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolver;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolverImpl;
import org.eclipse.internal.xtend.xtend.parser.ParseException;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Xpand Generator";
    protected String expand = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private List<? extends PostProcessor> beautifier = new ArrayList<PostProcessor>();
    protected final List<String> advices = new ArrayList<String>();
    protected final List<String> extensionAdvices = new ArrayList<String>();
    private boolean automaticHyphens = false;
    private Output output = null;
    private ProtectedRegionResolverImpl prResolver;
    private final List<Outlet> outlets = new ArrayList<Outlet>(2);

    public void setAutomaticHyphens(boolean automaticHyphens) {
        this.automaticHyphens = automaticHyphens;
    }

    @Override
    public String getLogMessage() {
        HashSet<String> outletDescriptions = new HashSet<String>();
        for (Outlet outlet : this.outlets) {
            outletDescriptions.add(outlet.toString());
        }
        String outletDesc = outletDescriptions.size() == 1 ? (String)outletDescriptions.iterator().next() : ((Object)outletDescriptions).toString();
        return "generating '" + this.expand + "' => " + outletDesc;
    }

    @Override
    public void addAdvice(String advice) {
        if (!this.advices.contains(advice)) {
            this.advices.add(advice);
        }
    }

    @Override
    public void addExtensionAdvice(String extensionAdvice) {
        if (!this.extensionAdvices.contains(extensionAdvice)) {
            this.extensionAdvices.add(extensionAdvice);
        }
    }

    @Deprecated
    public List<? extends PostProcessor> getBeautifier() {
        return this.beautifier;
    }

    @Deprecated
    public void setBeautifier(List<? extends PostProcessor> beautifiers) {
        this.beautifier = beautifiers;
        if (!this.getOutlets().isEmpty()) {
            throw new IllegalStateException("'beautifier' must be configured before any Outlet.");
        }
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
        if (!this.getOutlets().isEmpty()) {
            throw new IllegalStateException("'fileEncoding' must be configured before any Outlet.");
        }
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Deprecated
    public void setGenPath(String genPath) {
        Outlet o = this.createOutlet();
        o.setAppend(false);
        o.setFileEncoding(this.fileEncoding);
        o.setOverwrite(true);
        o.setPath(this.fixPath(genPath));
        this.outlets.add(o);
        o = this.createOutlet();
        o.setAppend(true);
        o.setFileEncoding(this.fileEncoding);
        o.setName("APPEND");
        o.setOverwrite(true);
        o.setPath(genPath);
        this.outlets.add(o);
    }

    public void setExpand(String invoke) {
        this.expand = invoke;
    }

    public void setPrDefaultExcludes(boolean prDefaultExcludes) {
        if (this.prResolver == null) {
            this.prResolver = new ProtectedRegionResolverImpl();
        }
        this.prResolver.setDefaultExcludes(prDefaultExcludes);
    }

    public void setPrExcludes(String prExcludes) {
        if (this.prResolver == null) {
            this.prResolver = new ProtectedRegionResolverImpl();
        }
        this.prResolver.setIgnoreList(prExcludes);
    }

    public void setPrSrcPaths(String prSrcPathes) {
        if (this.prResolver == null) {
            this.prResolver = new ProtectedRegionResolverImpl();
        }
        this.prResolver.setSrcPathes(prSrcPathes);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Deprecated
    public void setSrcPath(String srcPath) {
        Outlet o = this.createOutlet();
        o.setAppend(false);
        o.setFileEncoding(this.fileEncoding);
        o.setName("ONCE");
        o.setOverwrite(false);
        o.setPath(this.fixPath(srcPath));
        this.outlets.add(o);
    }

    private String fixPath(String p) {
        if (p.endsWith("\\")) {
            return p.replace('\\', '/');
        }
        if (p.endsWith("/")) {
            return p;
        }
        return String.valueOf(p) + "/";
    }

    @Override
    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ExpandStatement es = this.getStatement();
        if (es == null) {
            throw new ConfigurationException("property 'expand' has wrong syntax!");
        }
        XpandExecutionContext executionContext = this.createExecutionContext(ctx, monitor, issues);
        es.evaluate(executionContext);
        for (Outlet element : this.getOutlets()) {
            String name = String.valueOf(element.getName() == null ? "[default]" : element.getName()) + "(" + element.getPath() + ")";
            if (element.getFilesWrittenAndClosed() > 0) {
                this.log.info((Object)("Written " + element.getFilesWrittenAndClosed() + " files to outlet " + name));
            }
            if (element.getFilesCreated() <= element.getFilesWrittenAndClosed()) continue;
            this.log.info((Object)("Skipped writing of " + (element.getFilesCreated() - element.getFilesWrittenAndClosed()) + " files to outlet " + name));
        }
    }

    protected XpandExecutionContext createExecutionContext(WorkflowContext wfContext, ProgressMonitor monitor, Issues issues) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        String[] names;
        ProtectedRegionResolver prs = this.getProtectedRegionResolver();
        ResourceManager resourceManager = this.getResourceManager();
        Output out = this.getOutput();
        XpandExecutionContextImpl executionContext = new XpandExecutionContextImpl(resourceManager, out, prs, this.getGlobalVars(wfContext), monitor, this.exceptionHandler, this.getNullEvaluationHandler(), this.callback);
        for (MetaModel mm : this.metaModels) {
            executionContext.registerMetaModel(mm);
        }
        String[] stringArray2 = names = wfContext.getSlotNames();
        int n3 = names.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            executionContext = (XpandExecutionContextImpl)executionContext.cloneWithVariable(new Variable(name, wfContext.get(name)));
            ++n4;
        }
        for (String advice : this.advices) {
            String[] allAdvices;
            stringArray = allAdvices = advice.split(",");
            n2 = allAdvices.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                executionContext.registerAdvices(string.trim());
                ++n;
            }
        }
        for (String advice : this.extensionAdvices) {
            String[] allAdvices;
            stringArray = allAdvices = advice.split(",");
            n2 = allAdvices.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                executionContext.registerExtensionAdvices(string.trim());
                ++n;
            }
        }
        return executionContext;
    }

    protected ProtectedRegionResolver getProtectedRegionResolver() {
        if (this.prResolver == null) {
            this.prResolver = new ProtectedRegionResolverImpl();
        }
        this.prResolver.setFileEncoding(this.fileEncoding);
        return this.prResolver;
    }

    public void addOutlet(Outlet outlet) {
        this.outlets.add(outlet);
        if (outlet.postprocessors.isEmpty()) {
            Iterator<? extends PostProcessor> iterator = this.beautifier.iterator();
            while (iterator.hasNext()) {
                PostProcessor name;
                PostProcessor element = name = iterator.next();
                outlet.addPostprocessor(element);
            }
        }
        if (outlet.getFileEncoding() == null) {
            outlet.setFileEncoding(this.fileEncoding);
        }
    }

    public void setOutput(Output output) {
        this.output = output;
        if (!this.getOutlets().isEmpty()) {
            for (Outlet o : this.getOutlets()) {
                output.addOutlet(o);
            }
        } else {
            this.log.warn((Object)"No Outlet configured for Generator component. Make sure that the configured Output has Outlets configured.");
        }
    }

    protected final Output getOutput() {
        if (this.output == null) {
            this.output = this.createOutput();
        }
        return this.output;
    }

    public final List<Outlet> getOutlets() {
        return Collections.unmodifiableList(this.outlets);
    }

    protected final ExpandStatement getStatement() {
        Template tpl = XpandParseFacade.file(new StringReader("\u00abDEFINE test FOR test\u00bb\u00abEXPAND " + this.expand + "\u00bb" + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        ExpandStatement es = null;
        try {
            es = (ExpandStatement)((Definition)tpl.getDefinitions()[0]).getBody()[1];
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return es;
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.getOutlets().isEmpty()) {
            issues.addError(this, "You need to configure at least one outlet!");
        }
        int defaultOutlets = 0;
        for (Outlet o : this.getOutlets()) {
            if (o.getName() != null) continue;
            ++defaultOutlets;
        }
        if (defaultOutlets > 1) {
            issues.addError(this, "Only one outlet can be the default outlet. Please specifiy a name for the other outlets!");
        } else if (defaultOutlets == 0) {
            issues.addWarning(this, "No default outlet configured!");
        }
        if (this.expand == null) {
            issues.addError(this, "property 'expand' not configured!");
        } else {
            try {
                ExpandStatement es = this.getStatement();
                if (es == null) {
                    issues.addError(this, "property 'expand' has wrong syntax!");
                }
            }
            catch (ParseException e) {
                issues.addError(this, "property 'expand' has wrong syntax : " + e.getMessage());
            }
        }
    }

    protected Output createOutput() {
        OutputImpl out = new OutputImpl();
        out.setAutomaticHyphens(this.automaticHyphens);
        for (Outlet o : this.getOutlets()) {
            out.addOutlet(o);
        }
        return out;
    }

    protected Outlet createOutlet() {
        return new Outlet();
    }
}

