/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.check.CheckFacade;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Check component";
    private String expression = null;
    private final List<String> checkFiles = new ArrayList<String>();
    private boolean abortOnError = true;
    private boolean warnIfNothingChecked = false;
    private String emfAllChildrenSlot;

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void addCheckFile(String checkFile) {
        this.checkFiles.add(checkFile);
    }

    public List<String> getCheckFiles() {
        return Collections.unmodifiableList(this.checkFiles);
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setWarnIfNothingChecked(boolean warn) {
        this.warnIfNothingChecked = warn;
    }

    public boolean isWarnIfNothingChecked() {
        return this.warnIfNothingChecked;
    }

    public void setEmfAllChildrenSlot(String childExpression) {
        this.emfAllChildrenSlot = childExpression;
    }

    public String getEmfAllChildrenSlot() {
        return this.emfAllChildrenSlot;
    }

    @Override
    public String getLogMessage() {
        StringBuilder b = new StringBuilder();
        if (this.emfAllChildrenSlot != null) {
            b.append("slot " + this.emfAllChildrenSlot + " ");
        } else {
            b.append("expression " + this.expression + " ");
        }
        b.append("check file(s): ");
        for (String f : this.checkFiles) {
            b.append(String.valueOf(f) + " ");
        }
        return b.toString();
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ExecutionContextImpl executionContext = this.getExecutionContext(ctx);
        if (monitor != null) {
            executionContext.setMonitor(monitor);
        }
        Collection<?> model = this.getExpressionResult(executionContext, ctx, this.getExpression());
        for (String checkFile : this.getCheckFiles()) {
            CheckFacade.checkAll(checkFile, model, executionContext, issues, this.isWarnIfNothingChecked());
        }
        if (this.isAbortOnError() && issues.hasErrors()) {
            throw new WorkflowInterruptedException("Errors during validation.");
        }
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.getExpression() == null && this.getEmfAllChildrenSlot() != null) {
            this.setExpression(String.valueOf(this.getEmfAllChildrenSlot()) + ".eAllContents.union( {" + this.getEmfAllChildrenSlot() + "} )");
        } else if (this.getExpression() == null || this.getEmfAllChildrenSlot() != null) {
            issues.addError(this, "You have to set one of the properties 'expression' and 'emfAllChildrenSlot'!");
        }
        if (this.getCheckFiles().isEmpty()) {
            issues.addError(this, "Property 'checkFile' not set!");
        }
    }

    protected Collection<?> getExpressionResult(ExecutionContext exeCtx, WorkflowContext context, String expression2) {
        String[] names;
        ExpressionFacade f = new ExpressionFacade(exeCtx);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        String[] stringArray = names = context.getSlotNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ctx.put(name, context.get(name));
            ++n2;
        }
        Object result = f.evaluate(expression2, ctx);
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(result);
    }
}

