/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Set;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.XpandAnalyzable;
import org.eclipse.internal.xpand2.ast.XpandEvaluatable;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statement
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    protected AbstractDefinition containingDefinition;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void evaluate(XpandExecutionContext ctx) {
        try {
            ProgressMonitor monitor = ctx.getMonitor();
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            ctx.getOutput().pushStatement(this, ctx);
            ctx.preTask(this);
            this.evaluateInternal(ctx);
            ctx.postTask(this);
            ctx.getOutput().popStatement();
            return;
        }
        catch (RuntimeException exc) {
            ctx.handleRuntimeException(exc, this, null);
            return;
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }

    @Override
    public final void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        block9: {
            try {
                if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                    return;
                }
                try {
                    this.analyzeInternal(ctx, issues);
                }
                catch (RuntimeException ex) {
                    String message = ex.getMessage();
                    if (message != null) {
                        issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), this));
                        break block9;
                    }
                    throw ex;
                }
            }
            finally {
                if (ctx.getCallback() != null) {
                    ctx.getCallback().post(this, ctx, null);
                }
            }
        }
    }

    protected abstract void evaluateInternal(XpandExecutionContext var1);

    protected abstract void analyzeInternal(XpandExecutionContext var1, Set<AnalysationIssue> var2);

    public AbstractDefinition getContainingDefinition() {
        return this.containingDefinition;
    }

    public void setContainingDefinition(AbstractDefinition definition) {
        this.containingDefinition = definition;
    }
}

