/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Xtend Component";
    private String extensionFile = null;
    private final List<String> extensionAdvices = new ArrayList<String>();
    private String invokeExpression;
    private String expression = null;
    @Deprecated
    private String collectProfileSummary = null;
    @Deprecated
    private String verboseProfileFilename = null;
    private String outputSlot = "default";

    @Override
    public void addExtensionAdvice(String extensionAdvice) {
        if (!this.extensionAdvices.contains(extensionAdvice)) {
            this.extensionAdvices.add(extensionAdvice);
        }
    }

    protected List<String> getExtensionAdvices() {
        return Collections.unmodifiableList(this.extensionAdvices);
    }

    @Override
    public void checkConfigurationInternal(Issues issues) {
        String compPrefix;
        super.checkConfigurationInternal(issues);
        String string = compPrefix = this.getId() != null ? String.valueOf(this.getId()) + ": " : "";
        if (this.getInvoke() == null || this.getInvoke().trim().length() == 0) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified.");
            return;
        }
        if (this.getExtensionFile() == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract name of the extension file.");
            return;
        }
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(String.valueOf(this.getExtensionFile().replace("::", "/")) + ".ext");
        if (in == null || this.getExpression() == null) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified properly. AbstractExtension file '" + this.getExtensionFile() + "' not found.");
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.log.error((Object)"I/O exception", (Throwable)e);
        }
        if (this.getExpression() == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract the expression to invoke in extension file '" + this.getExtensionFile() + "'.");
            return;
        }
    }

    @Override
    public String getLogMessage() {
        return "executing '" + this.getExtensionFile() + "'";
    }

    @Override
    public void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        String[] slots;
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(String.valueOf(this.getExtensionFile().replace("::", "/")) + ".ext");
        if (in == null) {
            issues.addError("Cannot find extension file: " + this.getExtensionFile());
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.log.error((Object)"I/O exception", (Throwable)e);
        }
        BufferedOutputStream verboseProfileOutputStream = null;
        if (this.verboseProfileFilename != null) {
            try {
                verboseProfileOutputStream = new BufferedOutputStream(new FileOutputStream(this.verboseProfileFilename));
                ProfileCollector.getInstance().setDetailedLoggingWriter(verboseProfileOutputStream);
            }
            catch (IOException exc) {
                this.log.warn((Object)"could not open profiling log file", (Throwable)exc);
            }
        }
        ExecutionContextImpl ec = this.getExecutionContext(ctx);
        for (String advice : this.getExtensionAdvices()) {
            String[] allAdvices;
            String[] stringArray = allAdvices = advice.split(",");
            int n = allAdvices.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ec.registerExtensionAdvices(string.trim());
                ++n2;
            }
        }
        ec = (ExecutionContextImpl)ec.cloneWithResource(new Resource(){
            private String name = "noName";

            public String getFullyQualifiedName() {
                return this.name;
            }

            public String[] getImportedExtensions() {
                return new String[]{XtendComponent.this.getExtensionFile()};
            }

            public String[] getImportedNamespaces() {
                return new String[0];
            }

            public void setFullyQualifiedName(String fqn) {
                this.name = fqn;
            }
        });
        String[] stringArray = slots = ctx.getSlotNames();
        int n = slots.length;
        int allAdvices = 0;
        while (allAdvices < n) {
            String slot = stringArray[allAdvices];
            ec = (ExecutionContextImpl)ec.cloneWithVariable(new Variable(slot, ctx.get(slot)));
            ++allAdvices;
        }
        if (monitor != null) {
            ec.setMonitor(monitor);
        }
        Object result = new ExpressionFacade(ec).evaluate(this.getExpression());
        ctx.set(this.getOutputSlot(), result);
        ProfileCollector.getInstance().finish();
        if ("true".equalsIgnoreCase(this.collectProfileSummary)) {
            this.log.info((Object)("profiling info: \n" + ProfileCollector.getInstance().toString()));
        }
        if (verboseProfileOutputStream != null) {
            try {
                ((OutputStream)verboseProfileOutputStream).close();
            }
            catch (IOException exc) {
                this.log.warn((Object)"problem closing profile log file", (Throwable)exc);
            }
        }
    }

    @Deprecated
    public void setCollectProfileSummary(String summary) {
        this.collectProfileSummary = summary;
    }

    public void setInvoke(String invokeExpr) {
        this.invokeExpression = invokeExpr;
        int i = invokeExpr.lastIndexOf("::");
        if (i != -1) {
            this.extensionFile = invokeExpr.substring(0, i);
            this.expression = invokeExpr.substring(i + 2);
        } else {
            this.expression = invokeExpr;
        }
    }

    protected String getInvoke() {
        return this.invokeExpression;
    }

    protected String getExtensionFile() {
        return this.extensionFile;
    }

    protected String getExpression() {
        return this.expression;
    }

    public void setOutputSlot(String outputSlot) {
        this.outputSlot = outputSlot;
    }

    protected String getOutputSlot() {
        return this.outputSlot;
    }

    public void setVerboseProfileFilename(String fileName) {
        this.verboseProfileFilename = fileName;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

