/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.cli;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectsCreator;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

public class CliProjectsCreator
implements ProjectsCreator {
    @Accessors
    private String lineDelimiter;

    @Override
    public void createProjects(WizardConfiguration config) {
        Set<ProjectDescriptor> _enabledProjects = config.getEnabledProjects();
        Consumer<ProjectDescriptor> _function = it -> this.createProject((ProjectDescriptor)it);
        _enabledProjects.forEach(_function);
    }

    public void createProject(ProjectDescriptor project) {
        String _location = project.getLocation();
        File projectRoot = new File(_location);
        projectRoot.mkdirs();
        Iterable<? extends AbstractFile> _files = project.getFiles();
        Consumer<AbstractFile> _function = it -> {
            try {
                boolean _isExecutable;
                Object _content;
                WizardConfiguration _config = project.getConfig();
                SourceLayout _sourceLayout = _config.getSourceLayout();
                Outlet _outlet = it.getOutlet();
                String _pathFor = _sourceLayout.getPathFor(_outlet);
                String _plus = _pathFor + "/";
                String _relativePath = it.getRelativePath();
                String projectRelativePath = _plus + _relativePath;
                File file = new File(projectRoot, projectRelativePath);
                File _parentFile = file.getParentFile();
                _parentFile.mkdirs();
                boolean _matched = false;
                if (it instanceof TextFile) {
                    _matched = true;
                    _content = ((TextFile)it).getContent();
                    String _newLine = Strings.newLine();
                    String normalizedContent = ((String)_content).replace(_newLine, this.lineDelimiter);
                    WizardConfiguration _config_1 = project.getConfig();
                    Charset _encoding = _config_1.getEncoding();
                    Files.write((CharSequence)normalizedContent, (File)file, (Charset)_encoding);
                }
                if (!_matched && it instanceof BinaryFile) {
                    _matched = true;
                    _content = ((BinaryFile)it).getContent();
                    byte[] _byteArray = Resources.toByteArray((URL)_content);
                    Files.write((byte[])_byteArray, (File)file);
                }
                if (_isExecutable = it.isExecutable()) {
                    file.setExecutable(true);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        _files.forEach(_function);
        Set<String> _sourceFolders = project.getSourceFolders();
        Consumer<String> _function_1 = it -> {
            File _file = new File(projectRoot, (String)it);
            _file.mkdirs();
        };
        _sourceFolders.forEach(_function_1);
    }

    @Pure
    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }
}

