/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.RawTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolvedExecutable
implements IResolvedExecutable {
    private final LightweightTypeReference contextType;
    private List<LightweightTypeReference> parameterTypes;
    private List<LightweightTypeReference> declaredExceptions;

    protected AbstractResolvedExecutable(LightweightTypeReference contextType) {
        this.contextType = contextType;
    }

    @Override
    public LightweightTypeReference getContextType() {
        return this.contextType;
    }

    @Override
    public LightweightTypeReference getResolvedDeclarator() {
        JvmExecutable declaration = this.getDeclaration();
        JvmDeclaredType declarator = declaration.getDeclaringType();
        return this.getContextType().getSuperType((JvmType)declarator);
    }

    @Override
    public List<JvmTypeParameter> getTypeParameters() {
        return Collections.unmodifiableList(this.getDeclaration().getTypeParameters());
    }

    @Override
    public List<LightweightTypeReference> getResolvedParameterTypes() {
        JvmExecutable declaration = this.getDeclaration();
        if (declaration.getParameters().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        EList parameters = declaration.getParameters();
        ArrayList unresolvedParameterTypes = Lists.newArrayListWithCapacity((int)parameters.size());
        for (JvmFormalParameter parameter : parameters) {
            unresolvedParameterTypes.add(parameter.getParameterType());
        }
        this.parameterTypes = this.getResolvedReferences(unresolvedParameterTypes);
        return this.parameterTypes;
    }

    @Override
    public String getResolvedErasureSignature() {
        JvmExecutable declaration = this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 20 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        int i = 0;
        while (i < parameterTypes.size()) {
            if (i != 0) {
                result.append(',');
            }
            result.append(parameterTypes.get(i).getRawTypeReference().getJavaIdentifier());
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public String getResolvedSignature() {
        JvmExecutable declaration = this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 30 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        int i = 0;
        while (i < parameterTypes.size()) {
            if (i != 0) {
                result.append(',');
            }
            result.append(parameterTypes.get(i).getJavaIdentifier());
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public String getSimpleSignature() {
        JvmExecutable declaration = this.getDeclaration();
        List<LightweightTypeReference> parameterTypes = this.getResolvedParameterTypes();
        StringBuilder result = new StringBuilder(declaration.getSimpleName().length() + 2 + 10 * parameterTypes.size());
        result.append(declaration.getSimpleName());
        result.append('(');
        int i = 0;
        while (i < parameterTypes.size()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(parameterTypes.get(i).getSimpleName());
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    protected LightweightTypeReference getResolvedReference(JvmTypeReference unresolved) {
        if (unresolved == null) {
            ITypeReferenceOwner owner = this.getContextType().getOwner();
            JvmType objectType = owner.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)owner.getContextResourceSet());
            return new ParameterizedTypeReference(owner, objectType);
        }
        OwnedConverter converter = new OwnedConverter(this.getContextType().getOwner());
        LightweightTypeReference unresolvedLightweight = converter.toLightweightReference(unresolved);
        if (unresolvedLightweight.isPrimitive() || unresolvedLightweight.isPrimitiveVoid()) {
            return unresolvedLightweight;
        }
        TypeParameterSubstitutor<?> substitutor = this.getSubstitutor();
        LightweightTypeReference result = substitutor.substitute(unresolvedLightweight);
        return result;
    }

    protected List<LightweightTypeReference> getResolvedReferences(List<JvmTypeReference> unresolved) {
        ArrayList result = Lists.newArrayListWithCapacity((int)unresolved.size());
        for (JvmTypeReference resolveMe : unresolved) {
            result.add(this.getResolvedReference(resolveMe));
        }
        return result;
    }

    @Override
    public List<LightweightTypeReference> getResolvedExceptions() {
        JvmExecutable declaration = this.getDeclaration();
        if (declaration.getExceptions().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.declaredExceptions != null) {
            return this.declaredExceptions;
        }
        this.declaredExceptions = this.getResolvedReferences((List<JvmTypeReference>)declaration.getExceptions());
        return this.declaredExceptions;
    }

    protected abstract Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getContextTypeParameterMapping();

    protected boolean isResolvedTypeParameter(JvmTypeParameter typeParameter) {
        return false;
    }

    protected TypeParameterSubstitutor<?> getSubstitutor() {
        if (this.getContextType().getType() != this.getDeclaration().getDeclaringType() && this.isRawTypeInheritance()) {
            return new RawTypeSubstitutor(this.getContextType().getOwner());
        }
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = this.getContextTypeParameterMapping();
        TypeParameterByConstraintSubstitutor result = new TypeParameterByConstraintSubstitutor(mapping, this.getContextType().getOwner()){

            protected boolean isDeclaredTypeParameter(JvmTypeParameter typeParameter) {
                return super.isDeclaredTypeParameter(typeParameter) || AbstractResolvedExecutable.this.isResolvedTypeParameter(typeParameter) || this.getTypeParameterMapping().containsKey(typeParameter);
            }

            protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter type, ConstraintVisitingInfo info) {
                LightweightMergedBoundTypeArgument result = super.getBoundTypeArgument(type, info);
                if (result != null && result.getTypeReference().getType() == type) {
                    return null;
                }
                return result;
            }
        };
        return result;
    }

    protected boolean isRawTypeInheritance() {
        List<LightweightTypeReference> superTypes = this.getContextType().getAllSuperTypes();
        JvmDeclaredType declaringType = this.getDeclaration().getDeclaringType();
        for (LightweightTypeReference superType : superTypes) {
            if (superType.getType() != declaringType || !superType.isRawType()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s in context of %s", this.getDeclaration().getIdentifier(), this.getContextType().getSimpleName());
    }
}

