/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractUnresolvableReference;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnresolvableReferenceWithNode
extends AbstractUnresolvableReference
implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
    private final String text;
    private final INode node;

    public AbstractUnresolvableReferenceWithNode(XExpression expression, INode node, String text, ExpressionTypeComputationState state) {
        super(expression, state);
        this.node = node;
        this.text = text;
    }

    @Override
    public void applyToModel() {
        Resource resource = this.getExpression().eResource();
        if (resource instanceof LazyLinkingResource) {
            LazyLinkingResource lazyLinkingResource = (LazyLinkingResource)resource;
            DiagnosticMessage message = lazyLinkingResource.getDiagnosticMessageProvider().getUnresolvedProxyMessage((ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext)this);
            if (message != null) {
                List<Resource.Diagnostic> diagnostics = this.getDiagnosticList(lazyLinkingResource, message);
                Resource.Diagnostic diagnostic = this.createDiagnostic(message);
                diagnostics.add(diagnostic);
            }
            InternalEObject referenced = (InternalEObject)this.getExpression().eGet((EStructuralFeature)this.getReference(), false);
            lazyLinkingResource.markUnresolvable((EObject)referenced);
        }
    }

    protected Resource.Diagnostic createDiagnostic(DiagnosticMessage message) {
        XtextLinkingDiagnostic diagnostic = new XtextLinkingDiagnostic(this.node, message.getMessage(), message.getIssueCode(), message.getIssueData());
        return diagnostic;
    }

    protected List<Resource.Diagnostic> getDiagnosticList(LazyLinkingResource resource, DiagnosticMessage message) throws AssertionError {
        if (message != null) {
            switch (message.getSeverity()) {
                case ERROR: {
                    return resource.getErrors();
                }
                case WARNING: {
                    return resource.getWarnings();
                }
            }
            throw new AssertionError((Object)("Unexpected severity: " + message.getSeverity()));
        }
        return Collections.emptyList();
    }

    protected INode getNode() {
        return this.node;
    }

    public String getLinkText() {
        return this.text;
    }
}

