/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.output.AppendableBasedTraceRegion;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAppendable
implements ITreeAppendable,
IAcceptor<String>,
CharSequence {
    private static final Logger log = Logger.getLogger(TreeAppendable.class);
    private List<Object> children;
    private final SharedAppendableState state;
    private final ILocationInFileProvider locationProvider;
    private final IJvmModelAssociations jvmModelAssociations;
    private final Set<ILocationData> locationData;
    private final ITraceURIConverter traceURIConverter;
    private boolean closed = false;
    private boolean useForDebugging = false;
    private LightweightTypeReferenceSerializer lightweightTypeReferenceSerializer;

    public TreeAppendable(ImportManager importManager, ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, EObject source, String indentation, String lineSeparator) {
        this(new SharedAppendableState(indentation, lineSeparator, importManager), converter, locationProvider, jvmModelAssociations, source);
    }

    protected TreeAppendable(SharedAppendableState state, ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, EObject source) {
        this(state, converter, locationProvider, jvmModelAssociations, TreeAppendable.createAllLocationData(converter, locationProvider, jvmModelAssociations, source, ILocationInFileProviderExtension.RegionDescription.INCLUDING_COMMENTS), false);
    }

    protected TreeAppendable(SharedAppendableState state, ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, Set<ILocationData> sourceLocations, boolean useForDebugging) {
        this.state = state;
        this.traceURIConverter = converter;
        this.locationProvider = locationProvider;
        this.jvmModelAssociations = jvmModelAssociations;
        this.children = Lists.newArrayList();
        this.locationData = sourceLocations;
        this.useForDebugging = useForDebugging;
        this.lightweightTypeReferenceSerializer = this.createLightweightTypeReferenceSerializer();
    }

    protected LightweightTypeReferenceSerializer createLightweightTypeReferenceSerializer() {
        return new LightweightTypeReferenceSerializer(this);
    }

    @Override
    public boolean isJava() {
        return true;
    }

    public ITraceURIConverter getTraceURIConverter() {
        return this.traceURIConverter;
    }

    @Override
    public ErrorTreeAppendable errorChild(EObject context) {
        ErrorTreeAppendable errorChild = new ErrorTreeAppendable(this.state, this.traceURIConverter, this.locationProvider, this.jvmModelAssociations, this.getLocationData(), this.useForDebugging, context);
        this.children.add(errorChild);
        return errorChild;
    }

    @Override
    public TreeAppendable trace(EObject object) {
        return this.trace(object, false);
    }

    @Override
    public TreeAppendable trace(EObject object, boolean useForDebugging) {
        return this.trace(object, ILocationInFileProviderExtension.RegionDescription.FULL, useForDebugging);
    }

    public TreeAppendable trace(EObject object, ILocationInFileProviderExtension.RegionDescription region, boolean useForDebugging) {
        Set<ILocationData> locationData = TreeAppendable.createAllLocationData(this.traceURIConverter, this.locationProvider, this.jvmModelAssociations, object, region);
        if (locationData.isEmpty()) {
            return this;
        }
        return this.trace(locationData, useForDebugging);
    }

    protected TreeAppendable trace(Set<ILocationData> newData, boolean useForDebugging) {
        if (this.useForDebugging == useForDebugging && newData.equals(this.locationData)) {
            return this;
        }
        TreeAppendable result = this.createChild(this.state, this.locationProvider, this.jvmModelAssociations, newData, useForDebugging);
        if (result != this) {
            this.children.add(result);
        }
        return result;
    }

    protected TreeAppendable createChild(SharedAppendableState state, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, Set<ILocationData> newData, boolean useForDebugging) {
        return new TreeAppendable(state, this.traceURIConverter, locationProvider, jvmModelAssociations, newData, useForDebugging);
    }

    @Override
    public ITreeAppendable trace(ILocationData location) {
        return this.trace(location, false);
    }

    @Override
    public ITreeAppendable trace(ILocationData location, boolean useForDebugging) {
        return this.trace(Collections.singleton(location), useForDebugging);
    }

    protected static ILocationData createLocationData(ITraceURIConverter converter, ILocationInFileProvider locationProvider, EObject object, ILocationInFileProviderExtension.RegionDescription query) {
        ITextRegion textRegion;
        ITextRegion iTextRegion = textRegion = locationProvider instanceof ILocationInFileProviderExtension ? ((ILocationInFileProviderExtension)locationProvider).getTextRegion(object, query) : locationProvider.getFullTextRegion(object);
        if (!(textRegion instanceof ITextRegionWithLineInformation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"location provider returned text region without line information.", (Throwable)new Exception());
            }
            if (textRegion != null) {
                textRegion = new TextRegionWithLineInformation(textRegion.getOffset(), textRegion.getLength(), 0, 0);
            } else {
                return null;
            }
        }
        ILocationData newData = TreeAppendable.createLocationData(converter, object, (ITextRegionWithLineInformation)textRegion);
        return newData;
    }

    protected static Set<ILocationData> createAllLocationData(ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, EObject object, ILocationInFileProviderExtension.RegionDescription query) {
        Set<EObject> sourceElements = jvmModelAssociations.getSourceElements(object);
        Set<Object> result = Collections.emptySet();
        if (sourceElements.isEmpty()) {
            ILocationData locationData = TreeAppendable.createLocationData(converter, locationProvider, object, query);
            if (locationData != null) {
                result = Collections.singleton(locationData);
            }
        } else {
            result = Sets.newHashSet();
            for (EObject sourceElement : sourceElements) {
                ILocationData locationData = TreeAppendable.createLocationData(converter, locationProvider, sourceElement, query);
                if (locationData == null) continue;
                result.add(locationData);
            }
        }
        return result;
    }

    @Override
    public ITreeAppendable trace(Iterable<? extends EObject> objects) {
        if (Iterables.isEmpty(objects)) {
            throw new IllegalArgumentException("List of objects may not be empty");
        }
        int size = Iterables.size(objects);
        if (size == 1) {
            return this.trace(objects.iterator().next(), false);
        }
        LinkedHashSet<ILocationData> newData = new LinkedHashSet<ILocationData>(size);
        for (EObject eObject : objects) {
            ILocationData locationData = TreeAppendable.createLocationData(this.traceURIConverter, this.locationProvider, eObject, ILocationInFileProviderExtension.RegionDescription.FULL);
            if (locationData == null) continue;
            newData.add(locationData);
        }
        if (newData.isEmpty() && !this.isUseForDebugging()) {
            return this;
        }
        return this.trace(newData, false);
    }

    @Override
    public ITreeAppendable trace(EObject object, EStructuralFeature feature, int indexInList) {
        ITextRegion textRegion = this.locationProvider.getFullTextRegion(object, feature, indexInList);
        if (!(textRegion instanceof ITextRegionWithLineInformation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"location provider returned text region without line information. Synthesized dummy data.", (Throwable)new Exception());
            }
            textRegion = new TextRegionWithLineInformation(textRegion.getOffset(), textRegion.getLength(), 0, 0);
        }
        ILocationData newData = TreeAppendable.createLocationData(this.traceURIConverter, object, (ITextRegionWithLineInformation)textRegion);
        return this.trace(Collections.singleton(newData), false);
    }

    protected static ILocationData createLocationData(ITraceURIConverter converter, EObject object, ITextRegionWithLineInformation textRegion) {
        URI uri = null;
        if (object.eResource() instanceof XtextResource) {
            uri = converter.getURIForTrace((XtextResource)object.eResource());
        }
        LocationData newData = new LocationData(textRegion, uri);
        return newData;
    }

    public TreeAppendable acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }

    public Set<ILocationData> getLocationData() {
        return this.locationData;
    }

    public List<? extends Object> getChildren() {
        return this.children;
    }

    public void accept(String text) {
        this.children.add(text);
    }

    protected void markClosed() {
        if (this.closed) {
            return;
        }
        this.closeLastChild();
        this.closed = true;
    }

    protected void closeLastChild() {
        Object lastChild;
        if (this.closed) {
            throw new IllegalStateException("TreeAppendable was already closed");
        }
        if (!this.children.isEmpty() && (lastChild = this.children.get(this.children.size() - 1)) instanceof TreeAppendable) {
            ((TreeAppendable)lastChild).markClosed();
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public TreeAppendable append(JvmType type) {
        this.closeLastChild();
        this.state.appendType(type, (IAcceptor<String>)this);
        return this;
    }

    @Override
    public ITreeAppendable append(Class<?> type) {
        this.closeLastChild();
        this.state.appendType(type, (IAcceptor<String>)this);
        return this;
    }

    @Override
    public TreeAppendable append(LightweightTypeReference typeRef) {
        typeRef.accept(this.lightweightTypeReferenceSerializer);
        return this;
    }

    protected ITreeAppendable appendTreeAppendable(ITreeAppendable other) {
        this.closeLastChild();
        if (!(other instanceof TreeAppendable)) {
            throw new IllegalArgumentException("Unexpected implementation");
        }
        ((TreeAppendable)other).markClosed();
        this.children.add(other);
        return this;
    }

    @Override
    public ITreeAppendable append(CharSequence content) {
        if (content instanceof ITreeAppendable) {
            return this.appendTreeAppendable((ITreeAppendable)((Object)content));
        }
        this.closeLastChild();
        this.appendIndented(content.toString());
        return this;
    }

    public TreeAppendable appendUnsafe(String string) {
        this.accept(string);
        return this;
    }

    @Override
    public TreeAppendable newLine() {
        this.closeLastChild();
        this.state.appendNewLineAndIndentation(this);
        return this;
    }

    @Override
    public TreeAppendable increaseIndentation() {
        this.closeLastChild();
        this.state.increaseIndentation();
        return this;
    }

    @Override
    public TreeAppendable decreaseIndentation() {
        this.closeLastChild();
        this.state.decreaseIndentation();
        return this;
    }

    @Override
    @Deprecated
    public List<String> getImports() {
        return this.state.getImports();
    }

    @Override
    public void openScope() {
        this.state.openScope();
    }

    @Override
    public void openPseudoScope() {
        this.state.openPseudoScope();
    }

    @Override
    public String declareVariable(Object key, String proposedName) {
        return this.state.declareVariable(key, proposedName);
    }

    @Override
    public String declareSyntheticVariable(Object key, String proposedName) {
        return this.state.declareSyntheticVariable(key, proposedName);
    }

    @Override
    public String getName(Object key) {
        return this.state.getName(key);
    }

    @Override
    public boolean hasName(Object key) {
        return this.state.hasName(key);
    }

    @Override
    public Object getObject(String name) {
        return this.state.getObject(name);
    }

    @Override
    public boolean hasObject(String name) {
        return this.state.hasObject(name);
    }

    @Override
    public void closeScope() {
        this.state.closeScope();
    }

    @Override
    public String getContent() {
        StringBuilder result = new StringBuilder(8192);
        this.doGetContent(result);
        return result.toString();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    protected void doGetContent(StringBuilder result) {
        for (Object child : this.children) {
            if (child instanceof String) {
                result.append(child);
                continue;
            }
            ((TreeAppendable)child).doGetContent(result);
        }
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    public AbstractTraceRegion getTraceRegion() {
        if (this.locationData == null) {
            throw new IllegalStateException("tree appendable was used without tracing");
        }
        return new AppendableBasedTraceRegion(null, this, 0, 0);
    }

    protected void appendIndented(String text) {
        int length = text.length();
        int nextLineOffset = 0;
        int idx = 0;
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                this.state.appendNewLineAndIndentation(this);
                nextLineOffset = idx + 1;
            } else if (currentChar == '\n') {
                int lineLength = idx - nextLineOffset;
                this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                this.state.appendNewLineAndIndentation(this);
                nextLineOffset = idx + 1;
            }
            ++idx;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
        }
    }

    public boolean isUseForDebugging() {
        if (this.useForDebugging) {
            for (Object c : this.children) {
                if (c instanceof ITreeAppendable) continue;
                return true;
            }
        }
        return false;
    }

    public SharedAppendableState getState() {
        return this.state;
    }

    ImportManager getImportManager() {
        return this.state.getImportManager();
    }

    String getLineSeparator() {
        return this.state.getLineSeparator();
    }

    String getIndentationString() {
        return this.state.getIndentationString();
    }

    public void dump() {
        this.dump("");
        System.out.println();
    }

    protected void dump(String indent) {
        if (this.closed) {
            System.out.println(String.valueOf(indent) + "<closed>");
        }
        StringBuilder currentChildren = null;
        for (Object child : this.children) {
            if (child instanceof TreeAppendable) {
                if (currentChildren != null) {
                    System.out.println(String.valueOf(indent) + currentChildren.toString());
                }
                currentChildren = null;
                ((TreeAppendable)child).dump("  " + indent);
                continue;
            }
            if (currentChildren == null) {
                currentChildren = new StringBuilder();
            }
            currentChildren.append(child.toString().replace(this.state.getLineSeparator(), "\\n"));
        }
        if (currentChildren != null) {
            System.out.println(String.valueOf(indent) + currentChildren.toString());
        }
        if (this.closed) {
            System.out.println(String.valueOf(indent) + "</closed>");
        }
    }

    public static abstract class Visitor {
        protected TreeAppendable visit(TreeAppendable original) {
            this.visitChildren(original);
            return original;
        }

        protected void visitChildren(TreeAppendable parent) {
            int i = 0;
            while (i < parent.children.size()) {
                Object o = parent.children.get(i);
                if (o instanceof String) {
                    parent.children.set(i, this.visit((String)o));
                } else {
                    parent.children.set(i, this.visit((TreeAppendable)o));
                }
                ++i;
            }
        }

        protected String visit(String string) {
            return string;
        }
    }
}

