/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.AbstractConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.interpreter.UnresolvableFeatureException;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;

public class SwitchConstantExpressionsInterpreter
extends AbstractConstantExpressionsInterpreter {
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;

    public Object evaluate(XExpression it) {
        return this.internalEvaluate(it, null);
    }

    protected Object _internalEvaluate(XNumberLiteral it, Context ctx) {
        return this.numberLiterals.numberValue(it, Integer.class);
    }

    protected Object _internalEvaluate(XAbstractFeatureCall it, Context ctx) {
        JvmIdentifiableElement _feature;
        JvmIdentifiableElement feature = _feature = it.getFeature();
        boolean _matched = false;
        if (!_matched && feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            return feature;
        }
        if (!_matched && feature instanceof JvmField) {
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                return ((JvmField)feature).getConstantValue();
            }
            XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression(feature);
            return this.internalEvaluate(_associatedExpression, ctx);
        }
        if (!_matched && feature instanceof XVariableDeclaration) {
            _matched = true;
            XExpression _right = ((XVariableDeclaration)feature).getRight();
            return this.internalEvaluate(_right, ctx);
        }
        JvmIdentifiableElement _feature_1 = it.getFeature();
        String _simpleName = _feature_1.getSimpleName();
        String _plus = "Couldn't resolve feature " + _simpleName;
        throw new UnresolvableFeatureException(_plus, it);
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XAbstractFeatureCall) {
            return this._internalEvaluate((XAbstractFeatureCall)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }
}

