/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.file;

import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;

public abstract class AbstractFileSystemSupport
implements MutableFileSystemSupport {
    @Inject
    private IEncodingProvider _encodingProvider;

    public IEncodingProvider getEncodingProvider() {
        return this._encodingProvider;
    }

    public void setEncodingProvider(IEncodingProvider encodingProvider) {
        this._encodingProvider = encodingProvider;
    }

    public CharSequence getContents(final Path path) {
        try {
            InputSupplier<InputStreamReader> _function = new InputSupplier<InputStreamReader>(){

                public InputStreamReader getInput() throws IOException {
                    InputStream _contentsAsStream = AbstractFileSystemSupport.this.getContentsAsStream(path);
                    String _charset = AbstractFileSystemSupport.this.getCharset(path);
                    InputStreamReader _inputStreamReader = new InputStreamReader(_contentsAsStream, _charset);
                    return _inputStreamReader;
                }
            };
            return CharStreams.toString((InputSupplier)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setContents(Path path, CharSequence contents) {
        try {
            Path _parent = path.getParent();
            this.mkdir(_parent);
            String _string = contents.toString();
            String _charset = this.getCharset(path);
            StringInputStream _stringInputStream = new StringInputStream(_string, _charset);
            this.setContentsAsStream(path, (InputStream)_stringInputStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public abstract Path getPath(Resource var1);
}

