/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.jvmmodel.JvmIdentifiableMetaData;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;
import org.eclipse.xtext.xtype.XComputedTypeReference;

@FinalFieldsConstructor
public class BatchLinkableResourceStorageWritable
extends ResourceStorageWritable {
    private static final Logger LOG = Logger.getLogger(BatchLinkableResourceStorageWritable.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntries(StorageAwareResource resource, ZipOutputStream zipOut) throws IOException {
        super.writeEntries(resource, zipOut);
        if (resource instanceof BatchLinkableResource) {
            ZipEntry _zipEntry = new ZipEntry("associations");
            zipOut.putNextEntry(_zipEntry);
            BufferedOutputStream buffOut = new BufferedOutputStream(zipOut);
            try {
                this.writeAssociationsAdapter((BatchLinkableResource)resource, buffOut);
            }
            finally {
                buffOut.flush();
                zipOut.closeEntry();
            }
        }
    }

    protected Object beforeSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream writable) throws IOException {
        JvmType _xblockexpression = null;
        super.beforeSaveEObject(object, writable);
        JvmType _xifexpression = null;
        if (object instanceof XComputedTypeReference) {
            _xifexpression = ((XComputedTypeReference)object).getType();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void handleSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream out) throws IOException {
        boolean _notEquals;
        super.handleSaveEObject(object, out);
        DocumentationAdapter documentationAdapter = null;
        JvmIdentifiableMetaData metaDataAdapter = null;
        EList _eAdapters = object.eAdapters();
        for (Adapter adapter : _eAdapters) {
            if (adapter instanceof DocumentationAdapter) {
                documentationAdapter = (DocumentationAdapter)adapter;
            }
            if (!(adapter instanceof JvmIdentifiableMetaData)) continue;
            metaDataAdapter = (JvmIdentifiableMetaData)adapter;
        }
        boolean bl = _notEquals = !Objects.equal(documentationAdapter, null);
        if (_notEquals) {
            out.writeBoolean(true);
            String _documentation = documentationAdapter.getDocumentation();
            out.writeString(_documentation);
        } else {
            out.writeBoolean(false);
        }
        if (metaDataAdapter != null) {
            out.writeBoolean(true);
            boolean _isSynthetic = metaDataAdapter.isSynthetic();
            out.writeBoolean(_isSynthetic);
        } else {
            out.writeBoolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAssociationsAdapter(BatchLinkableResource resource, OutputStream zipOut) throws IOException {
        EList _eAdapters = resource.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, JvmModelAssociator.Adapter.class);
        JvmModelAssociator.Adapter adapter = (JvmModelAssociator.Adapter)((Object)IterableExtensions.head((Iterable)_filter));
        if (adapter == null) {
            JvmModelAssociator.Adapter _adapter;
            Functions.Function1 _function;
            EList<EObject> _contents = resource.getContents();
            Iterable _tail = IterableExtensions.tail(_contents);
            boolean _exists = IterableExtensions.exists((Iterable)_tail, (Functions.Function1)(_function = it -> it instanceof JvmType));
            if (_exists) {
                URI _uRI = resource.getURI();
                String _plus = "Missing JvmModelAssociator.Adapter but resource contains inferred types: " + _uRI;
                throw new IOException(_plus);
            }
            adapter = _adapter = new JvmModelAssociator.Adapter();
        }
        ObjectOutputStream objOut = new ObjectOutputStream(zipOut);
        try {
            LinkedHashMap logicalMap = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
            Set<Map.Entry<EObject, JvmIdentifiableElement>> _entrySet = adapter.logicalContainerMap.entrySet();
            for (Map.Entry<EObject, JvmIdentifiableElement> entry : _entrySet) {
                boolean _notEquals;
                EObject _key = entry.getKey();
                Resource resource2 = _key.eResource();
                boolean bl = _notEquals = !Objects.equal((Object)resource2, (Object)((Object)resource));
                if (_notEquals) {
                    URI _uRI_1 = resource.getURI();
                    String _plus_1 = "entry " + entry + " not from resource " + _uRI_1;
                    String _plus_2 = _plus_1 + " but from ";
                    EObject _key_1 = entry.getKey();
                    Resource _eResource_1 = _key_1.eResource();
                    URI _uRI_2 = null;
                    if (_eResource_1 != null) {
                        _uRI_2 = _eResource_1.getURI();
                    }
                    String _plus_3 = _plus_2 + _uRI_2;
                    LOG.info((Object)_plus_3);
                    continue;
                }
                EObject _key_2 = entry.getKey();
                String _fragment = this.getFragment(_key_2);
                JvmIdentifiableElement _value = entry.getValue();
                String _fragment_1 = this.getFragment((EObject)_value);
                logicalMap.put(_fragment, _fragment_1);
            }
            objOut.writeObject(logicalMap);
            LinkedHashMap sourceToTarget = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
            Set<Map.Entry<EObject, Set<EObject>>> _entrySet_1 = adapter.sourceToTargetMap.entrySet();
            for (Map.Entry entry : _entrySet_1) {
                boolean _notEquals_1;
                EObject _key_3 = (EObject)entry.getKey();
                Resource _eResource_2 = _key_3.eResource();
                boolean bl = _notEquals_1 = !Objects.equal((Object)_eResource_2, (Object)((Object)resource));
                if (_notEquals_1) {
                    URI _uRI_3 = resource.getURI();
                    String _plus_4 = "entry not from resource " + _uRI_3;
                    String _plus_5 = _plus_4 + " but from ";
                    EObject _key_4 = (EObject)entry.getKey();
                    Resource _eResource_3 = _key_4.eResource();
                    URI _uRI_4 = null;
                    if (_eResource_3 != null) {
                        _uRI_4 = _eResource_3.getURI();
                    }
                    String _plus_6 = _plus_5 + _uRI_4;
                    LOG.info((Object)_plus_6);
                    continue;
                }
                EObject _key_5 = (EObject)entry.getKey();
                String _fragment_2 = this.getFragment(_key_5);
                Set _value_1 = (Set)entry.getValue();
                Functions.Function1 _function_1 = it -> this.getFragment((EObject)it);
                Iterable _map = IterableExtensions.map((Iterable)_value_1, (Functions.Function1)_function_1);
                LinkedHashSet _newLinkedHashSet = Sets.newLinkedHashSet((Iterable)_map);
                sourceToTarget.put(_fragment_2, _newLinkedHashSet);
            }
            objOut.writeObject(sourceToTarget);
            LinkedHashMap targetToSource = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
            Set<Map.Entry<EObject, Set<EObject>>> set = adapter.targetToSourceMap.entrySet();
            for (Map.Entry<EObject, Set<EObject>> entry_2 : set) {
                boolean _notEquals_2;
                EObject _key_6 = entry_2.getKey();
                Resource _eResource_4 = _key_6.eResource();
                boolean bl = _notEquals_2 = !Objects.equal((Object)_eResource_4, (Object)((Object)resource));
                if (_notEquals_2) {
                    URI _uRI_5 = resource.getURI();
                    String _plus_7 = "entry not from resource " + _uRI_5;
                    String _plus_8 = _plus_7 + " but from ";
                    EObject _key_7 = entry_2.getKey();
                    Resource _eResource_5 = _key_7.eResource();
                    URI _uRI_6 = null;
                    if (_eResource_5 != null) {
                        _uRI_6 = _eResource_5.getURI();
                    }
                    String _plus_9 = _plus_8 + _uRI_6;
                    LOG.info((Object)_plus_9);
                    continue;
                }
                EObject _key_8 = entry_2.getKey();
                String _fragment_3 = this.getFragment(_key_8);
                Set<EObject> _value_2 = entry_2.getValue();
                Functions.Function1 _function_2 = it -> this.getFragment((EObject)it);
                Iterable _map_1 = IterableExtensions.map(_value_2, (Functions.Function1)_function_2);
                LinkedHashSet _newLinkedHashSet_1 = Sets.newLinkedHashSet((Iterable)_map_1);
                targetToSource.put(_fragment_3, _newLinkedHashSet_1);
            }
            objOut.writeObject(targetToSource);
        }
        finally {
            objOut.flush();
        }
    }

    protected String getFragment(EObject obj) {
        String _xblockexpression = null;
        if (Objects.equal((Object)obj, null) || obj.eIsProxy() || obj.eResource() == null) {
            return "none";
        }
        Resource _eResource = obj.eResource();
        _xblockexpression = _eResource.getURIFragment(obj);
        return _xblockexpression;
    }

    public BatchLinkableResourceStorageWritable(OutputStream out, boolean storeNodeModel) {
        super(out, storeNodeModel);
    }
}

