/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.formatting2.ArrayBracketsFormattingReplacer;
import org.eclipse.xtext.xbase.formatting2.IndentOnceAutowrapFormatter;
import org.eclipse.xtext.xbase.formatting2.ObjectEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorRegions;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.formatting2.XtypeFormatter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseFormatter
extends XtypeFormatter {
    @Inject
    @Extension
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XbaseGrammarAccess grammar;

    protected void _format(XCollectionLiteral literal, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)literal);
        ISemanticRegion _keyword = _regionFor.keyword("#");
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(_keyword, _function);
        ISemanticRegion _elvis = null;
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)literal);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("[");
        if (_keyword_1 != null) {
            _elvis = _keyword_1;
        } else {
            ISemanticRegion _keyword_2;
            ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)literal);
            _elvis = _keyword_2 = _regionFor_2.keyword("{");
        }
        ISemanticRegion open = _elvis;
        ISemanticRegion _elvis_1 = null;
        ISemanticRegionsFinder _regionFor_3 = this.textRegionExtensions.regionFor((EObject)literal);
        ISemanticRegion _keyword_3 = _regionFor_3.keyword("]");
        if (_keyword_3 != null) {
            _elvis_1 = _keyword_3;
        } else {
            ISemanticRegion _keyword_4;
            ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor((EObject)literal);
            _elvis_1 = _keyword_4 = _regionFor_4.keyword("}");
        }
        ISemanticRegion close = _elvis_1;
        EList<XExpression> _elements = literal.getElements();
        this.formatCommaSeparatedList((Collection<? extends EObject>)_elements, open, close, document);
    }

    protected void formatCommaSeparatedList(Collection<? extends EObject> elements, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        if (close != null && open != null) {
            boolean _isEmpty = elements.isEmpty();
            if (_isEmpty) {
                Procedures.Procedure1 _function = it -> it.noSpace();
                format.append(open, _function);
            } else {
                IHiddenRegion _previousHiddenRegion = close.getPreviousHiddenRegion();
                boolean _isMultiline = _previousHiddenRegion.isMultiline();
                if (_isMultiline) {
                    Procedures.Procedure1 _function_1 = it -> it.newLine();
                    format.append(open, _function_1);
                    for (EObject eObject : elements) {
                        format.format((Object)eObject);
                        ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing(eObject);
                        ISemanticRegion _keyword = _immediatelyFollowing.keyword(",");
                        Procedures.Procedure1 _function_2 = it -> it.noSpace();
                        ISemanticRegion _prepend = format.prepend(_keyword, _function_2);
                        Procedures.Procedure1 _function_3 = it -> it.newLine();
                        format.append(_prepend, _function_3);
                    }
                    EObject _last = (EObject)IterableExtensions.last(elements);
                    Procedures.Procedure1 procedure1 = it -> it.newLine();
                    format.append(_last, procedure1);
                    Procedures.Procedure1 _function_3 = it -> it.indent();
                    format.interior(open, close, _function_3);
                } else {
                    IHiddenRegion _previousHiddenRegion_1 = close.getPreviousHiddenRegion();
                    IndentOnceAutowrapFormatter indent = new IndentOnceAutowrapFormatter(_previousHiddenRegion_1);
                    ITextRegionAccess iTextRegionAccess = this.getTextRegionAccess();
                    int _endOffset = open.getEndOffset();
                    int _offset = close.getOffset();
                    int _endOffset_1 = open.getEndOffset();
                    int _minus = _offset - _endOffset_1;
                    TextSegment region = new TextSegment(iTextRegionAccess, _endOffset, _minus);
                    SeparatorRegions<EObject, ISemanticRegion> items = new SeparatorRegions<EObject, ISemanticRegion>((ITextSegment)region);
                    for (EObject eObject : elements) {
                        ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing(eObject);
                        ISemanticRegion _keyword = _immediatelyFollowing.keyword(",");
                        items.appendWithTrailingSeparator(eObject, _keyword);
                    }
                    for (ObjectEntry objectEntry : items) {
                        SeparatorEntry _leadingSeparator = objectEntry.getLeadingSeparator();
                        ISemanticRegion _separator = null;
                        if (_leadingSeparator != null) {
                            _separator = (ISemanticRegion)_leadingSeparator.getSeparator();
                        }
                        ISemanticRegion sep = _separator;
                        EObject _object = (EObject)objectEntry.getObject();
                        boolean _prependNewLineIfMultiline = this.prependNewLineIfMultiline(_object);
                        if (_prependNewLineIfMultiline) {
                            if (sep == null) {
                                Procedures.Procedure1 _function_4 = it -> {
                                    it.noSpace();
                                    ITextSegment _region = ele_1.getRegion();
                                    int _length = _region.getLength();
                                    it.autowrap(_length);
                                    it.setOnAutowrap((IAutowrapFormatter)indent);
                                };
                                format.append(open, _function_4);
                            } else {
                                Procedures.Procedure1 _function_5 = it -> {
                                    it.oneSpace();
                                    ITextSegment _region = ele_1.getRegion();
                                    int _length = _region.getLength();
                                    it.autowrap(_length);
                                    it.setOnAutowrap((IAutowrapFormatter)indent);
                                };
                                format.append(sep, _function_5);
                            }
                        } else {
                            Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                            format.append(sep, _function_6);
                        }
                        Procedures.Procedure1 _function_7 = it -> it.noSpace();
                        format.prepend(sep, _function_7);
                        EObject _object_1 = (EObject)objectEntry.getObject();
                        format.format((Object)_object_1);
                    }
                    Procedures.Procedure1 _function_4 = it -> it.noSpace();
                    format.prepend(close, _function_4);
                }
            }
        }
    }

    protected void _format(JvmGenericArrayTypeReference array, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)array);
        ParserRule _arrayBracketsRule = this.grammar.getArrayBracketsRule();
        ISemanticRegion _ruleCallTo = _regionFor.ruleCallTo((AbstractRule)_arrayBracketsRule);
        ArrayBracketsFormattingReplacer _arrayBracketsFormattingReplacer = new ArrayBracketsFormattingReplacer(_ruleCallTo);
        document.addReplacer((ITextReplacer)_arrayBracketsFormattingReplacer);
        JvmTypeReference _componentType = array.getComponentType();
        document.format((Object)_componentType);
    }

    protected void _format(JvmTypeConstraint constraint, @Extension IFormattableDocument document) {
        JvmTypeReference _typeReference = constraint.getTypeReference();
        Procedures.Procedure1 _function = it -> it.oneSpace();
        JvmTypeReference _prepend = (JvmTypeReference)document.prepend((EObject)_typeReference, _function);
        document.format((Object)_prepend);
    }

    protected void _format(XVariableDeclaration expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("val");
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(_keyword, _function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("var");
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        format.append(_keyword_1, _function_1);
        JvmTypeReference _type = expr.getType();
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        format.append((EObject)_type, _function_2);
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_2.keyword("=");
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        format.surround(_keyword_2, _function_3);
        JvmTypeReference _type_1 = expr.getType();
        format.format((Object)_type_1);
        XExpression _right = expr.getRight();
        format.format((Object)_right);
    }

    protected void _format(XAssignment expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ParserRule _opSingleAssignRule = this.grammar.getOpSingleAssignRule();
        ISemanticRegion _ruleCallTo = _regionFor.ruleCallTo((AbstractRule)_opSingleAssignRule);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.surround(_ruleCallTo, _function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        String _xifexpression = null;
        boolean _isExplicitStatic = expr.isExplicitStatic();
        _xifexpression = _isExplicitStatic ? "::" : ".";
        ISemanticRegion _keyword = _regionFor_1.keyword(_xifexpression);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround(_keyword, _function_1);
        XExpression _assignable = expr.getAssignable();
        format.format((Object)_assignable);
        XExpression _value = expr.getValue();
        format.format((Object)_value);
    }

    protected void formatFeatureCallParams(List<XExpression> params, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        XClosure builder = this.builder(params);
        Iterable<XExpression> explicitParams = this.explicitParams(params);
        List _list = IterableExtensions.toList(explicitParams);
        this.formatCommaSeparatedList(_list, open, close, format);
        this.formatBuilderWithLeadingGap(builder, format);
    }

    protected void formatBuilderWithLeadingGap(XClosure closure, @Extension IFormattableDocument format) {
        if (closure != null) {
            IHiddenRegion _previousHiddenRegion = this.textRegionExtensions.previousHiddenRegion((EObject)closure);
            int offset = _previousHiddenRegion.getOffset();
            IHiddenRegion _nextHiddenRegion = this.textRegionExtensions.nextHiddenRegion((EObject)closure);
            int _offset = _nextHiddenRegion.getOffset();
            int length = _offset - offset;
            ISubFormatter _function = doc -> {
                IFormattableSubDocument it = doc.requireFitsInLine();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
                it.prepend((EObject)closure, _function_1);
                it.format((Object)closure);
            };
            ISubFormatter _function_1 = it -> {
                Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
                it.prepend((EObject)closure, _function_2);
                it.format((Object)closure);
            };
            format.formatConditionally(offset, length, new ISubFormatter[]{_function, _function_1});
        }
    }

    protected XClosure builder(List<XExpression> params) {
        boolean _tripleNotEquals;
        XClosure _xifexpression = null;
        XExpression _last = (XExpression)IterableExtensions.last(params);
        boolean bl = _tripleNotEquals = _last != null;
        if (_tripleNotEquals) {
            XClosure _xblockexpression = null;
            XExpression _last_1 = (XExpression)IterableExtensions.last(params);
            EObject grammarElement = this.textRegionExtensions.grammarElement((EObject)_last_1);
            XClosure _xifexpression_1 = null;
            if (Objects.equal((Object)grammarElement, (Object)this.grammar.getXMemberFeatureCallAccess().getMemberCallArgumentsXClosureParserRuleCall_1_1_4_0()) || Objects.equal((Object)grammarElement, (Object)this.grammar.getXFeatureCallAccess().getFeatureCallArgumentsXClosureParserRuleCall_4_0()) || Objects.equal((Object)grammarElement, (Object)this.grammar.getXConstructorCallAccess().getArgumentsXClosureParserRuleCall_5_0())) {
                XExpression _last_2 = (XExpression)IterableExtensions.last(params);
                _xifexpression_1 = (XClosure)_last_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected Iterable<XExpression> explicitParams(List<XExpression> params) {
        List<XExpression> _xblockexpression = null;
        XClosure builder = this.builder(params);
        Iterable<XExpression> _xifexpression = null;
        if (builder != null) {
            int _size = params.size();
            int _minus = _size - 1;
            _xifexpression = IterableExtensions.take(params, (int)_minus);
        } else {
            _xifexpression = params;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void _format(XConstructorCall expr, @Extension IFormattableDocument format) {
        boolean _not;
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _feature = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend(_feature, _function);
        EList<JvmTypeReference> _typeArguments = expr.getTypeArguments();
        boolean _isEmpty = _typeArguments.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword = _regionFor_1.keyword("<");
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            format.surround(_keyword, _function_1);
            EList<JvmTypeReference> _typeArguments_1 = expr.getTypeArguments();
            for (JvmTypeReference arg : _typeArguments_1) {
                format.format((Object)arg);
                ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)arg);
                ISemanticRegion _keyword_1 = _immediatelyFollowing.keyword(",");
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                ISemanticRegion _prepend = format.prepend(_keyword_1, _function_2);
                Procedures.Procedure1 _function_3 = it -> it.oneSpace();
                format.append(_prepend, _function_3);
            }
            ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword_1 = _regionFor_2.keyword(">");
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            format.prepend(_keyword_1, _function_2);
        }
        ISemanticRegionsFinder _regionFor_3 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion open = _regionFor_3.keyword("(");
        ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion close = _regionFor_4.keyword(")");
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        format.prepend(open, _function_3);
        EList<XExpression> _arguments = expr.getArguments();
        this.formatFeatureCallParams((List<XExpression>)_arguments, open, close, format);
    }

    protected void formatFeatureCallTypeParameters(XAbstractFeatureCall expr, @Extension IFormattableDocument format) {
        boolean _not;
        EList<JvmTypeReference> _typeArguments = expr.getTypeArguments();
        boolean _isEmpty = _typeArguments.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword = _regionFor.keyword("<");
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.append(_keyword, _function);
            EList<JvmTypeReference> _typeArguments_1 = expr.getTypeArguments();
            for (JvmTypeReference arg : _typeArguments_1) {
                format.format((Object)arg);
                ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)arg);
                ISemanticRegion _keyword_1 = _immediatelyFollowing.keyword(",");
                Procedures.Procedure1 _function_1 = it -> it.noSpace();
                ISemanticRegion _prepend = format.prepend(_keyword_1, _function_1);
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                format.append(_prepend, _function_2);
            }
            ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword_1 = _regionFor_1.keyword(">");
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            format.surround(_keyword_1, _function_1);
        }
    }

    protected void _format(XFeatureCall expr, @Extension IFormattableDocument format) {
        this.formatFeatureCallTypeParameters(expr, format);
        boolean _isExplicitOperationCall = expr.isExplicitOperationCall();
        if (_isExplicitOperationCall) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword = _regionFor.keyword("(");
            Procedures.Procedure1 _function = it -> it.noSpace();
            ISemanticRegion open = format.prepend(_keyword, _function);
            ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion close = _regionFor_1.keyword(")");
            EList<XExpression> _featureCallArguments = expr.getFeatureCallArguments();
            this.formatFeatureCallParams((List<XExpression>)_featureCallArguments, open, close, format);
        } else {
            EList<XExpression> _featureCallArguments_1 = expr.getFeatureCallArguments();
            for (XExpression arg : _featureCallArguments_1) {
                this.format(arg, format);
            }
        }
    }

    protected void _format(XMemberFeatureCall expr, @Extension IFormattableDocument format) {
        XExpression top = expr;
        IEObjectRegion _regionForEObject = this.textRegionExtensions.regionForEObject((EObject)expr);
        SeparatorRegions<XMemberFeatureCall, ISemanticRegion> calls = new SeparatorRegions<XMemberFeatureCall, ISemanticRegion>((ITextSegment)_regionForEObject);
        while (top instanceof XMemberFeatureCall) {
            boolean _isExplicitStatic;
            String _switchResult = null;
            XMemberFeatureCall it2 = top;
            boolean _matched = false;
            boolean _isNullSafe = it2.isNullSafe();
            if (_isNullSafe) {
                _matched = true;
                _switchResult = "?.";
            }
            if (!_matched && (_isExplicitStatic = it2.isExplicitStatic())) {
                _matched = true;
                _switchResult = "::";
            }
            if (!_matched) {
                _switchResult = ".";
            }
            String op = _switchResult;
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)top);
            ISemanticRegion separator = _regionFor.keyword(op);
            calls.prependWithLeadingSeparator((XMemberFeatureCall)top, separator);
            XExpression _memberCallTarget = top.getMemberCallTarget();
            top = _memberCallTarget;
        }
        format.format((Object)top);
        IHiddenRegion _nextHiddenRegion = this.textRegionExtensions.nextHiddenRegion((EObject)expr);
        IndentOnceAutowrapFormatter indentOnce = new IndentOnceAutowrapFormatter(_nextHiddenRegion);
        for (ObjectEntry entry : calls) {
            XMemberFeatureCall call = (XMemberFeatureCall)entry.getObject();
            SeparatorEntry _leadingSeparator = entry.getLeadingSeparator();
            ISemanticRegion operator = (ISemanticRegion)_leadingSeparator.getSeparator();
            this.formatFeatureCallTypeParameters(call, format);
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)call);
            ISemanticRegion feature = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
            if (feature == null) continue;
            ITextSegment _region = entry.getRegion();
            int _length = _region.getLength();
            int _length_1 = feature.getLength();
            int _multiply = _length_1 * 2;
            int autowrapLength = Math.min(_length, _multiply);
            Procedures.Procedure1 _function = it -> it.noSpace();
            ISemanticRegion _prepend = format.prepend(operator, _function);
            Procedures.Procedure1 _function_1 = it -> {
                it.noSpace();
                it.autowrap(autowrapLength);
                it.setOnAutowrap((IAutowrapFormatter)indentOnce);
            };
            format.append(_prepend, _function_1);
            boolean _isExplicitOperationCall = call.isExplicitOperationCall();
            if (_isExplicitOperationCall) {
                ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)call);
                ISemanticRegion _keyword = _regionFor_1.keyword("(");
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                ISemanticRegion open = format.prepend(_keyword, _function_2);
                ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)call);
                ISemanticRegion close = _regionFor_2.keyword(")");
                EList<XExpression> _memberCallArguments = call.getMemberCallArguments();
                this.formatFeatureCallParams((List<XExpression>)_memberCallArguments, open, close, format);
                continue;
            }
            EList<XExpression> _memberCallArguments_1 = call.getMemberCallArguments();
            boolean _isEmpty = _memberCallArguments_1.isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            EList<XExpression> _memberCallArguments_2 = call.getMemberCallArguments();
            XClosure _builder = this.builder((List<XExpression>)_memberCallArguments_2);
            this.formatBuilderWithLeadingGap(_builder, format);
        }
    }

    protected AbstractRule binaryOperationPrecedence(EObject op) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(op);
        ISemanticRegion node = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        if (node != null && node.getGrammarElement() instanceof RuleCall) {
            EObject _grammarElement = node.getGrammarElement();
            return ((RuleCall)_grammarElement).getRule();
        }
        return null;
    }

    protected void _format(XBinaryOperation expr, @Extension IFormattableDocument format) {
        AbstractRule precendece = this.binaryOperationPrecedence(expr);
        IEObjectRegion _regionForEObject = this.textRegionExtensions.regionForEObject((EObject)expr);
        SeparatorRegions<XBinaryOperation, ISemanticRegion> calls = new SeparatorRegions<XBinaryOperation, ISemanticRegion>((ITextSegment)_regionForEObject);
        XExpression top = expr;
        while (Objects.equal((Object)this.binaryOperationPrecedence(top), (Object)precendece)) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)top);
            ISemanticRegion _feature = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
            calls.prependWithLeadingSeparator((XBinaryOperation)top, _feature);
            XExpression _leftOperand = top.getLeftOperand();
            top = _leftOperand;
        }
        this.format(top, format);
        IHiddenRegion _nextHiddenRegion = this.textRegionExtensions.nextHiddenRegion((EObject)expr);
        IndentOnceAutowrapFormatter indent = new IndentOnceAutowrapFormatter(_nextHiddenRegion);
        for (ObjectEntry ele : calls) {
            SeparatorEntry _leadingSeparator = ele.getLeadingSeparator();
            ISemanticRegion _separator = null;
            if (_leadingSeparator != null) {
                _separator = (ISemanticRegion)_leadingSeparator.getSeparator();
            }
            ISemanticRegion sep = _separator;
            XBinaryOperation _object = (XBinaryOperation)ele.getObject();
            boolean _prependNewLineIfMultiline = this.prependNewLineIfMultiline(_object);
            if (_prependNewLineIfMultiline) {
                Procedures.Procedure1 _function = it -> {
                    it.oneSpace();
                    ITextSegment _region = ele.getRegion();
                    int _length = _region.getLength();
                    it.autowrap(_length);
                    it.setOnAutowrap((IAutowrapFormatter)indent);
                };
                format.append(sep, _function);
            } else {
                Procedures.Procedure1 _function_1 = it -> it.oneSpace();
                format.append(sep, _function_1);
            }
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            format.prepend(sep, _function_2);
            XBinaryOperation _object_1 = (XBinaryOperation)ele.getObject();
            XExpression _rightOperand = _object_1.getRightOperand();
            format.format((Object)_rightOperand);
        }
    }

    protected boolean prependNewLineIfMultiline(EObject obj) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (obj instanceof XMemberFeatureCall) {
            _matched = true;
            EList<XExpression> _memberCallArguments = ((XMemberFeatureCall)obj).getMemberCallArguments();
            XClosure _builder = this.builder((List<XExpression>)_memberCallArguments);
            _switchResult = this.prependNewLineIfMultiline(_builder);
        }
        if (!_matched && obj instanceof XClosure) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && obj instanceof XBlockExpression) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    protected void _format(XSynchronizedExpression expr, @Extension IFormattableDocument format) {
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof XVariableDeclaration) {
            Procedures.Procedure1 _function = it -> it.indent();
            format.surround((EObject)expr, _function);
        }
        boolean multiline = this.textRegionExtensions.isMultiline((EObject)expr.getExpression()) || this.textRegionExtensions.previousHiddenRegion((EObject)expr.getExpression()).isMultiline();
        XExpression _param = expr.getParam();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround((EObject)_param, _function_1);
        if (expr.getExpression() instanceof XBlockExpression || multiline) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword = _regionFor.keyword("synchronized");
            format.append(_keyword, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        } else {
            ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword_1 = _regionFor_1.keyword("synchronized");
            format.append(_keyword_1, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisSL);
        }
        XExpression _param_1 = expr.getParam();
        format.format((Object)_param_1);
        XExpression _expression = expr.getExpression();
        this.formatBody(_expression, false, format);
    }

    protected void _format(XIfExpression expr, @Extension IFormattableDocument format) {
        boolean _tripleEquals;
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof XVariableDeclaration) {
            Procedures.Procedure1 _function = it -> it.indent();
            format.surround((EObject)expr, _function);
        }
        boolean multiline = this.isMultilineOrInNewLine(expr.getThen()) || this.isMultilineOrInNewLine(expr.getElse());
        XExpression _if = expr.getIf();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround((EObject)_if, _function_1);
        if (expr.getThen() instanceof XBlockExpression || multiline) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword = _regionFor.keyword("if");
            format.append(_keyword, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        } else {
            ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion _keyword_1 = _regionFor_1.keyword("if");
            format.append(_keyword_1, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisSL);
        }
        XExpression _if_1 = expr.getIf();
        format.format((Object)_if_1);
        XExpression _else = expr.getElse();
        boolean bl = _tripleEquals = _else == null;
        if (_tripleEquals) {
            XExpression _then = expr.getThen();
            this.formatBody(_then, multiline, format);
        } else {
            XExpression _then_1 = expr.getThen();
            this.formatBodyInline(_then_1, multiline, format);
            if (expr.getElse() instanceof XIfExpression || !multiline) {
                XExpression _else_1 = expr.getElse();
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                format.prepend((EObject)_else_1, _function_2);
                XExpression _else_2 = expr.getElse();
                format.format((Object)_else_2);
            } else {
                XExpression _else_3 = expr.getElse();
                this.formatBody(_else_3, multiline, format);
            }
        }
    }

    protected void _format(XForLoopExpression expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("for");
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(_keyword, _function);
        JvmFormalParameter _declaredParam = expr.getDeclaredParam();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        JvmFormalParameter _prepend = (JvmFormalParameter)format.prepend((EObject)_declaredParam, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        format.append((EObject)_prepend, _function_2);
        XExpression _forExpression = expr.getForExpression();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        XExpression _prepend_1 = (XExpression)format.prepend((EObject)_forExpression, _function_3);
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        XExpression _append = (XExpression)format.append((EObject)_prepend_1, _function_4);
        format.format((Object)_append);
        XExpression _eachExpression = expr.getEachExpression();
        this.formatBody(_eachExpression, true, format);
    }

    protected void _format(XBasicForLoopExpression expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("for");
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(_keyword, _function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("(");
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.append(_keyword_1, _function_1);
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
        List _keywords = _regionFor_2.keywords(new String[]{";"});
        Consumer<ISemanticRegion> _function_2 = it -> {
            Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
            ISemanticRegion _prepend = format.prepend(it, _function_3);
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.noSpace();
                it_1.lowPriority();
            };
            format.append(_prepend, _function_4);
        };
        _keywords.forEach(_function_2);
        ISemanticRegionsFinder _regionFor_3 = this.textRegionExtensions.regionFor((EObject)expr);
        List _keywords_1 = _regionFor_3.keywords(new String[]{","});
        Consumer<ISemanticRegion> _function_3 = it -> {
            Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
            ISemanticRegion _prepend = format.prepend(it, _function_4);
            Procedures.Procedure1 _function_5 = it_1 -> it_1.oneSpace();
            format.append(_prepend, _function_5);
        };
        _keywords_1.forEach(_function_3);
        ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_4.keyword(")");
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        format.prepend(_keyword_2, _function_4);
        EList<XExpression> _initExpressions = expr.getInitExpressions();
        Consumer<XExpression> _function_5 = it -> format.format(it);
        _initExpressions.forEach(_function_5);
        XExpression _expression = expr.getExpression();
        Procedures.Procedure1 _function_6 = it -> it.oneSpace();
        format.prepend((EObject)_expression, _function_6);
        XExpression _expression_1 = expr.getExpression();
        format.format((Object)_expression_1);
        EList<XExpression> _updateExpressions = expr.getUpdateExpressions();
        XExpression _head = (XExpression)IterableExtensions.head(_updateExpressions);
        Procedures.Procedure1 _function_7 = it -> it.oneSpace();
        format.prepend((EObject)_head, _function_7);
        EList<XExpression> _updateExpressions_1 = expr.getUpdateExpressions();
        Consumer<XExpression> _function_8 = it -> format.format(it);
        _updateExpressions_1.forEach(_function_8);
        XExpression _eachExpression = expr.getEachExpression();
        this.formatBody(_eachExpression, true, format);
    }

    protected void _format(XWhileExpression expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("while");
        format.append(_keyword, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        XExpression _predicate = expr.getPredicate();
        Procedures.Procedure1 _function = it -> it.noSpace();
        XExpression _prepend = (XExpression)format.prepend((EObject)_predicate, _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        XExpression _append = (XExpression)format.append((EObject)_prepend, _function_1);
        format.format((Object)_append);
        XExpression _body = expr.getBody();
        this.formatBody(_body, true, format);
    }

    protected void _format(XDoWhileExpression expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("while");
        format.append(_keyword, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        XExpression _predicate = expr.getPredicate();
        Procedures.Procedure1 _function = it -> it.noSpace();
        XExpression _prepend = (XExpression)format.prepend((EObject)_predicate, _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        XExpression _append = (XExpression)format.append((EObject)_prepend, _function_1);
        format.format((Object)_append);
        XExpression _body = expr.getBody();
        this.formatBodyInline(_body, true, format);
    }

    protected void _format(XBlockExpression expr, @Extension IFormattableDocument format) {
        boolean _tripleEquals;
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion open = _regionFor.keyword("{");
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion close = _regionFor_1.keyword("}");
        EObject _eContainer = expr.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.surround((EObject)expr, _function);
        }
        if (open != null && close != null) {
            boolean _isSingleLineBlock = this.isSingleLineBlock(expr);
            if (_isSingleLineBlock) {
                ISubFormatter _function_1 = f -> {
                    EList<XExpression> _expressions = expr.getExpressions();
                    IFormattableSubDocument _requireFitsInLine = f.requireFitsInLine();
                    this.formatExpressionsSingleline((Collection<? extends XExpression>)_expressions, open, close, (IFormattableDocument)_requireFitsInLine);
                };
                ISubFormatter _function_2 = f -> {
                    EList<XExpression> _expressions = expr.getExpressions();
                    this.formatExpressionsMultiline((Collection<? extends XExpression>)_expressions, open, close, (IFormattableDocument)f);
                };
                format.formatConditionally((EObject)expr, new ISubFormatter[]{_function_1, _function_2});
            } else {
                EList<XExpression> _expressions = expr.getExpressions();
                this.formatExpressionsMultiline((Collection<? extends XExpression>)_expressions, open, close, format);
            }
        }
    }

    protected boolean isSingleLineBlock(XBlockExpression expr) {
        return false;
    }

    protected void _format(XTypeLiteral expr, @Extension IFormattableDocument format) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("typeof");
        Procedures.Procedure1 _function = it -> it.noSpace();
        format.append(_keyword, _function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _feature = _regionFor_1.feature((EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        ISemanticRegion _prepend = format.prepend(_feature, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        format.append(_prepend, _function_2);
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
        ParserRule _arrayBracketsRule = this.grammar.getArrayBracketsRule();
        List _ruleCallsTo = _regionFor_2.ruleCallsTo(new AbstractRule[]{_arrayBracketsRule});
        for (ISemanticRegion region : _ruleCallsTo) {
            Procedures.Procedure1 _function_3 = it -> it.noSpace();
            format.append(region, _function_3);
            ArrayBracketsFormattingReplacer _arrayBracketsFormattingReplacer = new ArrayBracketsFormattingReplacer(region);
            format.addReplacer((ITextReplacer)_arrayBracketsFormattingReplacer);
        }
    }

    protected void _format(XThrowExpression expr, @Extension IFormattableDocument format) {
        XExpression _expression = expr.getExpression();
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend((EObject)_expression, _function);
        XExpression _expression_1 = expr.getExpression();
        format.format((Object)_expression_1);
    }

    protected void _format(XReturnExpression expr, @Extension IFormattableDocument format) {
        XExpression _expression = expr.getExpression();
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend((EObject)_expression, _function);
        XExpression _expression_1 = expr.getExpression();
        format.format((Object)_expression_1);
    }

    protected void _format(XTryCatchFinallyExpression expr, @Extension IFormattableDocument format) {
        XExpression _expression = expr.getExpression();
        this.formatBodyInline(_expression, true, format);
        EList<XCatchClause> _catchClauses = expr.getCatchClauses();
        for (XCatchClause cc : _catchClauses) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)cc);
            ISemanticRegion _keyword = _regionFor.keyword("catch");
            format.append(_keyword, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
            JvmFormalParameter _declaredParam = cc.getDeclaredParam();
            Procedures.Procedure1 _function = it -> it.noSpace();
            JvmFormalParameter _prepend = (JvmFormalParameter)format.prepend((EObject)_declaredParam, _function);
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            JvmFormalParameter _append = (JvmFormalParameter)format.append((EObject)_prepend, _function_1);
            format.format((Object)_append);
            if (!Objects.equal((Object)cc, (Object)IterableExtensions.last(expr.getCatchClauses())) || expr.getFinallyExpression() != null) {
                XExpression _expression_1 = cc.getExpression();
                this.formatBodyInline(_expression_1, true, format);
                continue;
            }
            XExpression _expression_2 = cc.getExpression();
            this.formatBody(_expression_2, true, format);
        }
        XExpression _finallyExpression = expr.getFinallyExpression();
        this.formatBody(_finallyExpression, true, format);
    }

    protected void _format(JvmFormalParameter expr, @Extension IFormattableDocument format) {
        JvmTypeReference _parameterType = expr.getParameterType();
        if (_parameterType != null) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            format.append((EObject)_parameterType, _function);
        }
        JvmTypeReference _parameterType_1 = expr.getParameterType();
        format.format((Object)_parameterType_1);
    }

    protected void _format(XExpression expr, @Extension IFormattableDocument format) {
        EList _eContents = expr.eContents();
        for (EObject obj : _eContents) {
            boolean _matched = false;
            if (!(obj instanceof XExpression)) continue;
            _matched = true;
            format.format((Object)((XExpression)obj));
        }
    }

    protected void _format(XSwitchExpression expr, @Extension IFormattableDocument format) {
        XExpression _case;
        Functions.Function1 _function;
        EList<XCasePart> _cases = expr.getCases();
        boolean containsBlockExpr = IterableExtensions.exists(_cases, (Functions.Function1)(_function = it -> {
            XExpression _then = it.getThen();
            return _then instanceof XBlockExpression;
        }));
        boolean switchSL = !containsBlockExpr && !this.textRegionExtensions.isMultiline((EObject)expr);
        boolean caseSL = !containsBlockExpr && (!expr.getCases().isEmpty() || expr.getDefault() != null) && !IterableExtensions.exists(expr.getCases(), it -> this.textRegionExtensions.isMultiline((EObject)it)) && !this.isMultilineOrInNewLine(expr.getDefault());
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion open = _regionFor.keyword("{");
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion close = _regionFor_1.keyword("}");
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor_2.keyword("switch");
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        format.append(_keyword, _function_1);
        if (switchSL) {
            boolean _tripleNotEquals;
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            format.prepend(open, _function_2);
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            format.append(open, _function_3);
            EList<XCasePart> _cases_1 = expr.getCases();
            for (XCasePart c : _cases_1) {
                boolean _tripleEquals;
                _case = c.getCase();
                format.format((Object)_case);
                XExpression _then = c.getThen();
                format.format((Object)_then);
                XExpression _then_1 = c.getThen();
                boolean bl = _tripleEquals = _then_1 == null;
                if (_tripleEquals) {
                    Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                    format.append((EObject)c, _function_4);
                    continue;
                }
                XExpression _then_2 = c.getThen();
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                XExpression _prepend = (XExpression)format.prepend((EObject)_then_2, _function_5);
                Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                format.append((EObject)_prepend, _function_6);
            }
            XExpression _default = expr.getDefault();
            boolean bl = _tripleNotEquals = _default != null;
            if (_tripleNotEquals) {
                Iterator _regionFor_3 = this.textRegionExtensions.regionFor((EObject)expr);
                ISemanticRegion _keyword_1 = _regionFor_3.keyword("default");
                Procedures.Procedure1 _function_4 = it -> it.noSpace();
                format.append(_keyword_1, _function_4);
                XExpression _default_1 = expr.getDefault();
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                XExpression _surround = (XExpression)format.surround((EObject)_default_1, _function_5);
                format.format((Object)_surround);
            }
        } else if (caseSL) {
            boolean _tripleNotEquals_1;
            boolean _not;
            format.prepend(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            EList<XCasePart> _cases_2 = expr.getCases();
            boolean _isEmpty = _cases_2.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Procedures.Procedure1 _function_6 = it -> it.newLine();
                format.append(open, _function_6);
            }
            Procedures.Procedure1 _function_7 = it -> it.indent();
            format.interior(open, close, _function_7);
            EList<XCasePart> _cases_3 = expr.getCases();
            for (XCasePart c_1 : _cases_3) {
                XExpression _case2 = c_1.getCase();
                format.format((Object)_case2);
                XExpression _then = c_1.getThen();
                format.format((Object)_then);
                XExpression _then_1 = c_1.getThen();
                Procedures.Procedure1 _function_8 = it -> it.oneSpace();
                format.prepend((EObject)_then_1, _function_8);
                EList<XCasePart> _cases_4 = expr.getCases();
                XCasePart _last = (XCasePart)IterableExtensions.last(_cases_4);
                boolean _notEquals = !Objects.equal((Object)c_1, (Object)_last);
                if (!_notEquals) continue;
                Procedures.Procedure1 _function_9 = it -> it.newLine();
                format.append((EObject)c_1, _function_9);
            }
            XExpression _default_2 = expr.getDefault();
            boolean bl2 = _tripleNotEquals_1 = _default_2 != null;
            if (_tripleNotEquals_1) {
                ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor((EObject)expr);
                ISemanticRegion _keyword_2 = _regionFor_4.keyword("default");
                Procedures.Procedure1 _function_8 = it -> it.newLine();
                ISemanticRegion _prepend = format.prepend(_keyword_2, _function_8);
                Procedures.Procedure1 _function_9 = it -> it.noSpace();
                format.append(_prepend, _function_9);
                XExpression _default_3 = expr.getDefault();
                Procedures.Procedure1 _function_10 = it -> it.oneSpace();
                XExpression _prepend_1 = (XExpression)format.prepend((EObject)_default_3, _function_10);
                format.format((Object)_prepend_1);
            }
            Procedures.Procedure1 _function_11 = it -> it.newLine();
            format.prepend(close, _function_11);
        } else {
            boolean _tripleNotEquals_2;
            ISemanticRegion _prepend_2 = format.prepend(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            Procedures.Procedure1 _function_12 = it -> it.newLine();
            format.append(_prepend_2, _function_12);
            if (!expr.getCases().isEmpty() || expr.getDefault() != null) {
                Procedures.Procedure1 _function_13 = it -> it.indent();
                format.interior(open, close, _function_13);
            }
            EList<XCasePart> _cases_4 = expr.getCases();
            for (XCasePart c_2 : _cases_4) {
                _case = c_2.getCase();
                format.format((Object)_case);
                XExpression _then = c_2.getThen();
                this.formatBodyParagraph(_then, format);
                ISemanticRegionsFinder _regionFor_5 = this.textRegionExtensions.regionFor((EObject)c_2);
                ISemanticRegion _feature = _regionFor_5.feature((EStructuralFeature)XbasePackage.Literals.XCASE_PART__FALL_THROUGH);
                Procedures.Procedure1 _function_14 = it -> it.noSpace();
                ISemanticRegion _prepend_3 = format.prepend(_feature, _function_14);
                Procedures.Procedure1 _function_15 = it -> it.newLine();
                format.append(_prepend_3, _function_15);
            }
            XExpression _default_4 = expr.getDefault();
            boolean bl = _tripleNotEquals_2 = _default_4 != null;
            if (_tripleNotEquals_2) {
                ISemanticRegionsFinder _regionFor_5 = this.textRegionExtensions.regionFor((EObject)expr);
                ISemanticRegion _keyword_3 = _regionFor_5.keyword("default");
                Procedures.Procedure1 _function_14 = it -> it.noSpace();
                format.append(_keyword_3, _function_14);
                XExpression _default_5 = expr.getDefault();
                this.formatBodyParagraph(_default_5, format);
            }
        }
        EList<XCasePart> _cases_5 = expr.getCases();
        for (XCasePart c_3 : _cases_5) {
            boolean _tripleNotEquals_3;
            if (c_3.getTypeGuard() != null && c_3.getCase() != null) {
                JvmTypeReference _typeGuard = c_3.getTypeGuard();
                Procedures.Procedure1 _function_15 = it -> it.oneSpace();
                format.append((EObject)_typeGuard, _function_15);
                _case = c_3.getCase();
                Procedures.Procedure1 _function_16 = it -> it.oneSpace();
                XExpression _prepend_3 = (XExpression)format.prepend((EObject)_case, _function_16);
                Procedures.Procedure1 _function_17 = it -> it.noSpace();
                format.append((EObject)_prepend_3, _function_17);
                continue;
            }
            JvmTypeReference _typeGuard_1 = c_3.getTypeGuard();
            boolean bl = _tripleNotEquals_3 = _typeGuard_1 != null;
            if (_tripleNotEquals_3) {
                JvmTypeReference _typeGuard_2 = c_3.getTypeGuard();
                Procedures.Procedure1 _function_18 = it -> it.noSpace();
                format.append((EObject)_typeGuard_2, _function_18);
                continue;
            }
            XExpression _case_1 = c_3.getCase();
            boolean _tripleNotEquals_4 = _case_1 != null;
            if (!_tripleNotEquals_4) continue;
            XExpression _case_2 = c_3.getCase();
            Procedures.Procedure1 _function_19 = it -> it.oneSpace();
            XExpression _prepend_4 = (XExpression)format.prepend((EObject)_case_2, _function_19);
            Procedures.Procedure1 _function_20 = it -> it.noSpace();
            format.append((EObject)_prepend_4, _function_20);
        }
    }

    protected ISemanticRegion formatClosureParams(XClosure expr, ISemanticRegion open, @Extension IFormattableDocument format, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        boolean _isExplicitSyntax = expr.isExplicitSyntax();
        if (_isExplicitSyntax) {
            ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            ISemanticRegion last = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XCLOSURE__EXPLICIT_SYNTAX);
            EList<JvmFormalParameter> _declaredFormalParameters = expr.getDeclaredFormalParameters();
            boolean _isEmpty = _declaredFormalParameters.isEmpty();
            if (_isEmpty) {
                Procedures.Procedure1 _function = it -> it.noSpace();
                format.append(open, _function);
            } else {
                boolean _not;
                EList<JvmFormalParameter> _declaredFormalParameters_1 = expr.getDeclaredFormalParameters();
                for (JvmFormalParameter param : _declaredFormalParameters_1) {
                    format.format((Object)param);
                    ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)param);
                    ISemanticRegion _keyword = _immediatelyFollowing.keyword(",");
                    Procedures.Procedure1 _function_1 = it -> it.noSpace();
                    ISemanticRegion _prepend = format.prepend(_keyword, _function_1);
                    Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                    format.append(_prepend, _function_2);
                }
                format.append(open, init);
                EList<JvmFormalParameter> _declaredFormalParameters_2 = expr.getDeclaredFormalParameters();
                boolean _isEmpty_1 = _declaredFormalParameters_2.isEmpty();
                boolean bl = _not = !_isEmpty_1;
                if (_not) {
                    format.prepend(last, init);
                }
            }
            return last;
        }
        return open;
    }

    protected void _format(XClosure expr, @Extension IFormattableDocument format) {
        XExpression _expression;
        ISemanticRegion _elvis = null;
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("[");
        if (_keyword != null) {
            _elvis = _keyword;
        } else {
            ISemanticRegion _keyword_1;
            ISemanticRegionFinder _immediatelyPreceding = this.textRegionExtensions.immediatelyPreceding((EObject)expr);
            _elvis = _keyword_1 = _immediatelyPreceding.keyword("(");
        }
        ISemanticRegion open = _elvis;
        ISemanticRegion _elvis_1 = null;
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_1.keyword("]");
        if (_keyword_2 != null) {
            _elvis_1 = _keyword_2;
        } else {
            ISemanticRegion _keyword_3;
            ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)expr);
            _elvis_1 = _keyword_3 = _immediatelyFollowing.keyword(")");
        }
        ISemanticRegion close = _elvis_1;
        Object _switchResult = null;
        XExpression x = _expression = expr.getExpression();
        boolean _matched = false;
        if (x instanceof XBlockExpression) {
            _matched = true;
            _switchResult = ((XBlockExpression)x).getExpressions();
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.newArrayList((Object[])new XExpression[]{x});
        }
        EList<XExpression> children = _switchResult;
        if (open != null && close != null) {
            boolean _isEmpty = children.isEmpty();
            if (_isEmpty) {
                IHiddenRegion _nextHiddenRegion = open.getNextHiddenRegion();
                boolean _containsComment = _nextHiddenRegion.containsComment();
                if (_containsComment) {
                    Procedures.Procedure1 _function = it -> {
                        it.newLine();
                        it.indent();
                    };
                    format.append(open, _function);
                } else {
                    Procedures.Procedure1 _function_1 = it -> it.noSpace();
                    format.append(open, _function_1);
                }
            } else {
                IHiddenRegion _previousHiddenRegion = close.getPreviousHiddenRegion();
                boolean _isMultiline = _previousHiddenRegion.isMultiline();
                if (_isMultiline) {
                    Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                    ISemanticRegion last = this.formatClosureParams(expr, open, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
                    this.formatExpressionsMultiline((Collection<? extends XExpression>)children, last, close, format);
                } else {
                    IHiddenRegion _previousHiddenRegion_1 = open.getPreviousHiddenRegion();
                    ISemanticRegion _nextSemanticRegion = _previousHiddenRegion_1.getNextSemanticRegion();
                    int offset = _nextSemanticRegion.getEndOffset();
                    int _offset = close.getOffset();
                    int length = _offset - offset;
                    ISubFormatter _function_3 = doc -> {
                        IFormattableSubDocument it = doc.requireFitsInLine();
                        Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
                        ISemanticRegion last_1 = this.formatClosureParams(expr, open, (IFormattableDocument)it, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_4);
                        Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
                        it.append(last_1, _function_5);
                        for (XExpression c : children) {
                            it.format((Object)c);
                            ISemanticRegionFinder _immediatelyFollowing_1 = this.textRegionExtensions.immediatelyFollowing((EObject)c);
                            ISemanticRegion semicolon = _immediatelyFollowing_1.keyword(";");
                            if (semicolon != null) {
                                Procedures.Procedure1 _function_6 = it_1 -> it_1.noSpace();
                                ISemanticRegion _prepend = it.prepend(semicolon, _function_6);
                                Procedures.Procedure1 _function_7 = it_1 -> {
                                    XExpression _last = (XExpression)IterableExtensions.last((Iterable)children);
                                    boolean _equals = Objects.equal((Object)c, (Object)_last);
                                    if (_equals) {
                                        it_1.noSpace();
                                    } else {
                                        it_1.oneSpace();
                                    }
                                };
                                it.append(_prepend, _function_7);
                                continue;
                            }
                            Procedures.Procedure1 _function_8 = it_1 -> {
                                XExpression _last = (XExpression)IterableExtensions.last((Iterable)children);
                                boolean _equals = Objects.equal((Object)c, (Object)_last);
                                if (_equals) {
                                    it_1.noSpace();
                                } else {
                                    it_1.oneSpace();
                                }
                            };
                            it.append((EObject)c, _function_8);
                        }
                    };
                    ISubFormatter _function_4 = doc -> {
                        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                        ISemanticRegion last_1 = this.formatClosureParams(expr, open, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_5);
                        this.formatExpressionsMultiline((Collection<? extends XExpression>)children, last_1, close, (IFormattableDocument)doc);
                    };
                    format.formatConditionally(offset, length, new ISubFormatter[]{_function_3, _function_4});
                }
            }
        }
    }

    protected void formatBody(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.textRegionExtensions.previousHiddenRegion((EObject)expr).isMultiline()) {
            Procedures.Procedure1 _function = it -> it.newLine();
            XExpression _prepend = (XExpression)doc.prepend((EObject)expr, _function);
            Procedures.Procedure1 _function_1 = it -> it.indent();
            doc.surround((EObject)_prepend, _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            doc.prepend((EObject)expr, _function_2);
        }
        doc.format((Object)expr);
    }

    protected void formatBodyInline(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            XBlockExpression _prepend = (XBlockExpression)doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            doc.append((EObject)_prepend, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.textRegionExtensions.previousHiddenRegion((EObject)expr).isMultiline()) {
            Procedures.Procedure1 _function = it -> it.newLine();
            XExpression _prepend_1 = (XExpression)doc.prepend((EObject)expr, _function);
            Procedures.Procedure1 _function_1 = it -> it.indent();
            XExpression _surround = (XExpression)doc.surround((EObject)_prepend_1, _function_1);
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            doc.append((EObject)_surround, _function_2);
        } else {
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            doc.surround((EObject)expr, _function_3);
        }
        doc.format((Object)expr);
    }

    protected void formatBodyParagraph(XExpression expr, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            XBlockExpression _prepend = (XBlockExpression)doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            Procedures.Procedure1 _function = it -> it.newLine();
            doc.append((EObject)_prepend, _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            XExpression _prepend_1 = (XExpression)doc.prepend((EObject)expr, _function_1);
            Procedures.Procedure1 _function_2 = it -> it.indent();
            XExpression _surround = (XExpression)doc.surround((EObject)_prepend_1, _function_2);
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            doc.append((EObject)_surround, _function_3);
        }
        doc.format((Object)expr);
    }

    protected void _format(XInstanceOfExpression expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("instanceof");
        Procedures.Procedure1 _function = it -> it.oneSpace();
        doc.surround(_keyword, _function);
        XExpression _expression = expr.getExpression();
        doc.format((Object)_expression);
        JvmTypeReference _type = expr.getType();
        doc.format((Object)_type);
    }

    protected void _format(XCastedExpression expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("as");
        Procedures.Procedure1 _function = it -> it.oneSpace();
        doc.surround(_keyword, _function);
        XExpression _target = expr.getTarget();
        doc.format((Object)_target);
        JvmTypeReference _type = expr.getType();
        doc.format((Object)_type);
    }

    protected void _format(XPostfixOperation expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _feature = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        Procedures.Procedure1 _function = it -> it.noSpace();
        doc.prepend(_feature, _function);
        XExpression _operand = expr.getOperand();
        doc.format((Object)_operand);
    }

    protected void formatExpressionsMultiline(Collection<? extends XExpression> expressions, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.indent();
        format.interior(open, close, _function);
        boolean _isEmpty = expressions.isEmpty();
        if (_isEmpty) {
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            format.append(open, _function_1);
        } else {
            format.append(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
            for (XExpression xExpression : expressions) {
                format.format((Object)xExpression);
                ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)xExpression);
                ISemanticRegion sem = _immediatelyFollowing.keyword(";");
                if (sem != null) {
                    Procedures.Procedure1 _function_2 = it -> it.noSpace();
                    ISemanticRegion _prepend = format.prepend(sem, _function_2);
                    format.append(_prepend, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
                    continue;
                }
                format.append((EObject)xExpression, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
            }
        }
    }

    protected void formatExpressionsSingleline(Collection<? extends XExpression> expressions, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        boolean _isEmpty = expressions.isEmpty();
        if (_isEmpty) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.append(open, _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> it.oneSpace();
            format.append(open, _function_1);
            for (XExpression xExpression : expressions) {
                format.format((Object)xExpression);
                ISemanticRegionFinder _immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)xExpression);
                ISemanticRegion sem = _immediatelyFollowing.keyword(";");
                if (sem != null) {
                    Procedures.Procedure1 _function_2 = it -> it.noSpace();
                    ISemanticRegion _prepend = format.prepend(sem, _function_2);
                    Procedures.Procedure1 _function_3 = it -> it.oneSpace();
                    format.append(_prepend, _function_3);
                    continue;
                }
                Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                format.append((EObject)xExpression, _function_4);
            }
        }
    }

    protected boolean isMultilineOrInNewLine(EObject obj) {
        return obj != null && (this.textRegionExtensions.isMultiline(obj) || this.textRegionExtensions.previousHiddenRegion(obj).isMultiline());
    }

    @Override
    public void format(Object expr, IFormattableDocument format) {
        if (expr instanceof JvmTypeParameter) {
            this._format((JvmTypeParameter)expr, format);
            return;
        }
        if (expr instanceof JvmFormalParameter) {
            this._format((JvmFormalParameter)expr, format);
            return;
        }
        if (expr instanceof XtextResource) {
            this._format((XtextResource)expr, format);
            return;
        }
        if (expr instanceof XAssignment) {
            this._format((XAssignment)expr, format);
            return;
        }
        if (expr instanceof XBinaryOperation) {
            this._format((XBinaryOperation)expr, format);
            return;
        }
        if (expr instanceof XDoWhileExpression) {
            this._format((XDoWhileExpression)expr, format);
            return;
        }
        if (expr instanceof XFeatureCall) {
            this._format((XFeatureCall)expr, format);
            return;
        }
        if (expr instanceof XMemberFeatureCall) {
            this._format((XMemberFeatureCall)expr, format);
            return;
        }
        if (expr instanceof XPostfixOperation) {
            this._format((XPostfixOperation)expr, format);
            return;
        }
        if (expr instanceof XWhileExpression) {
            this._format((XWhileExpression)expr, format);
            return;
        }
        if (expr instanceof XFunctionTypeRef) {
            this._format((XFunctionTypeRef)expr, format);
            return;
        }
        if (expr instanceof JvmGenericArrayTypeReference) {
            this._format((JvmGenericArrayTypeReference)expr, format);
            return;
        }
        if (expr instanceof JvmParameterizedTypeReference) {
            this._format((JvmParameterizedTypeReference)expr, format);
            return;
        }
        if (expr instanceof JvmWildcardTypeReference) {
            this._format((JvmWildcardTypeReference)expr, format);
            return;
        }
        if (expr instanceof XBasicForLoopExpression) {
            this._format((XBasicForLoopExpression)expr, format);
            return;
        }
        if (expr instanceof XBlockExpression) {
            this._format((XBlockExpression)expr, format);
            return;
        }
        if (expr instanceof XCastedExpression) {
            this._format((XCastedExpression)expr, format);
            return;
        }
        if (expr instanceof XClosure) {
            this._format((XClosure)expr, format);
            return;
        }
        if (expr instanceof XCollectionLiteral) {
            this._format((XCollectionLiteral)expr, format);
            return;
        }
        if (expr instanceof XConstructorCall) {
            this._format((XConstructorCall)expr, format);
            return;
        }
        if (expr instanceof XForLoopExpression) {
            this._format((XForLoopExpression)expr, format);
            return;
        }
        if (expr instanceof XIfExpression) {
            this._format((XIfExpression)expr, format);
            return;
        }
        if (expr instanceof XInstanceOfExpression) {
            this._format((XInstanceOfExpression)expr, format);
            return;
        }
        if (expr instanceof XReturnExpression) {
            this._format((XReturnExpression)expr, format);
            return;
        }
        if (expr instanceof XSwitchExpression) {
            this._format((XSwitchExpression)expr, format);
            return;
        }
        if (expr instanceof XSynchronizedExpression) {
            this._format((XSynchronizedExpression)expr, format);
            return;
        }
        if (expr instanceof XThrowExpression) {
            this._format((XThrowExpression)expr, format);
            return;
        }
        if (expr instanceof XTryCatchFinallyExpression) {
            this._format((XTryCatchFinallyExpression)expr, format);
            return;
        }
        if (expr instanceof XTypeLiteral) {
            this._format((XTypeLiteral)expr, format);
            return;
        }
        if (expr instanceof XVariableDeclaration) {
            this._format((XVariableDeclaration)expr, format);
            return;
        }
        if (expr instanceof JvmTypeConstraint) {
            this._format((JvmTypeConstraint)expr, format);
            return;
        }
        if (expr instanceof XExpression) {
            this._format((XExpression)expr, format);
            return;
        }
        if (expr instanceof XImportDeclaration) {
            this._format((XImportDeclaration)expr, format);
            return;
        }
        if (expr instanceof XImportSection) {
            this._format((XImportSection)expr, format);
            return;
        }
        if (expr instanceof EObject) {
            this._format((EObject)expr, format);
            return;
        }
        if (expr == null) {
            this._format(null, format);
            return;
        }
        if (expr != null) {
            this._format(expr, format);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr, format).toString());
    }

    @Pure
    public XbaseGrammarAccess getGrammar() {
        return this.grammar;
    }
}

