/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.builder;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;

public class XbaseBuilderPreferenceAccess {
    public static final String PREF_GENERATE_SUPPRESS_WARNINGS = "generateSuppressWarnings";
    public static final String PREF_GENERATE_GENERATED = "generateGeneratedAnnotation";
    public static final String PREF_DATE_IN_GENERATED = "includeDateInGenerated";
    public static final String PREF_GENERATED_COMMENT = "generatedAnnotationComment";
    public static final String PREF_JAVA_VERSION = "targetJavaVersion";
    public static final String PREF_USE_COMPILER_SOURCE = "useJavaCompilerCompliance";
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;

    public void loadBuilderPreferences(GeneratorConfig generatorConfig, Object context) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
        generatorConfig.setGenerateSyntheticSuppressWarnings(preferenceStore.getBoolean(PREF_GENERATE_SUPPRESS_WARNINGS));
        generatorConfig.setGenerateGeneratedAnnotation(preferenceStore.getBoolean(PREF_GENERATE_GENERATED));
        if (generatorConfig.isGenerateGeneratedAnnotation()) {
            generatorConfig.setIncludeDateInGeneratedAnnotation(preferenceStore.getBoolean(PREF_DATE_IN_GENERATED));
            generatorConfig.setGeneratedAnnotationComment(preferenceStore.getString(PREF_GENERATED_COMMENT));
        }
        generatorConfig.setJavaSourceVersion(this.getJavaVersion(context, preferenceStore));
    }

    public JavaVersion getJavaVersion(Object context, IPreferenceStore preferenceStore) {
        boolean useCompilerSource = preferenceStore.getBoolean(PREF_USE_COMPILER_SOURCE);
        if (useCompilerSource) {
            IJavaProject javaProject = JavaCore.create((IProject)(context instanceof IProject ? (IProject)context : null));
            String compilerSource = javaProject != null && javaProject.exists() && javaProject.getProject().isAccessible() ? javaProject.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
            return this.fromCompilerSourceLevel(compilerSource);
        }
        String stringValue = preferenceStore.getString(PREF_JAVA_VERSION);
        try {
            return JavaVersion.valueOf((String)stringValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return JavaVersion.JAVA5;
        }
    }

    public void setJavaVersion(Object context, JavaVersion version) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        preferenceStore.setValue(PREF_USE_COMPILER_SOURCE, false);
        preferenceStore.setValue(PREF_JAVA_VERSION, version.toString());
    }

    public JavaVersion fromCompilerSourceLevel(String compilerSource) {
        if ("1.8".equals(compilerSource)) {
            return JavaVersion.JAVA8;
        }
        if ("1.7".equals(compilerSource)) {
            return JavaVersion.JAVA7;
        }
        if ("1.6".equals(compilerSource)) {
            return JavaVersion.JAVA6;
        }
        return JavaVersion.JAVA5;
    }

    public static class Initializer
    extends BuilderPreferenceAccess.Initializer {
        protected void initializeBuilderPreferences(IPreferenceStore store) {
            super.initializeBuilderPreferences(store);
            store.setDefault(XbaseBuilderPreferenceAccess.PREF_GENERATE_SUPPRESS_WARNINGS, true);
            store.setDefault(XbaseBuilderPreferenceAccess.PREF_GENERATE_GENERATED, false);
            store.setDefault(XbaseBuilderPreferenceAccess.PREF_DATE_IN_GENERATED, false);
            store.setDefault(XbaseBuilderPreferenceAccess.PREF_JAVA_VERSION, JavaVersion.JAVA5.toString());
            store.setDefault(XbaseBuilderPreferenceAccess.PREF_USE_COMPILER_SOURCE, true);
        }
    }
}

