/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.builder.smap.XbaseBreakpointUtil;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.ui.editor.model.JarFileMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;

public class XbaseDocumentProvider
extends XtextDocumentProvider {
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;
    @Inject
    private XbaseBreakpointUtil breakpointUtil;

    protected ILocationInResource getClassFileSourceStorage(IClassFile classFile) {
        ITrace traceToSource = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (iterator.hasNext()) {
            ILocationInResource loc = (ILocationInResource)iterator.next();
            return loc;
        }
        return null;
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput input, String encoding) throws CoreException {
        if (input instanceof IClassFileEditorInput) {
            IClassFile classFile = ((IClassFileEditorInput)input).getClassFile();
            ILocationInResource source = this.getClassFileSourceStorage(classFile);
            if (source == null) {
                return false;
            }
            InputStream contents = null;
            try {
                contents = source.getContents();
                if (contents != null) {
                    this.setDocumentContent(document, contents, encoding);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        contents.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException iOException) {}
            this.setDocumentResource((XtextDocument)document, input, encoding);
            return true;
        }
        return super.setDocumentContent(document, input, encoding);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IClassFileEditorInput) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            ClassFileInfo info = new ClassFileInfo(document, this.createAnnotationModel(element));
            info.fStatus = status;
            this.registerAnnotationInfoProcessor(info);
            return info;
        }
        return super.createElementInfo(element);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        IEditorInput editorInput;
        URI breakpointURI;
        if (element instanceof IEditorInput && (breakpointURI = this.breakpointUtil.getBreakpointURI(editorInput = (IEditorInput)element)) != null) {
            IResource breakpointResource = this.breakpointUtil.getBreakpointResource(editorInput);
            return new JarFileMarkerAnnotationModel(breakpointResource, breakpointURI);
        }
        return super.createAnnotationModel(element);
    }

    protected class ClassFileInfo
    extends AbstractDocumentProvider.ElementInfo {
        public ClassFileInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)XbaseDocumentProvider.this, document, model);
        }
    }
}

