/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.BooleanFunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.ao;
import org.eclipse.xtext.xbase.lib.internal.aq;
import org.eclipse.xtext.xbase.lib.internal.ar;
import org.eclipse.xtext.xbase.lib.internal.b;
import org.eclipse.xtext.xbase.lib.internal.bd;
import org.eclipse.xtext.xbase.lib.internal.f;
import org.eclipse.xtext.xbase.lib.internal.i;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableExtensions {
    @Pure
    @Inline(value="$3.$4concat($1, $2)", imported={ao.class})
    public static <T> Iterable<T> operator_plus(Iterable<? extends T> a2, Iterable<? extends T> b2) {
        return ao.concat(a2, b2);
    }

    public static <T> T findFirst(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        for (T t2 : iterable) {
            if (!predicate.apply(t2).booleanValue()) continue;
            return t2;
        }
        return null;
    }

    public static <T> T findLast(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            ListIterator iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                Object t2 = iterator.previous();
                if (!predicate.apply(t2).booleanValue()) continue;
                return (T)t2;
            }
            return null;
        }
        T result = null;
        for (T t3 : iterable) {
            if (!predicate.apply(t3).booleanValue()) continue;
            result = t3;
        }
        return result;
    }

    public static <T> T head(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Iterable<T> tail(Iterable<T> iterable) {
        return IterableExtensions.drop(iterable, 1);
    }

    public static <T> T last(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                return null;
            }
            return (T)list.get(list.size() - 1);
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            if (sortedSet.isEmpty()) {
                return null;
            }
            return (T)sortedSet.last();
        }
        T result = null;
        for (T t2 : iterable) {
            result = t2;
        }
        return result;
    }

    public static <T> Iterable<T> take(final Iterable<T> iterable, final int count) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot take a negative number of elements. Argument 'count' was: " + count);
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new i<T>(count, iterable){
                    private int remaining;
                    private Iterator<T> delegate;
                    {
                        this.remaining = n2;
                        this.delegate = iterable.iterator();
                    }

                    @Override
                    protected T computeNext() {
                        if (this.remaining <= 0) {
                            return this.endOfData();
                        }
                        if (!this.delegate.hasNext()) {
                            return this.endOfData();
                        }
                        --this.remaining;
                        return this.delegate.next();
                    }
                };
            }
        };
    }

    @Pure
    public static <T> Iterable<T> drop(final Iterable<T> iterable, final int count) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (count == 0) {
            return iterable;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new i<T>(iterable, count){
                    private Iterator<T> delegate;
                    {
                        this.delegate = iterable.iterator();
                        int i2 = n2;
                        while (i2 > 0 && this.delegate.hasNext()) {
                            this.delegate.next();
                            --i2;
                        }
                    }

                    @Override
                    protected T computeNext() {
                        if (!this.delegate.hasNext()) {
                            return this.endOfData();
                        }
                        return this.delegate.next();
                    }
                };
            }
        };
    }

    public static <T> boolean exists(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        for (T t2 : iterable) {
            if (!predicate.apply(t2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean forall(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        for (T t2 : iterable) {
            if (predicate.apply(t2).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static <T> Iterable<T> filter(Iterable<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return ao.filter(unfiltered, new BooleanFunctionDelegate<T>(predicate));
    }

    @Pure
    @Inline(value="$3.$4filter($1, $2)", imported={ao.class})
    public static <T> Iterable<T> filter(Iterable<?> unfiltered, Class<T> type) {
        return ao.filter(unfiltered, type);
    }

    @Pure
    public static <T> Iterable<T> filterNull(Iterable<T> unfiltered) {
        return ao.filter(unfiltered, f.notNull());
    }

    @Pure
    public static <T, R> Iterable<R> map(Iterable<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        return ao.transform(original, new FunctionDelegate<T, R>(transformation));
    }

    @Inline(value="$2.$3concat($1)", imported={ao.class})
    public static <T> Iterable<T> flatten(Iterable<? extends Iterable<? extends T>> inputs) {
        return ao.concat(inputs);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedures.Procedure1<? super T> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        for (T t2 : iterable) {
            procedure.apply(t2);
        }
    }

    public static <T> void forEach(Iterable<T> iterable, Procedures.Procedure2<? super T, ? super Integer> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        int i2 = 0;
        for (T t2 : iterable) {
            procedure.apply(t2, i2);
            if (i2 == Integer.MAX_VALUE) continue;
            ++i2;
        }
    }

    public static String join(Iterable<?> iterable) {
        return IterableExtensions.join(iterable, "");
    }

    public static String join(Iterable<?> iterable, CharSequence separator) {
        return b.on(separator.toString()).useForNull("null").join(iterable);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence separator, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static <T> String join(Iterable<T> iterable, CharSequence before, CharSequence separator, CharSequence after, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        boolean notEmpty = iterator.hasNext();
        if (notEmpty && before != null) {
            result.append(before);
        }
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext() || separator == null) continue;
            result.append(separator);
        }
        if (notEmpty && after != null) {
            result.append(after);
        }
        return result.toString();
    }

    public static boolean elementsEqual(Iterable<?> iterable, Iterable<?> other) {
        return ao.elementsEqual(iterable, other);
    }

    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        return iterable == null || IterableExtensions.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static int size(Iterable<?> iterable) {
        return ao.size(iterable);
    }

    public static <T> T reduce(Iterable<? extends T> iterable, Functions.Function2<? super T, ? super T, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T result = iterator.next();
            while (iterator.hasNext()) {
                result = function.apply(result, iterator.next());
            }
            return result;
        }
        return null;
    }

    public static <T, R> R fold(Iterable<T> iterable, R seed, Functions.Function2<? super R, ? super T, ? extends R> function) {
        R result = seed;
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            result = function.apply(result, iterator.next());
        }
        return result;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List result = (List)iterable;
            return result;
        }
        return aq.newArrayList(iterable);
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        if (iterable instanceof Set) {
            Set result = (Set)iterable;
            return result;
        }
        return bd.newLinkedHashSet(iterable);
    }

    public static <K, V> Map<K, V> toInvertedMap(Iterable<? extends K> keys, Functions.Function1<? super K, V> computeValues) {
        LinkedHashMap<K, V> result = ar.newLinkedHashMap();
        for (K k2 : keys) {
            result.put(k2, computeValues.apply(k2));
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(Iterable<? extends V> values, Functions.Function1<? super V, K> computeKeys) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        LinkedHashMap<K, V> result = ar.newLinkedHashMap();
        for (V v2 : values) {
            result.put(computeKeys.apply(v2), v2);
        }
        return result;
    }

    public static <T extends Comparable<? super T>> List<T> sort(Iterable<T> iterable) {
        return ListExtensions.sortInplace(aq.newArrayList(iterable));
    }

    public static <T> List<T> sort(Iterable<T> iterable, Comparator<? super T> comparator) {
        return ListExtensions.sortInplace(aq.newArrayList(iterable), comparator);
    }

    public static <T, C extends Comparable<? super C>> List<T> sortBy(Iterable<T> iterable, Functions.Function1<? super T, C> key) {
        return ListExtensions.sortInplaceBy(aq.newArrayList(iterable), key);
    }
}

