/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.a;
import org.eclipse.xtext.xbase.lib.internal.ad;
import org.eclipse.xtext.xbase.lib.internal.ap;
import org.eclipse.xtext.xbase.lib.internal.aq;
import org.eclipse.xtext.xbase.lib.internal.au;
import org.eclipse.xtext.xbase.lib.internal.bk;
import org.eclipse.xtext.xbase.lib.internal.d;
import org.eclipse.xtext.xbase.lib.internal.e;
import org.eclipse.xtext.xbase.lib.internal.l;
import org.eclipse.xtext.xbase.lib.internal.r;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ao {
    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : ap.size(iterable.iterator());
    }

    public static boolean removeAll(Iterable<?> removeFrom, Collection<?> elementsToRemove) {
        return removeFrom instanceof Collection ? ((Collection)removeFrom).removeAll(d.checkNotNull(elementsToRemove)) : ap.removeAll(removeFrom.iterator(), elementsToRemove);
    }

    public static <T> boolean removeIf(Iterable<T> removeFrom, e<? super T> predicate) {
        if (removeFrom instanceof RandomAccess && removeFrom instanceof List) {
            return ao.removeIfFromRandomAccessList((List)removeFrom, d.checkNotNull(predicate));
        }
        return ap.removeIf(removeFrom.iterator(), predicate);
    }

    private static <T> boolean removeIfFromRandomAccessList(List<T> list, e<? super T> predicate) {
        int from;
        int to = 0;
        for (from = 0; from < list.size(); ++from) {
            T element = list.get(from);
            if (predicate.apply(element)) continue;
            if (from > to) {
                try {
                    list.set(to, element);
                }
                catch (UnsupportedOperationException e2) {
                    ao.slowRemoveIfForRemainingElements(list, predicate, to, from);
                    return true;
                }
            }
            ++to;
        }
        list.subList(to, list.size()).clear();
        return from != to;
    }

    private static <T> void slowRemoveIfForRemainingElements(List<T> list, e<? super T> predicate, int to, int from) {
        int n2;
        for (n2 = list.size() - 1; n2 > from; --n2) {
            if (!predicate.apply(list.get(n2))) continue;
            list.remove(n2);
        }
        for (n2 = from - 1; n2 >= to; --n2) {
            list.remove(n2);
        }
    }

    @Nullable
    static <T> T removeFirstMatching(Iterable<T> removeFrom, e<? super T> predicate) {
        d.checkNotNull(predicate);
        Iterator<T> iterator = removeFrom.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.apply(next)) continue;
            iterator.remove();
            return next;
        }
        return null;
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (collection1.size() != collection2.size()) {
                return false;
            }
        }
        return ap.elementsEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static String toString(Iterable<?> iterable) {
        return ap.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return ap.getOnlyElement(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        Collection<T> collection = ao.toCollection(iterable);
        T[] array = au.newArray(type, collection.size());
        return collection.toArray(array);
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : aq.newArrayList(iterable.iterator());
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c2 = l.cast(elementsToAdd);
            return addTo.addAll(c2);
        }
        return ap.addAll(addTo, d.checkNotNull(elementsToAdd).iterator());
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a2, Iterable<? extends T> b2) {
        return ao.concat(ad.of(a2, b2));
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> inputs) {
        d.checkNotNull(inputs);
        return new r<T>(){

            @Override
            public Iterator<T> iterator() {
                return ap.concat(ao.iterators(inputs));
            }
        };
    }

    private static <T> Iterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        return new bk<Iterable<? extends T>, Iterator<? extends T>>(iterables.iterator()){

            @Override
            Iterator<? extends T> transform(Iterable<? extends T> from) {
                return from.iterator();
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final e<? super T> predicate) {
        d.checkNotNull(unfiltered);
        d.checkNotNull(predicate);
        return new r<T>(){

            @Override
            public Iterator<T> iterator() {
                return ap.filter(unfiltered.iterator(), predicate);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<?> unfiltered, final Class<T> type) {
        d.checkNotNull(unfiltered);
        d.checkNotNull(type);
        return new r<T>(){

            @Override
            public Iterator<T> iterator() {
                return ap.filter(unfiltered.iterator(), type);
            }
        };
    }

    public static <T> boolean any(Iterable<T> iterable, e<? super T> predicate) {
        return ap.any(iterable.iterator(), predicate);
    }

    public static <T> boolean all(Iterable<T> iterable, e<? super T> predicate) {
        return ap.all(iterable.iterator(), predicate);
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final a<? super F, ? extends T> function) {
        d.checkNotNull(fromIterable);
        d.checkNotNull(function);
        return new r<T>(){

            @Override
            public Iterator<T> iterator() {
                return ap.transform(fromIterable.iterator(), function);
            }
        };
    }
}

