/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.ad;
import org.eclipse.xtext.xbase.lib.internal.ai;
import org.eclipse.xtext.xbase.lib.internal.al;
import org.eclipse.xtext.xbase.lib.internal.am;
import org.eclipse.xtext.xbase.lib.internal.av;
import org.eclipse.xtext.xbase.lib.internal.bb;
import org.eclipse.xtext.xbase.lib.internal.bc;
import org.eclipse.xtext.xbase.lib.internal.d;
import org.eclipse.xtext.xbase.lib.internal.p;
import org.eclipse.xtext.xbase.lib.internal.z;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ak<K, V>
extends al<K, V>
implements SortedMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = av.natural();
    private static final ak<Comparable, Object> NATURAL_EMPTY_MAP = new p<Comparable, Object>(NATURAL_ORDER);

    static <K, V> ak<K, V> emptyMap(Comparator<? super K> comparator) {
        if (av.natural().equals(comparator)) {
            return ak.of();
        }
        return new p(comparator);
    }

    static <K, V> ak<K, V> fromSortedEntries(Comparator<? super K> comparator, int size, Map.Entry<K, V>[] entries) {
        if (size == 0) {
            return ak.emptyMap(comparator);
        }
        ad.a keyBuilder = ad.builder();
        ad.a valueBuilder = ad.builder();
        for (int i2 = 0; i2 < size; ++i2) {
            Map.Entry<K, V> entry = entries[i2];
            keyBuilder.add(entry.getKey());
            valueBuilder.add(entry.getValue());
        }
        return new bb(new bc<K>(keyBuilder.build(), comparator), valueBuilder.build());
    }

    static <K, V> ak<K, V> from(am<K> keySet, ad<V> valueList) {
        if (keySet.isEmpty()) {
            return ak.emptyMap(keySet.comparator());
        }
        return new bb((bc)keySet, valueList);
    }

    public static <K, V> ak<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    public static <K, V> ak<K, V> copyOfSorted(SortedMap<K, ? extends V> map) {
        Comparator<Object> comparator = map.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return ak.copyOfInternal(map, comparator);
    }

    private static <K, V> ak<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        ak kvMap;
        boolean sameComparator = false;
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            Comparator comparator2 = sortedMap.comparator();
            boolean bl2 = comparator2 == null ? comparator == NATURAL_ORDER : (sameComparator = comparator.equals(comparator2));
        }
        if (sameComparator && map instanceof ak && !(kvMap = (ak)map).isPartialView()) {
            return kvMap;
        }
        Map.Entry[] entries = map.entrySet().toArray(new Map.Entry[0]);
        return ak.fromEntries(comparator, sameComparator, entries.length, entries);
    }

    static <K, V> ak<K, V> fromEntries(Comparator<? super K> comparator, boolean sameComparator, int size, Map.Entry<K, V> ... entries) {
        for (int i2 = 0; i2 < size; ++i2) {
            Map.Entry<K, V> entry = entries[i2];
            entries[i2] = ak.entryOf(entry.getKey(), entry.getValue());
        }
        if (!sameComparator) {
            ak.sortEntries(comparator, size, entries);
            ak.validateEntries(size, entries, comparator);
        }
        return ak.fromSortedEntries(comparator, size, entries);
    }

    private static <K, V> void sortEntries(Comparator<? super K> comparator, int size, Map.Entry<K, V>[] entries) {
        Arrays.sort(entries, 0, size, av.from(comparator).onKeys());
    }

    private static <K, V> void validateEntries(int size, Map.Entry<K, V>[] entries, Comparator<? super K> comparator) {
        for (int i2 = 1; i2 < size; ++i2) {
            ak.checkNoConflict(comparator.compare(entries[i2 - 1].getKey(), entries[i2].getKey()) != 0, "key", entries[i2 - 1], entries[i2]);
        }
    }

    ak() {
    }

    @Override
    public int size() {
        return ((AbstractCollection)this.values()).size();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return ((z)this.values()).contains(value);
    }

    @Override
    boolean isPartialView() {
        return this.keySet().isPartialView() || ((z)this.values()).isPartialView();
    }

    @Override
    public ai<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    public abstract am<K> keySet();

    @Override
    public abstract z<V> values();

    @Override
    public Comparator<? super K> comparator() {
        return ((am)this.keySet()).comparator();
    }

    @Override
    public K firstKey() {
        return (K)((am)this.keySet()).first();
    }

    @Override
    public K lastKey() {
        return (K)((am)this.keySet()).last();
    }

    @Override
    public ak<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    public abstract ak<K, V> headMap(K var1, boolean var2);

    @Override
    public ak<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public ak<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        d.checkNotNull(fromKey);
        d.checkNotNull(toKey);
        d.checkArgument(this.comparator().compare(fromKey, toKey) <= 0, "expected fromKey <= toKey but %s > %s", fromKey, toKey);
        return this.headMap(toKey, toInclusive).tailMap(fromKey, fromInclusive);
    }

    @Override
    public ak<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    public abstract ak<K, V> tailMap(K var1, boolean var2);
}

