/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JavaVersion;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

public class OverrideProposalUtil {
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IVisibilityHelper visibilityHelper;

    public List<IResolvedExecutable> getImplementationCandidates(JvmDeclaredType type, boolean isAnonymous) {
        boolean _isInterface;
        boolean _not;
        if (type == null || !(type instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        GeneratorConfig _get = this.generatorConfigProvider.get((EObject)type);
        JavaVersion sourceVersion = _get.getJavaSourceVersion();
        ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(type, sourceVersion);
        ArrayList result = Lists.newArrayList();
        LightweightTypeReference _type = resolvedFeatures.getType();
        ContextualVisibilityHelper contextualVisibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, _type);
        this.addOperationCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        boolean _and = false;
        _and = isAnonymous ? false : (_not = !(_isInterface = ((JvmGenericType)type).isInterface()));
        if (_and) {
            this.addConstructorCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        }
        return result;
    }

    protected void addOperationCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        List allOperations = resolvedFeatures.getAllOperations();
        LightweightTypeReference inferredType = resolvedFeatures.getType();
        for (IResolvedOperation operation : allOperations) {
            boolean _isCandidate = this.isCandidate(inferredType, (IResolvedExecutable)operation, visibilityHelper);
            if (!_isCandidate) continue;
            result.add((IResolvedExecutable)operation);
        }
    }

    protected void addConstructorCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        LightweightTypeReference typeReference = resolvedFeatures.getType();
        List superTypes = typeReference.getSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            boolean _not;
            boolean _isInterfaceType = superType.isInterfaceType();
            boolean bl = _not = !_isInterfaceType;
            if (!_not) continue;
            List declaredConstructors = resolvedFeatures.getDeclaredConstructors();
            HashSet erasedSignatures = Sets.newHashSet();
            for (IResolvedConstructor constructor : declaredConstructors) {
                String _resolvedErasureSignature = constructor.getResolvedErasureSignature();
                erasedSignatures.add(_resolvedErasureSignature);
            }
            ResolvedFeatures superClass = this.overrideHelper.getResolvedFeatures(superType);
            List constructors = superClass.getDeclaredConstructors();
            for (IResolvedConstructor constructor_1 : constructors) {
                String _resolvedErasureSignature_1;
                boolean _add;
                JvmConstructor _declaration = constructor_1.getDeclaration();
                ResolvedConstructor overriddenConstructor = new ResolvedConstructor(_declaration, typeReference);
                boolean _isCandidate = this.isCandidate(typeReference, (IResolvedExecutable)overriddenConstructor, visibilityHelper);
                if (!_isCandidate || !(_add = erasedSignatures.add(_resolvedErasureSignature_1 = constructor_1.getResolvedErasureSignature()))) continue;
                result.add((IResolvedExecutable)overriddenConstructor);
            }
            return;
        }
    }

    protected boolean isCandidate(LightweightTypeReference type, IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        boolean _isVisible;
        JvmExecutable _declaration = executable.getDeclaration();
        JvmDeclaredType declaringType = _declaration.getDeclaringType();
        boolean _and = false;
        JvmType _type = type.getType();
        boolean _tripleNotEquals = _type != declaringType;
        _and = !_tripleNotEquals ? false : (_isVisible = this.isVisible(executable, visibilityHelper));
        if (_and) {
            JvmExecutable rawExecutable = executable.getDeclaration();
            if (rawExecutable instanceof JvmOperation) {
                boolean _isStatic;
                JvmOperation operation = (JvmOperation)rawExecutable;
                boolean _or = false;
                boolean _isFinal = operation.isFinal();
                _or = _isFinal ? true : (_isStatic = operation.isStatic());
                if (_or) {
                    return false;
                }
                boolean _and_1 = false;
                JvmType _type_1 = type.getType();
                if (!(_type_1 instanceof JvmGenericType)) {
                    _and_1 = false;
                } else {
                    boolean _isInterface;
                    JvmType _type_2 = type.getType();
                    _and_1 = _isInterface = ((JvmGenericType)_type_2).isInterface();
                }
                if (_and_1) {
                    boolean _isAbstract;
                    boolean _not;
                    boolean _isInterface_1;
                    boolean _and_2 = false;
                    boolean _and_3 = false;
                    _and_3 = !(declaringType instanceof JvmGenericType) ? false : (_isInterface_1 = ((JvmGenericType)declaringType).isInterface());
                    _and_2 = !_and_3 ? false : (_not = !(_isAbstract = operation.isAbstract()));
                    return _and_2;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean isVisible(IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        JvmExecutable _declaration = executable.getDeclaration();
        return visibilityHelper.isVisible((JvmMember)_declaration);
    }
}

