/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.generator.GeneratorResult;
import org.eclipse.xtext.web.server.generator.IContentTypeProvider;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class GeneratorService
extends AbstractCachedService<GeneratedArtifacts> {
    public static final String DEFAULT_ARTIFACT = "DEFAULT_OUTPUT/DEFAULT_ARTIFACT";
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private IContentTypeProvider contentTypeProvider;
    @Inject
    private Provider<InMemoryFileSystemAccess> fileSystemAccessProvider;

    @Override
    public GeneratedArtifacts compute(IXtextWebDocument it, final CancelIndicator cancelIndicator) {
        InMemoryFileSystemAccess fileSystemAccess = (InMemoryFileSystemAccess)this.fileSystemAccessProvider.get();
        XtextResource _resource = it.getResource();
        IGeneratorContext _function = new IGeneratorContext(){

            public CancelIndicator getCancelIndicator() {
                return cancelIndicator;
            }
        };
        this.generator.generate((Resource)_resource, (IFileSystemAccess2)fileSystemAccess, _function);
        GeneratedArtifacts result = new GeneratedArtifacts();
        Map _textFiles = fileSystemAccess.getTextFiles();
        Set _entrySet = _textFiles.entrySet();
        Functions.Function1<Map.Entry<String, CharSequence>, GeneratorResult> _function_1 = new Functions.Function1<Map.Entry<String, CharSequence>, GeneratorResult>(){

            public GeneratorResult apply(Map.Entry<String, CharSequence> it) {
                GeneratorResult _xblockexpression = null;
                String _key = it.getKey();
                String contentType = GeneratorService.this.contentTypeProvider.getContentType(_key);
                String _key_1 = it.getKey();
                CharSequence _value = it.getValue();
                String _string = _value.toString();
                _xblockexpression = new GeneratorResult(_key_1, contentType, _string);
                return _xblockexpression;
            }
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)result.artifacts, (Iterable)_map);
        return result;
    }

    public GeneratorResult getArtifact(XtextWebDocumentAccess document, String artifactId) {
        boolean _startsWith;
        boolean _not;
        GeneratedArtifacts _result = (GeneratedArtifacts)this.getResult(document);
        List artifacts = _result.artifacts;
        String _elvis = null;
        _elvis = artifactId != null ? artifactId : DEFAULT_ARTIFACT;
        final String searchString = _elvis;
        Functions.Function1<GeneratorResult, Boolean> _function = new Functions.Function1<GeneratorResult, Boolean>(){

            public Boolean apply(GeneratorResult it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)searchString);
            }
        };
        GeneratorResult result = (GeneratorResult)IterableExtensions.findFirst((Iterable)artifacts, (Functions.Function1)_function);
        boolean _and = false;
        _and = result != null ? false : (_not = !(_startsWith = searchString.startsWith("DEFAULT_OUTPUT")));
        if (_and) {
            GeneratorResult _findFirst;
            final String defaultSearchString = "DEFAULT_OUTPUT" + searchString;
            Functions.Function1<GeneratorResult, Boolean> _function_1 = new Functions.Function1<GeneratorResult, Boolean>(){

                public Boolean apply(GeneratorResult it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)defaultSearchString);
                }
            };
            result = _findFirst = (GeneratorResult)IterableExtensions.findFirst((Iterable)artifacts, (Functions.Function1)_function_1);
        }
        if (result == null) {
            throw new InvalidRequestException.ResourceNotFoundException("The requested generator artifact was not found.");
        }
        return result;
    }

    @Data
    public static class GeneratedArtifacts
    implements IServiceResult {
        private final List<GeneratorResult> artifacts = CollectionLiterals.newArrayList((Object[])new GeneratorResult[0]);

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifacts == null ? 0 : this.artifacts.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedArtifacts other = (GeneratedArtifacts)obj;
            return !(this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("artifacts", this.artifacts);
            return b.toString();
        }

        @Pure
        public List<GeneratorResult> getArtifacts() {
            return this.artifacts;
        }
    }
}

