/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ContentAssistService {
    public static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private IdeContentProposalProvider proposalProvider;
    @Inject
    private ExecutorService executorService;

    public ContentAssistResult createProposals(XtextWebDocumentAccess document, final ITextRegion selection, final int offset, int proposalsLimit) throws InvalidRequestException {
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        Procedures.Procedure1<ContentAssistContextFactory> _function = new Procedures.Procedure1<ContentAssistContextFactory>(){

            public void apply(ContentAssistContextFactory it) {
                it.setPool(ContentAssistService.this.executorService);
            }
        };
        final ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function_1 = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _stateId;
                ContentAssistContext[] _xblockexpression = null;
                stateIdWrapper[0] = _stateId = it.getStateId();
                String _text = it.getText();
                XtextResource _resource = it.getResource();
                _xblockexpression = contextFactory.create(_text, selection, offset, _resource);
                return _xblockexpression;
            }
        };
        ContentAssistContext[] contexts = document.priorityReadOnly(_function_1);
        String _get_1 = stateIdWrapper[0];
        return this.createProposals((List)Conversions.doWrapArray((Object)contexts), _get_1, proposalsLimit);
    }

    public ContentAssistResult createProposalsWithUpdate(XtextWebDocumentAccess document, final String deltaText, final int deltaOffset, final int deltaReplaceLength, final ITextRegion textSelection, final int caretOffset, int proposalsLimit) throws InvalidRequestException {
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        Procedures.Procedure1<ContentAssistContextFactory> _function = new Procedures.Procedure1<ContentAssistContextFactory>(){

            public void apply(ContentAssistContextFactory it) {
                it.setPool(ContentAssistService.this.executorService);
            }
        };
        final ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function_1 = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _stateId;
                ContentAssistContext[] _xblockexpression = null;
                it.setDirty(true);
                it.createNewStateId();
                stateIdWrapper[0] = _stateId = it.getStateId();
                it.updateText(deltaText, deltaOffset, deltaReplaceLength);
                String _text = it.getText();
                XtextResource _resource = it.getResource();
                _xblockexpression = contextFactory.create(_text, textSelection, caretOffset, _resource);
                return _xblockexpression;
            }
        };
        ContentAssistContext[] contexts = document.modify(_function_1);
        String _get_1 = stateIdWrapper[0];
        return this.createProposals((List)Conversions.doWrapArray((Object)contexts), _get_1, proposalsLimit);
    }

    protected ContentAssistResult createProposals(List<ContentAssistContext> contexts, String stateId, final int proposalsLimit) {
        boolean _not;
        ContentAssistResult result = new ContentAssistResult(stateId);
        boolean _isEmpty = contexts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            final HashSet proposals = new HashSet();
            IIdeContentProposalAcceptor acceptor = new IIdeContentProposalAcceptor(){

                public void accept(ContentAssistEntry entry, int priority) {
                    Pair _mappedTo = Pair.of((Object)priority, (Object)entry);
                    proposals.add(_mappedTo);
                }

                public boolean canAcceptMoreProposals() {
                    int _size = proposals.size();
                    return _size < proposalsLimit;
                }
            };
            this.proposalProvider.createProposals(contexts, acceptor);
            List<ContentAssistEntry> _entries = result.getEntries();
            Comparator<Pair<Integer, ContentAssistEntry>> _function = new Comparator<Pair<Integer, ContentAssistEntry>>(){

                @Override
                public int compare(Pair<Integer, ContentAssistEntry> p1, Pair<Integer, ContentAssistEntry> p2) {
                    boolean _tripleNotEquals_3;
                    boolean _tripleNotEquals_2;
                    String _label_1;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    Integer _key_1;
                    Integer _key = (Integer)p2.getKey();
                    int prioResult = _key.compareTo(_key_1 = (Integer)p1.getKey());
                    if (prioResult != 0) {
                        return prioResult;
                    }
                    ContentAssistEntry v1 = (ContentAssistEntry)p1.getValue();
                    ContentAssistEntry v2 = (ContentAssistEntry)p2.getValue();
                    boolean _and = false;
                    String _label = v1.getLabel();
                    boolean bl = _tripleNotEquals = _label != null;
                    _and = !_tripleNotEquals ? false : (_tripleNotEquals_1 = (_label_1 = v2.getLabel()) != null);
                    if (_and) {
                        String _label_2 = v1.getLabel();
                        String _label_3 = v2.getLabel();
                        return _label_2.compareTo(_label_3);
                    }
                    String _label_4 = v1.getLabel();
                    boolean bl2 = _tripleNotEquals_2 = _label_4 != null;
                    if (_tripleNotEquals_2) {
                        String _label_5 = v1.getLabel();
                        String _proposal = v2.getProposal();
                        return _label_5.compareTo(_proposal);
                    }
                    String _label_6 = v2.getLabel();
                    boolean bl3 = _tripleNotEquals_3 = _label_6 != null;
                    if (_tripleNotEquals_3) {
                        String _proposal_1 = v1.getProposal();
                        String _label_7 = v2.getLabel();
                        return _proposal_1.compareTo(_label_7);
                    }
                    String _proposal_2 = v1.getProposal();
                    String _proposal_3 = v2.getProposal();
                    return _proposal_2.compareTo(_proposal_3);
                }
            };
            List _sortWith = IterableExtensions.sortWith(proposals, (Comparator)_function);
            Functions.Function1<Pair<Integer, ContentAssistEntry>, ContentAssistEntry> _function_1 = new Functions.Function1<Pair<Integer, ContentAssistEntry>, ContentAssistEntry>(){

                public ContentAssistEntry apply(Pair<Integer, ContentAssistEntry> it) {
                    return (ContentAssistEntry)it.getValue();
                }
            };
            List _map = ListExtensions.map((List)_sortWith, (Functions.Function1)_function_1);
            _entries.addAll(_map);
        }
        return result;
    }
}

