/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.hover;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.labels.AlternativeImageDescription;
import org.eclipse.xtext.ide.labels.DecoratedImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescriptionProvider;
import org.eclipse.xtext.ide.labels.INameLabelProvider;
import org.eclipse.xtext.ide.labels.SimpleImageDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.hover.HoverResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.util.ElementAtOffsetUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class HoverService {
    @Inject
    @Extension
    private ElementAtOffsetUtil _elementAtOffsetUtil;
    @Inject
    @Extension
    private IEObjectDocumentationProvider _iEObjectDocumentationProvider;
    @Inject
    @Extension
    private IImageDescriptionProvider _iImageDescriptionProvider;
    @Inject
    @Extension
    private INameLabelProvider _iNameLabelProvider;
    @Inject
    @Extension
    private OperationCanceledManager _operationCanceledManager;

    public HoverResult getHover(XtextWebDocumentAccess document, final int offset) {
        CancelableUnitOfWork<HoverResult, IXtextWebDocument> _function = new CancelableUnitOfWork<HoverResult, IXtextWebDocument>(){

            public HoverResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String nameLabel;
                boolean _notEquals;
                XtextResource _resource = it.getResource();
                EObject element = HoverService.this._elementAtOffsetUtil.getElementAt(_resource, offset);
                String _nameLabel = null;
                if (element != null) {
                    _nameLabel = HoverService.this._iNameLabelProvider.getNameLabel((Object)element);
                }
                String _surroundWithDiv = null;
                if (_nameLabel != null) {
                    _surroundWithDiv = HoverService.this.surroundWithDiv(_nameLabel, "element-name");
                }
                boolean bl = _notEquals = !Objects.equal(nameLabel = _surroundWithDiv, null);
                if (_notEquals) {
                    HoverService.this._operationCanceledManager.checkCanceled(cancelIndicator);
                    IImageDescription _imageDescription = HoverService.this._iImageDescriptionProvider.getImageDescription((Object)element);
                    String _addIconDivs = HoverService.this.addIconDivs(_imageDescription, nameLabel);
                    String titleHtml = HoverService.this.surroundWithDiv(_addIconDivs, "xtext-hover");
                    HoverService.this._operationCanceledManager.checkCanceled(cancelIndicator);
                    String _elvis = null;
                    String _documentation = HoverService.this._iEObjectDocumentationProvider.getDocumentation(element);
                    _elvis = _documentation != null ? _documentation : "";
                    String bodyHtml = HoverService.this.surroundWithDiv(_elvis, "xtext-hover");
                    String _stateId = it.getStateId();
                    return new HoverResult(_stateId, titleHtml, bodyHtml);
                }
                String _stateId_1 = it.getStateId();
                return new HoverResult(_stateId_1);
            }
        };
        return document.readOnly(_function);
    }

    protected String addIconDivs(IImageDescription it, String nameHtml) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && it instanceof SimpleImageDescription) {
            _matched = true;
            String _imageID = ((SimpleImageDescription)it).getImageID();
            String _plus = _imageID + "-icon";
            _switchResult = this.surroundWithDiv(nameHtml, _plus);
        }
        if (!_matched && it instanceof AlternativeImageDescription) {
            _matched = true;
            List _imageIDs = ((AlternativeImageDescription)it).getImageIDs();
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it + "-icon";
                }
            };
            List _map = ListExtensions.map((List)_imageIDs, (Functions.Function1)_function);
            _switchResult = this.surroundWithDiv(nameHtml, (String[])Conversions.unwrapArray((Object)_map, String.class));
        }
        if (!_matched && it instanceof DecoratedImageDescription) {
            _matched = true;
            List _decorators = ((DecoratedImageDescription)it).getDecorators();
            IImageDescription _baseImage = ((DecoratedImageDescription)it).getBaseImage();
            Iterable _plus = Iterables.concat((Iterable)_decorators, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IImageDescription[]{_baseImage})));
            Functions.Function2<String, IImageDescription, String> _function = new Functions.Function2<String, IImageDescription, String>(){

                public String apply(String $0, IImageDescription $1) {
                    return HoverService.this.addIconDivs($1, $0);
                }
            };
            _switchResult = (String)IterableExtensions.fold((Iterable)_plus, (Object)nameHtml, (Functions.Function2)_function);
        }
        return _switchResult;
    }

    protected String surroundWithDiv(String html, String ... divClasses) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<div class=\"");
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it;
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)divClasses)), (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" ");
        _builder.append((Object)_join, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)html, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</div>");
        _builder.newLine();
        return _builder.toString();
    }
}

