/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.generator;

import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ResponseFileSystemAccess
implements IFileSystemAccess {
    @Accessors
    private final List<ResponseFile> files = CollectionLiterals.newArrayList((Object[])new ResponseFile[0]);

    public void generateFile(String fileName, CharSequence contents) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fileName);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.deleteFile(fileName);
        }
        ResponseFile _responseFile = new ResponseFile(fileName, contents);
        this.files.add(_responseFile);
    }

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        boolean _equals = Objects.equal((Object)outputConfigurationName, (Object)"DEFAULT_OUTPUT");
        if (_equals) {
            this.generateFile(fileName, contents);
        }
    }

    public void deleteFile(String fileName) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        Iterator<ResponseFile> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            ResponseFile _next = iterator.next();
            boolean _equals = Objects.equal((Object)_next.name, (Object)fileName);
            if (!_equals) continue;
            iterator.remove();
            return;
        }
    }

    @Pure
    public List<ResponseFile> getFiles() {
        return this.files;
    }

    @Data
    public static class ResponseFile {
        private final String name;
        private final CharSequence content;

        public ResponseFile(String name, CharSequence content) {
            this.name = name;
            this.content = content;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseFile other = (ResponseFile)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.content == null ? other.content != null : !this.content.equals(other.content));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("content", (Object)this.content);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public CharSequence getContent() {
            return this.content;
        }
    }
}

