/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.validation.ValidationResult;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ValidationService {
    @Inject
    @Extension
    private UpdateDocumentService updateDocumentService;

    public ValidationResult validate(XtextWebDocumentAccess document) throws InvalidRequestException {
        CancelableUnitOfWork<Collection<Issue>, IXtextWebDocument> _function = new CancelableUnitOfWork<Collection<Issue>, IXtextWebDocument>(){

            public Collection<Issue> exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                ValidationService.this.updateDocumentService.processUpdatedDocument(it, cancelIndicator);
                return it.getIssues();
            }
        };
        Collection<Issue> issues = document.readOnly(_function);
        final ValidationResult result = new ValidationResult();
        Functions.Function1<Issue, Boolean> _function_1 = new Functions.Function1<Issue, Boolean>(){

            public Boolean apply(Issue it) {
                Severity _severity = it.getSeverity();
                return !Objects.equal((Object)_severity, (Object)Severity.IGNORE);
            }
        };
        Iterable _filter = IterableExtensions.filter(issues, (Functions.Function1)_function_1);
        Procedures.Procedure1<Issue> _function_2 = new Procedures.Procedure1<Issue>(){

            public void apply(Issue issue) {
                ArrayList<ValidationResult.Entry> _entries = result.getEntries();
                String _message = issue.getMessage();
                Severity _severity = issue.getSeverity();
                String _translate = ValidationService.this.translate(_severity);
                Integer _lineNumber = issue.getLineNumber();
                Integer _offset = issue.getOffset();
                Integer _offset_1 = issue.getOffset();
                Integer _length = issue.getLength();
                int _plus = _offset_1 + _length;
                ValidationResult.Entry _entry = new ValidationResult.Entry(_message, _translate, _lineNumber, _offset, _plus);
                _entries.add(_entry);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_2);
        return result;
    }

    protected String translate(Severity severity) {
        String _switchResult = null;
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    _switchResult = "warning";
                    break;
                }
                case ERROR: {
                    _switchResult = "error";
                    break;
                }
                case INFO: {
                    _switchResult = "info";
                    break;
                }
                default: {
                    _switchResult = "ignore";
                    break;
                }
            }
        } else {
            _switchResult = "ignore";
        }
        return _switchResult;
    }
}

