/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextWebDocumentAccess {
    private static final Logger LOG = Logger.getLogger(XtextWebDocumentAccess.class);
    private final ReadAccess readOnlyAccess = new ReadAccess();
    private final ModifyAccess modifyAccess = new ModifyAccess();
    private final XtextWebDocument document;
    private final String requiredStateId;

    public XtextWebDocumentAccess(XtextWebDocument document, String requiredStateId) throws InvalidRequestException {
        this.document = document;
        this.requiredStateId = requiredStateId;
        this.checkStateId();
    }

    public XtextWebDocumentAccess(XtextWebDocument document) {
        this.document = document;
        this.requiredStateId = null;
    }

    protected void checkStateId() throws InvalidRequestException {
        if (this.requiredStateId != null && !this.requiredStateId.equals(this.document.getStateId())) {
            throw new InvalidRequestException(InvalidRequestException.Type.INVALID_DOCUMENT_STATE, "The given state id does not match the current state.");
        }
    }

    public <T> T readOnly(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, false, false, null);
    }

    public <T> T priorityReadOnly(CancelableUnitOfWork<T, IXtextWebDocument> work, CancelableUnitOfWork<T, IXtextWebDocument> asynchronousWork) {
        return this.doAccess(work, true, false, asynchronousWork);
    }

    public <T> T modify(CancelableUnitOfWork<T, IXtextWebDocument> work, CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        return this.doAccess(work, true, true, asynchronousWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected <T> T doAccess(CancelableUnitOfWork<T, IXtextWebDocument> synchronousWork, boolean priority, boolean modify, CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        Object object;
        ReadAccess documentAccess;
        DocumentSynchronizer synchronizer;
        block13: {
            block12: {
                synchronizer = this.document.getSynchronizer();
                documentAccess = null;
                synchronizer.acquireLock(priority);
                this.checkStateId();
                synchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                documentAccess = modify ? this.modifyAccess : this.readOnlyAccess;
                object = synchronousWork.exec((Object)documentAccess);
                if (asynchronousWork != null && documentAccess != null && !synchronizer.isCanceled() && !Thread.currentThread().isInterrupted()) break block12;
                synchronizer.releaseLock();
                break block13;
            }
            asynchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
            ReadAccess asyncAccess = documentAccess;
            try {
                synchronizer.getExecutorService().submit(new Runnable(asynchronousWork, asyncAccess, synchronizer){
                    final /* synthetic */ CancelableUnitOfWork val$asynchronousWork;
                    final /* synthetic */ IXtextWebDocument val$asyncAccess;
                    final /* synthetic */ DocumentSynchronizer val$synchronizer;
                    {
                        this.val$asynchronousWork = cancelableUnitOfWork;
                        this.val$asyncAccess = iXtextWebDocument;
                        this.val$synchronizer = documentSynchronizer;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.val$asynchronousWork.exec((Object)this.val$asyncAccess);
                        }
                        catch (VirtualMachineError error) {
                            throw error;
                        }
                        catch (Throwable throwable) {
                            if (!this.val$synchronizer.getOperationCanceledManager().isOperationCanceledException(throwable)) {
                                LOG.error((Object)"Error during asynchronous service processing.", throwable);
                            } else {
                                LOG.trace((Object)"Canceling background process.");
                            }
                        }
                        finally {
                            this.val$synchronizer.releaseLock();
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                synchronizer.releaseLock();
                LOG.error((Object)"Failed to start background work.", (Throwable)ree);
            }
        }
        return (T)object;
        catch (Exception exception) {
            T t;
            block15: {
                block14: {
                    try {
                        Exceptions.sneakyThrow((Throwable)exception);
                        t = null;
                        if (asynchronousWork != null && documentAccess != null && !synchronizer.isCanceled() && !Thread.currentThread().isInterrupted()) break block14;
                        synchronizer.releaseLock();
                        break block15;
                    }
                    catch (Throwable throwable) {
                        if (asynchronousWork == null || documentAccess == null || synchronizer.isCanceled() || Thread.currentThread().isInterrupted()) {
                            synchronizer.releaseLock();
                        } else {
                            asynchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                            ReadAccess asyncAccess2 = documentAccess;
                            try {
                                synchronizer.getExecutorService().submit(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (RejectedExecutionException ree) {
                                synchronizer.releaseLock();
                                LOG.error((Object)"Failed to start background work.", (Throwable)ree);
                            }
                        }
                        throw throwable;
                    }
                }
                asynchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                ReadAccess asyncAccess3 = documentAccess;
                try {
                    synchronizer.getExecutorService().submit(new /* invalid duplicate definition of identical inner class */);
                }
                catch (RejectedExecutionException ree) {
                    synchronizer.releaseLock();
                    LOG.error((Object)"Failed to start background work.", (Throwable)ree);
                }
            }
            return t;
        }
    }

    protected class ModifyAccess
    extends ReadAccess {
        protected ModifyAccess() {
        }

        @Override
        public void setText(String text) {
            XtextWebDocumentAccess.this.document.setText(text);
        }

        @Override
        public void updateText(String text, int offset, int replaceLength) {
            XtextWebDocumentAccess.this.document.updateText(text, offset, replaceLength);
        }

        @Override
        public void createNewStateId() {
            XtextWebDocumentAccess.this.document.createNewStateId();
        }
    }

    protected class ReadAccess
    implements IXtextWebDocument {
        protected ReadAccess() {
        }

        @Override
        public XtextResource getResource() {
            return XtextWebDocumentAccess.this.document.getResource();
        }

        @Override
        public String getResourceId() {
            return XtextWebDocumentAccess.this.document.getResourceId();
        }

        @Override
        public String getText() {
            return XtextWebDocumentAccess.this.document.getText();
        }

        @Override
        public String getStateId() {
            return XtextWebDocumentAccess.this.document.getStateId();
        }

        @Override
        public boolean isDirty() {
            return XtextWebDocumentAccess.this.document.isDirty();
        }

        @Override
        public boolean isProcessingCompleted() {
            return XtextWebDocumentAccess.this.document.isProcessingCompleted();
        }

        @Override
        public Collection<Issue> getIssues() {
            return XtextWebDocumentAccess.this.document.getIssues();
        }

        @Override
        public void setDirty(boolean dirty) {
            XtextWebDocumentAccess.this.document.setDirty(dirty);
        }

        @Override
        public void setProcessingCompleted(boolean completed) {
            XtextWebDocumentAccess.this.document.setProcessingCompleted(completed);
        }

        @Override
        public void setText(String text) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void updateText(String text, int offset, int replaceLength) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void createNewStateId() {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }
    }
}

